/******************************************************************************/
/***          Generated by IBExpert 2012.02.21 02/07/2014 11:27:18          ***/
/******************************************************************************/

/* AJUSTES NO BANCO DE DADOS


*/

/******************************************************************************/
/***                                Domains                                 ***/
/******************************************************************************/

CREATE DOMAIN BL AS
BLOB SUB_TYPE 0 SEGMENT SIZE 80;

CREATE DOMAIN CD_10 AS
VARCHAR(10) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN CD_20 AS
VARCHAR(20) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN CD_PLACA AS
CHAR(8) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN DT AS
TIMESTAMP;

CREATE DOMAIN HR AS
CHAR(5) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN HS AS
CHAR(8) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN HT AS
CHAR(6) CHARACTER SET WIN1252
DEFAULT ' 00:00'
COLLATE WIN1252;

CREATE DOMAIN ID AS
INTEGER;

CREATE DOMAIN NI AS
INTEGER;

CREATE DOMAIN NR AS
NUMERIC(15,3);

CREATE DOMAIN PL AS
NUMERIC(9,6);

CREATE DOMAIN PR AS
NUMERIC(5,2)
DEFAULT 0;

CREATE DOMAIN TL AS
BLOB SUB_TYPE 1 SEGMENT SIZE 80 CHARACTER SET WIN1252;

CREATE DOMAIN TP_1 AS
CHAR(1) CHARACTER SET WIN1252
DEFAULT ' '
COLLATE WIN1252;

CREATE DOMAIN TP_2 AS
CHAR(2) CHARACTER SET WIN1252
DEFAULT ' '
COLLATE WIN1252;

CREATE DOMAIN TP_3 AS
CHAR(3) CHARACTER SET WIN1252
DEFAULT ' '
COLLATE WIN1252;

CREATE DOMAIN TX_10 AS
VARCHAR(10) CHARACTER SET WIN1252
COLLATE PXW_INTL850;

CREATE DOMAIN TX_100 AS
VARCHAR(100) CHARACTER SET WIN1252
COLLATE PXW_INTL850;

CREATE DOMAIN TX_20 AS
VARCHAR(20) CHARACTER SET WIN1252
COLLATE PXW_INTL850;

CREATE DOMAIN TX_200 AS
VARCHAR(200) CHARACTER SET WIN1252
COLLATE PXW_INTL850;

CREATE DOMAIN TX_255 AS
VARCHAR(255) CHARACTER SET WIN1252
COLLATE PXW_INTL850;

CREATE DOMAIN TX_40 AS
VARCHAR(40) CHARACTER SET WIN1252
COLLATE PXW_INTL850;

CREATE DOMAIN TX_60 AS
VARCHAR(60) CHARACTER SET WIN1252
COLLATE PXW_INTL850;

CREATE DOMAIN TX_CEP AS
CHAR(9) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN TX_CI AS
VARCHAR(60) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN TX_CNPJ AS
CHAR(18) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN TX_CPF AS
CHAR(14) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN TX_ESTADO AS
CHAR(2) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN TX_IE AS
VARCHAR(15) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN TX_IM AS
VARCHAR(20) CHARACTER SET WIN1252
COLLATE WIN1252;

CREATE DOMAIN TX_UNIDADE AS
VARCHAR(6) CHARACTER SET WIN1252
COLLATE WIN1252;

-- CREATE DOMAIN GUID AS
-- VARCHAR(36);

CREATE DOMAIN VL AS
NUMERIC(15,2)
DEFAULT 0;



/******************************************************************************/
/***                               Exceptions                               ***/
/******************************************************************************/

/******************************************************************************/
/***                               Procedures                               ***/
/******************************************************************************/

SET TERM ^ ;

SET TERM ; ^



/******************************************************************************/
/***                            Tables and Views                            ***/
/******************************************************************************/

CREATE TABLE BLD_CONFIGURACAO (
    ID_CONFIGURACAO INTEGER NOT NULL,
    TP_CODIGO_OBRA TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE BLD_OBRAS (
    ID_OBRA ID NOT NULL,
    ID_CENTROCUSTO ID,
    ID_CLIENTE ID,
    ID_TIPOOBRA ID,
    CD_OBRA CD_10,
    TX_DESCRICAO TX_60,
    VL_OBRA VL,
    PR_COMPRAS PR,
    PR_AVISO PR,
    TX_EMAILS TX_100,
    TX_PRAZO TX_20,
    DT_INICIO DT,
    DT_TERMINO DT,
    NR_MEDICOES INTEGER,
    TP_SITUACAO TP_1,
    TP_ATESTADO TP_1,
    TX_CEI TX_20,
    TX_ART TX_10,
    TP_SABADOS TP_1,
    TP_DOMINGOS TP_1,
    TL_OBSERVACAO TL,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_TELEFONE TX_40,
    TX_ESCOPO TX_255,
    TP_CONTABILIZAR TP_1,
    VL_ADITIVO_OBRA VL,
    TX_ADITIVO_PRAZO TX_20,
    TX_FISCALIZACAO TX_40,
    TX_CONTRATO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);



CREATE TABLE BLD_OBRAS_APLICACOES (
    ID_ITEM ID NOT NULL,
    ID_APLICACAO ID,
    VL_APLICACAO VL,
	VL_UTILIZADO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);



CREATE TABLE BLD_OBRAS_ART (
    ID_ART ID NOT NULL,
    ID_OBRA ID,
    DT_ART DT,
    TX_ART TX_20,
    TX_RESPONSAVEL TX_60,
    TX_DESCRICAO TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE BLD_TIPOSOBRAS (
    ID_TIPOOBRA ID NOT NULL,
    CD_TIPOOBRA CD_10,
    TX_DESCRICAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_AJUSTES (
    ID_AJUSTE ID NOT NULL,
    ID_CLIENTE ID,
    DT_REFERENCIA DT,
    TX_DESCRICAO TX_40,
    VL_AJUSTE VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_AREAS (
    ID_AREA ID NOT NULL,
    TX_DESCRICAO TX_60,
    TX_EMAIL_AREA TX_60,
    TX_EMAIL_SUPERVISOR TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_ATENDENTES (
    ID_ATENDENTE ID NOT NULL,
    ID_ATENDENTE_USUARIO ID,
    TX_NOME TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_ATENDIMENTOS (
    ID_ATENDIMENTO ID NOT NULL,
    CD_PROTOCOLO CD_20,
    TP_CHAMADO TP_1,
    TP_INSTALACAO TP_1,
    NR_ESPERA NI,
    DT_ATENDIMENTO DT,
    DT_AGENDAMENTO DT,
    DT_INICIO DT,
    DT_TERMINO DT,
    ID_CLIENTE ID,
    ID_TIPOATENDIMENTO ID,
    ID_AREA ID,
    TL_DESCRICAO TL,
    TL_SOLUCAO TL,
    TP_FOCUS TP_1,
    TP_ORDEM TP_1,
    TP_SITUACAO TP_1,
    ID_INTERRUPCAO ID,
    ID_USUARIO_ABERTURA ID,
    ID_USUARIO_ENCERRAMENTO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_CAIXAS (
    ID_CAIXA ID NOT NULL,
    ID_CAIXA_USUARIO ID,
    TX_NOME TX_60,
    ID_CONTACAIXA ID,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_CANCELAMENTOS (
    ID_CANCELAMENTO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_COMENTARIOS (
    ID_COMENTARIO ID NOT NULL,
    ID_ATENDIMENTO ID,
    DT_COMENTARIO DT,
    TL_DESCRICAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_CONDOMINIOS (
    ID_CONDOMINIO ID NOT NULL,
    TX_NOME TX_60,
    TX_ENDERECO TX_60,
    NR_NUMERO NI,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    NR_APARTAMENTOS NI,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    TP_APS TP_1,
    NR_PRAZO_INSTALACAO NI,
    ID_CONTA_ADESAO ID,
    ID_CONTA_MENSALIDADE ID,
    ID_CONTA_CREDITO ID,
    ID_AREA ID,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    ID_VENDEDOR ID,
    TX_MONITOR_SERVIDOR TX_40,
    TX_MONITOR_BANCO TX_40,
    TX_MONITOR_USUARIO TX_40,
    TX_MONITOR_SENHA TX_40,
    TX_MONITOR_APS TX_40,
    TX_SENHA_PGMQ TX_20,
    TP_ARREDONDAMENTO TP_1,
    TX_MENSAGEM_DEBITO TX_60,
    TX_MENSAGEM_CORTE TX_60,
    TX_MENSAGEM_REAJUSTE TX_60,
    TX_NFE_CERTIFICADO TX_60,
    TX_NFE_ESTADO TX_ESTADO,
    TP_NFE_AMBIENTE TP_1,
    CD_NFE_NUMERO CD_10,
    CD_NFE_CFOP TX_10,
    TX_NFE_CFOP TX_60,
    CD_NFE_CST TX_10,
    TX_NFE_DESCRICAO TX_60,
    PR_NFE_ICMS_BASE PL,
    PR_NFE_ICMS_ALIQUOTA PL,
    TP_RECIBO_IMPRIMIR TP_1,
    TP_RECIBO_PERGUNTAR TP_1,
    TP_RECIBO_AUTENTICAR TP_1,
    TX_RECIBO_PREFIXO TX_20,
    TX_MENSAGEM_BOLETO_1 TX_40,
    TX_MENSAGEM_BOLETO_2 TX_40,
    TX_MENSAGEM_BOLETO_3 TX_40,
    TX_MENSAGEM_BOLETO_4 TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_CONTRATOS (
    ID_CONTRATO ID NOT NULL,
    ID_CLIENTE ID,
    DT_ADESAO DT,
    CD_CONTRATO CD_10,
    DT_CONTRATO DT,
    ID_PLANO ID,
    ID_VENDEDOR ID,
    VL_COMISSAO VL,
    VL_MENSALIDADE VL,
    VL_DESCONTO VL,
    VL_ADICIONAL VL,
    VL_ADESAO VL,
    NR_ADESAO_PARCELAS NI,
    VL_EQUIPAMENTOS VL,
    NR_EQUIPAMENTOS_PARCELAS NI,
    VL_INSTALACAO VL,
    NR_INSTALACAO_PARCELAS NI,
    NR_PONTOS NI,
    NR_ADICIONAIS NI,
    NR_CORTESIA NI,
    DT_BASE DT,
    NR_REAJUSTE NI,
    DT_REFERENCIA DT,
    DT_REAJUSTE DT,
    PR_REAJUSTE PR,
    PR_DESCONTO PR,
    TL_MAC TL,
    NR_VENCIMENTO NI,
    DT_COBRANCA DT,
    DT_FATURAMENTO DT,
    DT_ENCERRAMENTO DT,
    DT_CONEXAO DT,
    DT_DESCONEXAO DT,
    ID_CANCELAMENTO ID,
    TP_SITUACAO TP_1,
    TP_ARQUIVO TP_1,
    ID_INDICE ID,
    ID_MODEM ID,
    TX_NO TX_10,
    TX_HFCIP TX_20,
    TX_HFCMAC TX_20,
    NR_CMTS NI,
    NR_DOWN NR,
    NR_UP NR,
    NR_SNR NR,
    TX_IP TX_20,
    TP_IP_FIXO TP_1,
    TX_ROUTER TX_20,
    TX_VELOCIDADE TX_10,
    TX_NODE TX_10,
    TX_USB TX_20,
    TX_ETH1 TX_20,
    TX_ETH2 TX_20,
    TX_ETH3 TX_20,
    TX_ETH4 TX_20,
    TX_ETH5 TX_20,
    TP_CONTRATO TP_1,
    TL_CONTRATO TL,
    ID_AUTORIZACAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_CONTRATOS_REAJUSTES (
    ID_ITEM ID NOT NULL,
    ID_CONTRATO ID,
    ID_PLANO ID,
    DT_REAJUSTE DT,
    DT_BASE DT,
    DT_REFERENCIA DT,
    VL_MENSALIDADE VL,
    VL_DESCONTO VL,
    VL_ADICIONAL VL,
    PR_REAJUSTE PR,
    PR_DESCONTO PR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_CONTRATOS_SEQUENCIAS (
    ID_SEQUENCIA ID NOT NULL,
    CD_CONTRATO CD_10,
    ID_CLIENTE ID,
    DT_CONTRATO DT,
    DT_CANCELAMENTO DT,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_GRUPOS (
    ID_GRUPO ID NOT NULL,
    TX_DESCRICAO TX_60,
    VL_MERCADO VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    DT_REFERENCIA DT,
    NR_QUANTIDADE NI,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_INTERRUPCOES (
    ID_INTERRUPCAO ID NOT NULL,
    CD_INTERRUPCAO CD_10,
    DT_INICIO DT,
    DT_TERMINO DT,
    TX_REGIAO TX_60,
    TX_MOTIVO TX_100,
    TP_INSTALACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_MODEMS (
    ID_MODEM ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_NOTAS (
    ID_NOTA ID NOT NULL,
    ID_CLIENTE ID,
    CD_CFOP CD_10,
    TX_CFOP TX_100,
    CD_NOTA CD_10,
    TX_CHAVE TX_40,
    DT_EMISSAO DT,
    DT_VENCIMENTO DT,
    VL_TOTAL VL,
    VL_BASECALCULO VL,
    PR_ICMS PR,
    VL_ICMS VL);


CREATE TABLE CAB_NOTAS_ITENS (
    ID_ITEM ID NOT NULL,
    ID_NOTA ID,
    TX_SERVICO TX_40,
    VL_BASECALCULO VL,
    PR_ICMS PR,
    VL_ICMS VL,
    VL_SERVICO VL);


CREATE TABLE CAB_OBSERVACOES (
    ID_OBSERVACAO ID NOT NULL,
    ID_CLIENTE ID,
    TX_OBSERVACAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_ORDENS (
    ID_ORDEM ID NOT NULL,
    CD_ORDEM CD_10,
    ID_ATENDIMENTO ID,
    ID_CLIENTE ID,
    ID_SERVICO ID,
    TP_INSTALACAO TP_1,
    ID_CONTRATO ID,
    ID_PLANO_ATUAL ID,
    VL_PLANO_ATUAL VL,
    VL_PROPORCIONAL_ATUAL VL,
    ID_PLANO_NOVO ID,
    VL_PLANO_NOVO VL,
    VL_PROPORCIONAL_NOVO VL,
    NR_QUANTIDADE NR,
    VL_SERVICO VL,
    NR_PARCELAS NI,
    ID_ATENDENTE ID,
    DT_EMISSAO DT,
    DT_DESCONEXAO DT,
    DT_ENCERRAMENTO DT,
    TP_SITUACAO TP_1,
    NR_PONTOS NI,
    NR_ADICIONAIS NI,
    NR_CORTESIA NI,
    ID_CANCELAMENTO ID,
    TL_OBSERVACOES TL,
    DT_IMPRESSAO DT,
    DT_ALTERACAO DT,
    ID_TECNICO ID,
    ID_AJUDANTE ID,
    ID_MOTORISTA ID,
    DT_VISITA_1 DT,
    HR_VISITA_1 HR,
    TL_OBSERVACOES_1 TL,
    DT_VISITA_2 DT,
    HR_VISITA_2 HR,
    TL_OBSERVACOES_2 TL,
    DT_VISITA_3 DT,
    HR_VISITA_3 HR,
    TL_OBSERVACOES_3 TL,
    TL_SOLUCAO BL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_PLANOS (
    ID_PLANO ID NOT NULL,
    CD_PLANO CD_10,
    TX_DESCRICAO TX_60,
    DT_REFERENCIA DT,
    VL_PLANO VL,
    VL_DESCONTO VL,
    VL_ADICIONAL VL,
    VL_ADESAO VL,
    VL_COMISSAO_EXTERNA VL,
    VL_COMISSAO_INTERNA VL,
    VL_COMISSAO_SUPERVISOR VL,
    VL_COMISSAO_GERENTE VL,
    ID_GRUPO ID,
    TP_PROPORCIONAL TP_1,
    TL_CARACTERISTICAS TL,
    TP_INSTALACAO TP_1,
    NR_CANAIS NR,
    NR_VELOCIDADE DECIMAL(6,3),
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_SERVICOS (
    ID_SERVICO ID NOT NULL,
    CD_SERVICO CD_10,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    TL_PROCEDIMENTO TL,
    ID_TIPOATENDIMENTO ID,
    TP_PLANO TP_1,
    ID_PLANO ID,
    TP_ASSINANTE TP_1,
    TP_INSTALACAO TP_1,
    TP_CONTRATO TP_1,
    TP_CONEXAO TP_1,
    TP_DESCONEXAO TP_1,
    TP_ENDERECO_ATUAL TP_1,
    TP_ENDERECO_NOVO TP_1,
    TP_PLANO_ATUAL TP_1,
    TP_PLANO_NOVO TP_1,
    TP_ALTERACAO TP_1,
    TP_ADICIONAL TP_1,
    TP_PROPORCIONAL TP_1,
    TP_DEBITO TP_1,
    NR_DIAS NI,
    VL_SERVICO VL,
    VL_COMISSAO VL,
    NR_PARCELAS NI,
    TP_PARCELADO TP_1,
    TP_FATURAMENTO TP_2,
    DT_ATUALIZACAO DT,
    ID_USUARIO ID);


CREATE TABLE CAB_TECNICOS (
    ID_TECNICO ID NOT NULL,
    TX_NOME TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_TIPOSATENDIMENTO (
    ID_TIPOATENDIMENTO ID NOT NULL,
    CD_TIPOATENDIMENTO CD_10,
    TX_DESCRICAO TX_60,
    NR_PRAZO_AREA NI,
    NR_PRAZO_SUPERVISOR NI,
    TL_DESCRICAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_TRABALHOS (
    ID_TRABALHO ID NOT NULL,
    DT_TRABALHO DT,
    ID_TECNICO ID,
    TP_TRABALHO TP_1,
    NR_QUANTIDADE NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CAB_VENDEDORES (
    ID_VENDEDOR ID NOT NULL,
    TX_NOME TX_60,
    TP_SITUACAO TP_1 ,
    TP_COMISSAO_ADESAO TP_1 ,
    PR_COMISSAO PR ,
    VL_COMISSAO VL ,
    ID_USUARIO ID ,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_ACOES (
    ID_ACAO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_AREAS (
    ID_AREA ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_ATIVIDADES (
    ID_ATIVIDADE ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_BAIRROS (
    ID_BAIRRO ID NOT NULL,
    TX_NOME TX_60,
    ID_REGIAO ID,
    ID_CIDADE ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_CIDADES (
    ID_CIDADE ID NOT NULL,
    TX_NOME TX_60,
    CD_IBGE CD_10,
    TX_ESTADO TX_ESTADO,
    ID_REGIAO ID,
    ID_ESTADO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_CLIENTES_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    ID_CLIENTE ID,
    DT_HISTORICO DT,
    HR_HISTORICO HR,
    ID_ACAO ID,
    ID_FUNCIONARIO ID,
    TX_CONTATO TX_20,
    TP_SITUACAO TP_1,
    ID_SITUACAO ID,
    TL_OBSERVACOES TL,
    TP_SELECIONADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    ID_FUNCAO_ATENDENTE ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_CONTATOS (
    ID_CONTATO ID NOT NULL,
    TX_NOME TX_60,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    ID_TIPOCONTATO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_ESTADOS (
    ID_ESTADO ID NOT NULL,
    TX_ESTADO TX_ESTADO,
    TX_NOME TX_60,
    ID_PAIS ID,
    ID_REGIAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_FORNECEDORES_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    ID_FORNECEDOR ID,
    DT_HISTORICO DT,
    HR_HISTORICO HR,
    ID_ACAO ID,
    ID_FUNCIONARIO ID,
    TX_CONTATO TX_20,
    TP_SITUACAO TP_1,
    ID_SITUACAO ID,
    TL_OBSERVACOES TL,
    TP_SELECIONADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_ORIGENS (
    ID_ORIGEM ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_PAISES (
    ID_PAIS ID NOT NULL,
    TX_NOME TX_60,
    ID_REGIAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_PERFISCLIENTES (
    ID_PERFIL ID NOT NULL,
    CD_PERFIL CD_10,
    TX_DESCRICAO TX_100,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_PERFISFORNECEDORES (
    ID_PERFIL ID NOT NULL,
    CD_PERFIL CD_10,
    TX_DESCRICAO TX_100,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_PERFISPOTENCIAIS (
    ID_PERFIL ID NOT NULL,
    CD_PERFIL CD_10,
    TX_DESCRICAO TX_100,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_PORTE (
    ID_PORTE ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_POTENCIAIS (
    ID_POTENCIAL ID NOT NULL,
    CD_POTENCIAL CD_10,
    ID_TIPOCONTATO ID,
    TP_SITUACAO TP_1,
    TP_POTENCIAL TP_1,
    TX_NOME TX_60,
    TX_FANTASIA TX_60,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_PAIS TX_40,
    TX_CEP TX_CEP,
    TX_CONTATO TX_60,
    TX_TELEFONE TX_60,
    TX_FAX TX_40,
    TX_CELULAR TX_40,
    TX_EMAIL TX_60,
    TX_WEBSITE TX_60,
    TX_MSN TX_60,
    TX_SKYPE TX_60,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_IE,
    TX_IM TX_IM,
    TX_CI TX_CI,
    TX_CPF TX_CPF,
    ID_PERFIL ID,
    ID_ATENDENTE ID,
    ID_PORTE ID,
    ID_ATIVIDADE ID,
    ID_SEGMENTO ID,
    ID_ORIGEM ID,
    ID_AREA ID,
    TX_ATIVIDADES TX_255,
    TX_FORNECEDOR TX_60,
    TL_OBSERVACOES TL,
    TP_SELECIONADO TP_1,
    DT_CADASTRO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_POTENCIAIS_CONTATOS (
    ID_CONTATO ID NOT NULL,
    ID_POTENCIAL ID,
    TP_PRINCIPAL TP_1,
    TX_NOME TX_60,
    TX_SETOR TX_40,
    TX_COMERCIAL TX_40,
    TX_CELULAR TX_40,
    TX_EMAIL TX_40,
    DT_NASCIMENTO DT,
    TP_IMPRESSAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_POTENCIAIS_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    ID_POTENCIAL ID,
    DT_HISTORICO DT,
    HR_HISTORICO HR,
    ID_ACAO ID,
    ID_FUNCIONARIO ID,
    TX_CONTATO TX_20,
    TP_SITUACAO TP_1,
    ID_SITUACAO ID,
    TL_OBSERVACOES TL,
    TP_SELECIONADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_REGIOES (
    ID_REGIAO ID NOT NULL,
    TX_NOME TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_SEGMENTOS (
    ID_SEGMENTO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_SITUACOES (
    ID_SITUACAO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CRM_TIPOSCONTATOS (
    ID_TIPOCONTATO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_ADIANTAMENTOS (
    ID_ADIANTAMENTO ID NOT NULL,
    DT_ADIANTAMENTO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_ADIANTAMENTOS_CHEQUES (
    ID_ITEM ID NOT NULL,
    ID_ADIANTAMENTO ID,
    DT_VENCIMENTO DT,
    VL_DOCUMENTO VL,
    VL_RECEBIDO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_ALINEAS (
    ID_ALINEA ID NOT NULL,
    CD_ALINEA CD_10,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_BANCARIO (
    ID_MOVIMENTO ID NOT NULL,
    ID_PERIODO ID,
    ID_CONTABANCARIA ID,
    TP_SITUACAO TP_1,
    DT_MOVIMENTO DT,
    VL_SALDO_ANTERIOR VL,
    VL_DISPONIVEL_ANTERIOR VL,
    VL_PAGAMENTOS VL,
    VL_RECEBIMENTOS VL,
    VL_TRANSFERENCIAS VL,
    VL_EMITIDOS VL,
    VL_COMPENSADOS VL,
    VL_SALDO_ATUAL VL,
    VL_DISPONIVEL_ATUAL VL,
    DT_CONCILIACAO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_BANCARIO_PERIODOS (
    ID_PERIODO ID NOT NULL,
    ID_CONTABANCARIA ID,
    TX_REFERENCIA CHAR(7) CHARACTER SET WIN1252 COLLATE WIN1252,
    DT_INICIAL DT,
    DT_FINAL DT,
    DT_FECHAMENTO DT,
    VL_SALDO_INICIAL VL,
    VL_SALDO_FINAL VL,
    VL_DISPONIVEL_INICIAL VL,
    VL_DISPONIVEL_FINAL VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_BANCOS (
    ID_BANCO ID NOT NULL,
    CD_BANCO CHAR(3) CHARACTER SET WIN1252 COLLATE WIN1252,
    TX_NOME TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CAIXA (
    ID_MOVIMENTO ID NOT NULL,
    ID_PERIODO ID,
    ID_CONTACAIXA ID,
    TP_SITUACAO TP_1,
    DT_MOVIMENTO DT,
    VL_SALDO_ANTERIOR VL,
    VL_PAGAMENTOS VL,
    VL_RECEBIMENTOS VL,
    VL_TRANSFERENCIAS VL,
    VL_SALDO_ATUAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CAIXA_PERIODOS (
    ID_PERIODO ID NOT NULL,
    ID_CONTACAIXA ID,
    TX_REFERENCIA CHAR(7) CHARACTER SET WIN1252 COLLATE WIN1252,
    DT_INICIAL DT,
    DT_FINAL DT,
    DT_FECHAMENTO DT,
    VL_SALDO_INICIAL VL,
    VL_SALDO_FINAL VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CARTEIRAS (
    ID_CARTEIRA ID NOT NULL,
    CD_COBRANCA CD_10,
    CD_BANCO CD_10,
    CD_CARTEIRA CD_10,
    TX_DESCRICAO TX_60,
    TP_240 TP_1,
    TP_400 TP_1,
    TP_CONVENIO TP_1,
    TP_VARIACAO TP_1);


CREATE TABLE CTR_CENTROSCUSTO (
    ID_CENTROCUSTO ID NOT NULL,
    TP_CENTROCUSTO TP_1,
    CD_CENTROCUSTO CD_20,
    CD_CLASSIFICACAO CD_20,
    TX_TITULO TX_60,
    TX_NOME TX_60,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_40,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_TELEFONE TX_40,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_IE,
    TX_IM TX_IM,
    TP_CONTA TP_1,
    TP_CUSTO TP_1,
    TP_CONTABILIZAR TP_1,
    TP_ACESSO TP_1,
    TP_SITUACAO TP_1,
    TP_APROPRIACAO TP_1,
    ID_CONTA_RATEIO ID,
    ID_CONTA_DESPESA ID,
    DT_ABERTURA DT,
    DT_ENCERRAMENTO DT,
    DT_EXPORTACAO DT,
    DT_IMPORTACAO DT,
    TP_PADRAO TP_1,
    ID_CONCILIACAO ID,
    NR_NUMERO NI,
    TX_COMPLEMENTO TX_40,
    TX_EMAIL TX_40,
    CD_MUNICIPIO CD_20,
    PR_ENCARGOS PR,
    VL_TOTAL VL,
    PR_COMPRAS PR,
    PR_AVISO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CHEQUES (
    ID_CHEQUE ID NOT NULL,
    ID_CONTABANCARIA ID,
    CD_CHEQUE CD_10,
    DT_EMISSAO DT,
    DT_VENCIMENTO DT,
    DT_COMPENSACAO DT,
    VL_CHEQUE VL,
    TX_NOMINAL TX_60,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_TIPOPAGAMENTO ID,
    TP_CONCILIADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES (
    ID_CLIENTE ID NOT NULL,
    ID_PLANOCONTA ID,
    ID_CENTROCUSTO ID,
    ID_CREDOR ID,
    TP_CLIENTE TP_1,
    TP_CADASTRO TP_1,
    TP_SITUACAO TP_1 DEFAULT 'A',
    TP_FINANCEIRO TP_1,
    TP_VENDA TP_1,
    CD_CLIENTE CD_20,
    CD_IDENTIFICACAO CD_20,
    ID_PERFIL ID,
    TX_NOME TX_60 COLLATE PXW_INTL850,
    TX_FANTASIA TX_60,
    TX_ENDERECO TX_60,
    NR_NUMERO NI,
    TX_COMPLEMENTO TX_20,
    TX_REFERENCIA TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    CD_CIDADE CD_10,
    TX_ESTADO TX_ESTADO,
    TX_PAIS TX_60,
    CD_PAIS CD_10,
    TX_CEP TX_CEP,
    TX_CONTATO TX_60,
    TX_TELEFONE TX_40,
    TX_TELEFONE_COMERCIAL TX_20,
    TX_TELEFONE_CONTATO TX_20,
    TX_TELEFONE_CELULAR TX_20,
    TX_TELEFONE_RESIDENCIAL TX_20,
    TX_CELULAR TX_40,
    TX_FAX TX_40,
    TX_EMAIL TX_60,
    TX_WEBSITE TX_60,
    TX_MSN TX_60,
    TX_SKYPE TX_60,
    DT_NASCIMENTO DT,
    DT_FUNDACAO DT,
    TL_SOCIOS TL,
    TX_CPF TX_CPF,
    TX_CI TX_CI,
    TX_CI_ORGAO TX_10,
    DT_CI_EMISSAO DT,
    TX_CERT_TERMO TX_20,
    TX_CERT_FOLHA TX_20,
    TX_CERT_LIVRO TX_20,
    DT_CERT_EMISSAO DT,
    TX_CERT_ESTADO TX_ESTADO,
    TX_CERT_CARTORIO TX_40,
    TP_SEXO TP_1,
    TX_CONJUGE TX_60,
    TX_RELIGIAO TX_40,
    TX_NACIONALIDADE TX_40,
    TX_NATURALIDADE TX_40,
    TP_FUMANTE TP_1,
    TX_CARGO TX_60,
    TX_COR TX_20,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_IE,
    TX_IM TX_IM,
    TP_ESTADOCIVIL TP_1,
    DT_CADASTRO DT,
    DT_MATRICULA DT,
    DT_CANCELAMENTO DT,
    TX_MOTIVO_CANCELAMENTO TX_100,
    TP_ENT_PRINCIPAL TP_1,
    TX_ENT_ENDERECO TX_60,
    NR_ENT_NUMERO NI,
    TX_ENT_COMPLEMENTO TX_20,
    TX_ENT_BAIRRO TX_60,
    TX_ENT_CIDADE TX_60,
    TX_ENT_ESTADO TX_ESTADO,
    TX_ENT_CEP TX_CEP,
    TX_ENT_CONTATO TX_60,
    TP_COB_PRINCIPAL TP_1,
    TX_COB_ENDERECO TX_60,
    NR_COB_NUMERO NI,
    TX_COB_COMPLEMENTO TX_20,
    TX_COB_BAIRRO TX_60,
    TX_COB_CIDADE TX_60,
    TX_COB_ESTADO TX_ESTADO,
    TX_COB_CEP TX_CEP,
    TX_COB_CONTATO TX_60,
    TP_INTERNET TP_1,
    TX_LOGIN TX_20,
    TX_SENHA TX_20,
    ID_PRAZORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    NR_VENCIMENTO_1 INTEGER,
    NR_VENCIMENTO_2 INTEGER,
    NR_VENCIMENTO_3 INTEGER,
    VL_MENSALIDADE_1 VL,
    VL_MENSALIDADE_2 VL,
    VL_MENSALIDADE_3 VL,
    TP_CORRESPONDENCIA TP_1,
    TP_SANGUE_TIPO TP_1,
    TP_SANGUE_RH TP_1,
    TX_EMPRESA TX_60,
    TX_ESCOLA TX_60,
    TX_ESCOLA_ANTERIOR TX_60,
    TX_PROFISSAO TX_60,
    TX_SERIE_ANTERIOR TX_10,
    TX_IRMAO_NOME_1 TX_60,
    TX_IRMAO_SERIE_1 TX_10,
    TX_IRMAO_NOME_2 TX_60,
    TX_IRMAO_SERIE_2 TX_10,
    TX_TRANSPORTE TX_60,
    TX_PAI_NOME TX_60,
    TX_PAI_ENDERECO TX_60,
    TX_PAI_BAIRRO TX_60,
    TX_PAI_CIDADE TX_60,
    TX_PAI_ESTADO TX_ESTADO,
    TX_PAI_CEP TX_CEP,
    TX_PAI_TELEFONE TX_40,
    TX_PAI_NACIONALIDADE TX_40,
    TX_PAI_PROFISSAO TX_40,
    TX_PAI_INSTRUCAO TX_40,
    TX_PAI_CPF TX_CPF,
    TX_PAI_CI TX_CI,
    TX_PAI_CI_ORGAO TX_10,
    DT_PAI_CI_EMISSAO DT,
    TX_PAI_TRAB_ENDERECO TX_60,
    TX_PAI_TRAB_TELEFONE TX_60,
    TX_MAE_NOME TX_60,
    TX_MAE_ENDERECO TX_60,
    TX_MAE_BAIRRO TX_60,
    TX_MAE_CIDADE TX_60,
    TX_MAE_ESTADO TX_ESTADO,
    TX_MAE_CEP TX_CEP,
    TX_MAE_TELEFONE TX_40,
    TX_MAE_NACIONALIDADE TX_40,
    TX_MAE_PROFISSAO TX_40,
    TX_MAE_INSTRUCAO TX_40,
    TX_MAE_CPF TX_CPF,
    TX_MAE_CI TX_CI,
    TX_MAE_CI_ORGAO TX_10,
    DT_MAE_CI_EMISSAO DT,
    TX_MAE_TRAB_ENDERECO TX_60,
    TX_MAE_TRAB_TELEFONE TX_60,
    TX_RESP_NOME TX_60,
    TX_RESP_ENDERECO TX_60,
    TX_RESP_BAIRRO TX_60,
    TX_RESP_CIDADE TX_60,
    TX_RESP_ESTADO TX_ESTADO,
    TX_RESP_CEP TX_CEP,
    TX_RESP_TELEFONE TX_40,
    TX_RESP_NACIONALIDADE TX_40,
    TX_RESP_PROFISSAO TX_40,
    TX_RESP_INSTRUCAO TX_40,
    TX_RESP_CPF TX_CPF,
    TX_RESP_CI TX_CI,
    TX_RESP_CI_ORGAO TX_10,
    DT_RESP_CI_EMISSAO DT,
    TX_RESP_TRAB_ENDERECO TX_60,
    TX_RESP_TRAB_TELEFONE TX_60,
    TL_OBSERVACOES_1 TL,
    TL_OBSERVACOES_2 TL,
    TL_OBSERVACOES_3 TL,
    TL_OBSERVACOES_4 TL,
    TL_OBSERVACOES_5 TL,
    TL_OBSERVACOES_6 TL,
    TP_PASSE TP_1,
    NR_PASSES INTEGER,
    TP_TABELA TP_1,
    ID_SEGMENTO ID,
    ID_ATIVIDADE ID,
    TX_ATIVIDADES TX_255,
    TP_SELECIONADO TP_1,
    TX_FOTO TX_60,
    ID_CONTA_RECEITA ID,
    ID_CONVENIO ID,
    ID_TIPOCONTATO ID,
    ID_POTENCIAL ID,
    ID_AREA ID,
    TP_COBRANCA TP_1,
    CD_COBRANCA CD_10,
    TP_CORRENTISTA TP_1,
    VL_LIMITE VL,
    VL_DISPONIVEL VL,
    VL_COMPRAS_ULTIMA VL,
    VL_COMPRAS_TOTAL VL,
    VL_COMPRAS_MEDIO VL,
    DT_COMPRA DT,
    VL_SALDO VL,
    DT_SALDO DT,
    TP_SPC TP_1,
    DT_SPC DT,
    ID_PONTOVENDA ID,
    ID_VENDEDOR ID,
    TX_INDICACAO TX_60,
    TX_IMAGEM TX_60,
    ID_TRANSPORTADORA ID,
    PR_DESCONTO PR,
    TP_RESIDENCIA TP_1,
    DT_FATURAMENTO DT,
    NR_MESES_CORTESIA NR,
    VL_SALARIO VL,
    VL_SALARIO_CONJUGE VL,
    TX_TEMPO_TRABALHO TX_10 COLLATE WIN1252,
    CD_CONTRATO CD_20,
    DT_CONTRATO DT,
    ID_PRODUTO ID,
    ID_CONDOMINIO ID,
    TX_AVISO TX_60,
    ID_CONTA_DEBITO ID,
    TP_FATURAMENTO TP_1,
    TP_BENEFICIAMENTO TP_1,
    ID_CONTA_CREDITO ID,
    TP_DEBITOAUTOMATICO TP_1,
    ID_FORNECEDOR ID,
    ID_ROTA ID,
    ID_CFOP ID,
    ID_FORMA_RECEBIMENTO ID,
    ID_INDICACAO ID,
    NR_TOTAL NR,
    NR_CLASSIFICACAO INTEGER,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES_BANCOS (
    ID_REFERENCIA ID NOT NULL,
    ID_CLIENTE ID,
    TX_BANCO TX_60,
    CD_BANCO TP_3,
    CD_AGENCIA CD_10,
    CD_AGENCIA_DV TP_1,
    CD_CONTA CD_10,
    CD_CONTA_DV CD_10,
    TX_DESDE TX_20,
    TP_CHEQUE TP_1,
    TX_CONTATO TX_60,
    TX_OBSERVACOES TX_255,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES_CHEQUES (
    ID_CHEQUE ID NOT NULL,
    ID_CLIENTE ID,
    TX_BANCO TX_10,
    TX_AGENCIA TX_10,
    TX_CONTA TX_10,
    TX_EMITENTE TX_60,
    TX_CHEQUE TX_20,
    VL_CHEQUE VL,
    DT_VENCIMENTO DT,
    DT_DEVOLUCAO DT,
    ID_ALINEA_1 ID,
    ID_ALINEA_2 ID,
    TX_OBSERVACAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES_COMERCIAIS (
    ID_REFERENCIA ID NOT NULL,
    ID_CLIENTE ID,
    TX_EMPRESA TX_60,
    TX_CONTATO TX_60,
    TX_TELEFONE TX_40,
    TX_DESDE TX_20,
    TX_MEDIA TX_40,
    TX_FREQUENCIA TX_60,
    TX_OBSERVACOES TX_255,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES_CONTATOS (
    ID_CONTATO ID NOT NULL,
    ID_CLIENTE ID,
    TP_PRINCIPAL TP_1,
    TX_NOME TX_60,
    TX_SETOR TX_40,
    TX_COMERCIAL TX_40,
    TX_CELULAR TX_40,
    TX_EMAIL TX_40,
    DT_NASCIMENTO DT,
    TP_IMPRESSAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES_CONVENIOS (
    ID_CONVENIO ID NOT NULL,
    TP_SITUACAO TP_1,
    TX_DESCRICAO TX_60,
    DT_INICIO DT,
    DT_TERMINO DT,
    ID_CLIENTE ID,
    ID_TIPODOCUMENTO ID,
    ID_TIPORECEBIMENTO ID,
    ID_CONTA_RECEITA ID,
    ID_PRAZORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    VL_TOTAL VL,
    NR_DIA_PAGAMENTO INTEGER,
    PR_DESCONTO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES_DIVISOES (
    ID_DIVISAO ID NOT NULL,
    ID_CLIENTE ID,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES_RELACOES (
    ID_ITEM ID NOT NULL,
    ID_CLIENTE ID,
    ID_RELACAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CLIENTES_SPC (
    ID_SPC ID NOT NULL,
    ID_CLIENTE ID,
    TP_SPC TP_1,
    DT_SPC DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    CD_CONTA_ATIVO CD_20,
    CD_CONTA_PASSIVO CD_20,
    CD_CONTA_RECEITAS CD_20,
    CD_CONTA_DESPESAS CD_20,
    CD_CONTA_CONTASBANCARIAS CD_20,
    CD_CONTA_CONTASCAIXA CD_20,
    CD_CONTA_CLIENTES CD_20,
    CD_CONTA_FORNECEDORES CD_20,
    CD_CONTA_PAGAMENTOS CD_20,
    CD_CONTA_FUNCIONARIOS CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    PR_JUROS PL,
    PR_MULTA PL,
    PR_DESCONTO_FIXO PL,
    PR_DESCONTO_DIA PL,
    TP_MENSAGEM_DESCONTO TP_1,
    NR_DIGITO_VERIFICADOR NR,
    ID_FORMARECEBIMENTO_CAIXA ID,
    ID_FORMARECEBIMENTO_CONCILIACAO ID,
    ID_FORMAPAGAMENTO_CHEQUE ID,
    ID_FORMAPAGAMENTO_CAIXA ID,
    ID_FORMAPAGAMENTO_INTERNET ID,
    ID_FORMAPAGAMENTO_CONCILIACAO ID,
    ID_DESPESAS_CONCILIACAO ID,
    ID_RECEITAS_CONCILIACAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CONTASBANCARIAS (
    ID_CONTABANCARIA ID NOT NULL,
    ID_PLANOCONTA ID,
    TP_SITUACAO TP_1,
    TX_DESCRICAO TX_60,
    TX_TITULAR TX_60,
    TX_CNPJ TX_CNPJ,
    ID_FORNECEDOR ID,
    ID_CENTROCUSTO ID,
    TX_BANCO TX_60,
    CD_BANCO CHAR(3) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_BANCO_DV CHAR(1) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_AGENCIA VARCHAR(10) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_AGENCIA_DV CHAR(1) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_CONTA VARCHAR(10) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_CONTA_DV CHAR(1) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_CARTEIRA CHAR(3) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_VARIACAO CHAR(3) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_CONVENIO CD_20,
    CD_CONTRATO CD_20,
    CD_IDENTIFICADOR CHAR(2) CHARACTER SET WIN1252 COLLATE WIN1252,
    TP_NUMERACAO TP_2,
    TX_GERENTE TX_60,
    TX_TELEFONE TX_60,
    TX_EMAIL TX_60,
    TP_CHEQUE TP_1,
    CD_CHEQUE CD_10,
    TP_IMPRESSAO_CHEQUES TP_1,
    TX_LOCAL_EMISSAO TX_20,
    TP_PORTA_SERIAL TP_1,
    CD_COBRANCA CD_20,
    ID_FORMARECEBIMENTO ID,
    TP_COBRANCA TP_1,
    VL_COBRANCA VL,
    TP_ADICIONAR_COBRANCA TP_1,
    TP_REMESSA CHAR(3),
    NR_REMESSA NI,
    DT_REMESSA DT,
    TP_FORMATO CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    TP_DOCUMENTO TP_1,
    CD_DOCUMENTO CD_10,
    TX_LOCALPAGAMENTO_1 TX_60,
    TX_LOCALPAGAMENTO_2 TX_60,
    VL_ESPECIAL VL,
    PR_ESPECIAL PR,
    VL_EMPRESTIMO VL,
    PR_EMPRESTIMO PR,
    TP_CONTA TP_1 COLLATE WIN1252,
    VL_APLICACAO VL,
    PR_TAXA_APLICACAO PR,
    VL_SALDO_BANCARIO VL,
    VL_SALDO_DISPONIVEL VL,
    VL_PAGAMENTOS VL,
    VL_TRANSFERENCIAS VL,
    DT_SALDO DT,
    TP_PADRAO TP_1,
    ID_FORMA_BOLETO ID,
    ID_FORMA_DEBITO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CONTASCAIXA (
    ID_CONTACAIXA ID NOT NULL,
    ID_PLANOCONTA ID,
    ID_CENTROCUSTO ID,
    ID_USUARIO_CAIXA ID,
    TP_SITUACAO TP_1,
    TX_DESCRICAO TX_60,
    VL_SALDO VL,
    DT_SALDO DT,
    TP_DOCUMENTO TP_1,
    CD_DOCUMENTO CD_10,
    TX_IMPRESSORA TX_100,
    NR_AVANCO NR,
    TP_CORTAR TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CONTRATOS_CLIENTES (
    ID_CONTRATO ID NOT NULL,
    CD_CONTRATO CD_10,
    ID_CLIENTE ID NOT NULL,
    TX_DESCRICAO TX_100,
    TP_SITUACAO TP_1,
    DT_INICIO DT,
    DT_TERMINO DT,
    VL_TOTAL VL,
    NR_PARCELAS NR,
    VL_PARCELA VL,
    DT_VENCIMENTO DT,
    ID_CONTA_RECEITA ID,
    ID_CONTA_CREDITO ID,
    ID_TIPORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    ID_TIPODOCUMENTO ID,
    ID_CENTROCUSTO ID,
    TL_CONTRATO TL,
    TP_NOTAFISCAL TP_1,
    TP_COBRANCA TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_CONTRATOS_FORNECEDORES (
    ID_CONTRATO ID NOT NULL,
    ID_FORNECEDOR ID,
    TX_DESCRICAO TX_100,
    DT_INICIO DT,
    DT_TERMINO DT,
    VL_TOTAL VL,
    NR_PARCELAS NR,
    VL_PARCELA VL,
    TL_CONTRATO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FINANCIAMENTOS (
    ID_FINANCIAMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    PR_FINANCIAMENTO PL,
    VL_TAC VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FORMASPAGAMENTO (
    ID_FORMAPAGAMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    PR_ADMINISTRACAO PR,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FORMASRECEBIMENTO (
    ID_FORMARECEBIMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    CD_FORMARECEBIMENTO CD_10,
    ID_PRAZORECEBIMENTO ID,
    ID_CONTA_RECEITA ID,
    PR_ADMINISTRACAO PR,
    ID_CONTA_DESPESA ID,
    ID_CONTA_CREDITO ID,
    ID_CONTA_CORRENTE ID,
    PR_DESCONTO PR,
    VL_MINIMO VL,
    VL_MAXIMO VL,
    TP_SITUACAO TP_1,
    TP_PADRAO TP_1,
    TP_IMPRESSAO TP_1,
    TP_CLIENTE TP_1,
    TP_CAMBIO TP_1,
    TP_LIMITE TP_1,
    TP_MULTA TP_1,
    TP_JUROS TP_1,
    TP_CARTAO TP_1,
    TP_FORMA TP_2,
    TP_BANDEIRA TP_2,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FORMASRECEBIMENTO_PRAZOS (
    ID_ITEM ID NOT NULL,
    ID_FORMARECEBIMENTO ID NOT NULL,
    ID_PRAZORECEBIMENTO ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FORMASRECEBIMENTO_TAXAS (
    ID_ITEM ID NOT NULL,
    ID_FORMARECEBIMENTO ID,
    ID_CENTROCUSTO ID,
    PR_TAXA_CREDITO PR,
    PR_TAXA_PARCELADO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FORNECEDORES (
    ID_FORNECEDOR ID NOT NULL,
    ID_PLANOCONTA ID,
    ID_CENTROCUSTO ID,
    TP_SITUACAO TP_1,
    TP_FORNECEDOR TP_1,
    CD_FORNECEDOR TX_10,
    ID_PERFIL ID,
    TX_NOME TX_60,
    TX_FANTASIA TX_60,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_PAIS TX_60,
    TX_CEP TX_CEP,
    TX_TELEFONE TX_40,
    TX_FAX TX_40,
    TX_EMAIL TX_60,
    TX_WEBSITE TX_60,
    TX_MSN TX_60,
    TX_SKYPE TX_60,
    TX_CONTATO TX_60,
    DT_NASCIMENTO DT,
    DT_FUNDACAO DT,
    TX_CPF TX_CPF,
    TX_CI TX_CI,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_IE,
    TX_IM TX_IM,
    ID_PRAZOPAGAMENTO ID,
    ID_FORMAPAGAMENTO ID,
    TX_LOCAL_PAGAMENTO TX_60,
    TL_OBSERVACOES TL,
    TL_SOCIOS TL,
    TP_EXTRANET TP_1,
    TX_LOGIN TX_20,
    TX_SENHA TX_20,
    TX_LEMBRETE TX_100,
    TL_DESCRICAO TL,
    ID_SEGMENTO ID,
    ID_ATIVIDADE ID,
    TX_ATIVIDADES TX_255,
    DT_CADASTRO DT,
    TP_SELECIONADO TP_1,
    ID_CLIENTE CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    ID_CONTA_DESPESA ID,
    ID_TIPOCONTATO ID,
    ID_TRANSPORTADORA ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FORNECEDORES_BANCOS (
    ID_REFERENCIA ID NOT NULL,
    ID_FORNECEDOR ID,
    TX_BANCO TX_60,
    CD_BANCO CHAR(3) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_AGENCIA CD_10,
    CD_AGENCIA_DV TP_1,
    CD_CONTA CD_10,
    CD_CONTA_DV CD_10,
    TX_CONTATO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FORNECEDORES_COMERCIAIS (
    ID_REFERENCIA ID NOT NULL,
    ID_FORNECEDOR ID,
    TX_EMPRESA TX_60,
    TX_CONTATO TX_60,
    TX_TELEFONE TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_FORNECEDORES_CONTATOS (
    ID_CONTATO ID NOT NULL,
    ID_FORNECEDOR ID,
    TP_PRINCIPAL TP_1,
    TX_NOME TX_60,
    TX_SETOR TX_40,
    TX_COMERCIAL TX_40,
    TX_CELULAR TX_40,
    TX_EMAIL TX_40,
    DT_NASCIMENTO DT,
    TP_IMPRESSAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_HISTORICOS (
    ID_HISTORICO ID NOT NULL,
    TX_DESCRICAO TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_IMPOSTOS (
    ID_IMPOSTO ID NOT NULL,
    TX_DESCRICAO TX_60,
    CD_RECEITA CD_20,
    NR_VENCIMENTO INTEGER,
    TP_PAGAMENTO TP_1,
    TP_RETENCAO TP_1,
    PR_IMPOSTO TP_1,
    PR_MULTA PR,
    PR_JUROS PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_INDICES (
    ID_INDICE ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_INDICES_PERCENTUAIS (
    ID_PERCENTUAL ID NOT NULL,
    ID_INDICE ID,
    DT_REFERENCIA DT,
    PR_INDICE PL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_LOCAIS (
    ID_LOCAL ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_MENSAGENS (
    ID_MENSAGEM ID NOT NULL,
    TX_MENSAGEM TX_100,
    TP_MES TP_2,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_MOEDAS (
    ID_MOEDA ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_MOEDAS_COTACOES (
    ID_COTACAO ID NOT NULL,
    ID_MOEDA ID,
    VL_COTACAO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_NOTASFISCAIS (
    ID_NOTAFISCAL INTEGER,
    ID_CLIENTE INTEGER,
    DT_EMISSAO INTEGER,
    CD_NOTAFISCAL INTEGER,
    CD_CFOP INTEGER,
    TX_DESCRICAO INTEGER);


CREATE TABLE CTR_NOTASFISCAIS_ITENS (
    ID_ITEM INTEGER,
    ID_NOTAFISCAL INTEGER,
    TX_DESCRICAO INTEGER,
    NR_QUANTIDADE INTEGER,
    VL_UNITARIO INTEGER,
    VL_TOTAL INTEGER);


CREATE TABLE CTR_ORCAMENTOS_ANOS (
    ID_ANO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_ORCAMENTOS_PLANOCONTA (
    ID_ANO ID NOT NULL,
    VL_ORCADO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT,
    ID_PLANOCONTA ID);


CREATE TABLE CTR_PAGAMENTOS (
    ID_PAGAMENTO ID NOT NULL,
    TP_PAGAMENTO TP_1,
    ID_CHEQUE ID,
    TP_LANCAMENTO TP_3,
    ID_LANCAMENTO ID,
    ID_TIPODOCUMENTO ID,
    TX_DESCRICAO TX_100,
    TX_REFERENCIA TX_20,
    DT_VENCIMENTO DT,
    DT_PREVISAO DT,
    TP_PRIORIDADE TP_1,
    VL_DOCUMENTO VL,
    CD_CREDITO CD_20,
    CD_DEBITO CD_20,
    NR_PARCELA INTEGER,
    NR_PARCELAS INTEGER,
    DT_LANCAMENTO DT,
    DT_EMISSAO DT,
    DT_PAGAMENTO DT,
    VL_PAGAMENTO VL,
    VL_JUROS VL,
    VL_MULTA VL,
    VL_DESCONTO VL,
    PR_BOLETO_JUROS PR,
    VL_BOLETO_JUROS VL,
    PR_BOLETO_MULTA PR,
    VL_BOLETO_MULTA VL,
    PR_BOLETO_DESCONTO_DIA PR,
    VL_BOLETO_DESCONTO_DIA VL,
    PR_BOLETO_DESCONTO_FIXO PR,
    VL_BOLETO_DESCONTO_FIXO VL,
    VL_BOLETO_TAXA VL,
    NR_PROTESTO INTEGER,
    ID_FORMA_DEBITO ID,
    ID_FORMA_CREDITO ID,
    ID_TIPOPAGAMENTO ID,
    ID_CONTA_CREDITO ID,
    ID_CONTA_DESPESA ID,
    ID_CONTA_DEBITO ID,
    ID_CENTROCUSTO ID,
    ID_PRAZOPAGAMENTO ID,
    TP_CONFERIDO TP_1,
    TP_LIBERADO TP_1,
    TP_APROVACAO TP_1,
    TP_APROVADO TP_1,
    TP_CONTABILIZAR TP_1,
    TP_CUSTO TP_1,
    TP_COBRANCA TP_1,
    TP_NOTAFISCAL TP_1,
    TP_PREVISAO TP_1,
    TP_EXPORTADO_ACEITE TP_1,
    DT_EXPORTACAO_ACEITE DT,
    TP_EXPORTADO_BAIXA TP_1,
    DT_EXPORTACAO_BAIXA DT,
    TX_LOCAL_PAGAMENTO TX_60,
    TL_OBSERVACAO TL,
    TP_SITUACAO TP_1,
    ID_RECEBIMENTO ID,
    VL_CHEQUES VL,
    VL_COMPLEMENTO VL,
    DT_DEBITO DT,
    TP_CONCILIADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PAGAMENTOS_CUSTOS (
    ID_CUSTO ID NOT NULL,
    ID_PAGAMENTO ID,
    ID_CONTA_DESPESA ID,
    ID_CENTROCUSTO ID,
    VL_PAGAMENTO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PATRIMONIO (
    ID_PATRIMONIO ID NOT NULL,
    ID_CENTROCUSTO ID,
    CD_PATRIMONIO CD_10,
    TX_DESCRICAO TX_100,
    TX_MODELO TX_60,
    TX_MARCA TX_60,
    TX_SERIE TX_60,
    TX_VOLTAGEM TX_10,
    ID_FORNECEDOR ID,
    DT_COMPRA DT,
    CD_DOCUMENTO CD_10,
    VL_COMPRA VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PATRIMONIO_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    ID_PATRIMONIO ID,
    ID_CENTROCUSTO ID,
    DT_ENTRADA DT,
    DT_SAIDA DT,
    TX_OBSERVACOES TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PATRIMONIO_MANUTENCAO (
    ID_MANUTENCAO ID NOT NULL,
    ID_PATRIMONIO ID,
    DT_MANUTENCAO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PLANOCONTAS (
    ID_PLANOCONTA ID NOT NULL,
    CD_PLANOCONTA CD_20,
    CD_CLASSIFICACAO CD_20,
    TX_TITULO TX_60,
    TP_PRIVADA TP_1,
    TP_CONTA TP_1,
    TP_GRUPO TP_1,
    TP_ORIGEM TP_1,
    TP_ACESSO TP_1,
    TP_APROPRIACAO TP_1,
    TP_CONTACORRENTE TP_1,
    TP_CONTABILIZAR TP_1,
    TP_EXPORTACAO TP_1,
    TP_RELATORIO TP_1,
    TP_SITUACAO TP_1,
    TP_CUSTO TP_1,
    TP_CAMPO TP_1,
    ID_CONTA_RATEIO ID,
    ID_CONTA_CALCULO ID,
    PR_CALCULO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PRAZOSPAGAMENTO (
    ID_PRAZOPAGAMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    TP_PRAZO TP_1,
    NR_DIA INTEGER,
    NR_PARCELAS INTEGER,
    NR_PRAZO_1 INTEGER,
    NR_PRAZO_2 INTEGER,
    NR_PRAZO_3 INTEGER,
    NR_PRAZO_4 INTEGER,
    NR_PRAZO_5 INTEGER,
    NR_PRAZO_6 INTEGER,
    NR_PRAZO_7 INTEGER,
    NR_PRAZO_8 INTEGER,
    NR_PRAZO_9 INTEGER,
    NR_PRAZO_10 INTEGER,
    NR_PRAZO_11 INTEGER,
    NR_PRAZO_12 INTEGER,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PRAZOSRECEBIMENTO (
    ID_PRAZORECEBIMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    TP_PRAZO TP_1,
    NR_DIA INTEGER,
    NR_LIMITE INTEGER,
    NR_PARCELAS INTEGER,
    NR_PRAZO_1 INTEGER,
    NR_PRAZO_2 INTEGER,
    NR_PRAZO_3 INTEGER,
    NR_PRAZO_4 INTEGER,
    NR_PRAZO_5 INTEGER,
    NR_PRAZO_6 INTEGER,
    NR_PRAZO_7 INTEGER,
    NR_PRAZO_8 INTEGER,
    NR_PRAZO_9 INTEGER,
    NR_PRAZO_10 INTEGER,
    NR_PRAZO_11 INTEGER,
    NR_PRAZO_12 INTEGER,
    TP_PADRAO TP_1,
    TP_VENCIMENTO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PREVISOES_DESPESAS (
    ID_PREVISAO ID NOT NULL,
    ID_CONTA_DESPESA ID,
    ID_CONTA_CREDITO ID,
    TX_DESCRICAO TX_100,
    TP_PERIODO TP_1,
    DT_INICIO DT,
    DT_TERMINO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_PREVISOES_RECEITAS (
    ID_PREVISAO ID NOT NULL,
    ID_CONTA_DEBITO ID,
    ID_CONTA_RECEITA ID,
    TP_PERIODO TP_1,
    DT_INICIO DT,
    DT_TERMINO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_RECEBIMENTOS (
    ID_RECEBIMENTO ID NOT NULL,
    TP_RECEBIMENTO TP_1,
    TP_PREVISAO TP_1,
    TP_LANCAMENTO TP_3,
    ID_LANCAMENTO ID,
    ID_CONVENIO ID,
    ID_TIPODOCUMENTO ID,
    TX_DESCRICAO TX_100,
    TX_REFERENCIA TX_20,
    DT_LANCAMENTO DT,
    DT_EMISSAO DT,
    DT_VENCIMENTO DT,
    DT_PREVISAO DT,
    TP_PRIORIDADE TP_1,
    VL_DOCUMENTO VL,
    CD_CREDITO CD_20,
    CD_DEBITO CD_20,
    NR_PARCELA INTEGER,
    NR_PARCELAS INTEGER,
    VL_DOCUMENTO_1 VL,
    VL_DOCUMENTO_2 VL,
    VL_DOCUMENTO_3 VL,
    VL_DOCUMENTO_4 VL,
    DT_VENCIMENTO_1 DT,
    DT_VENCIMENTO_2 DT,
    DT_VENCIMENTO_3 DT,
    DT_VENCIMENTO_4 DT,
    ID_FORMA_CREDITO_1 ID,
    ID_FORMA_CREDITO_2 ID,
    ID_FORMA_CREDITO_3 ID,
    VL_FORMA_1 VL,
    VL_FORMA_2 VL,
    VL_FORMA_3 VL,
    DT_RECEBIMENTO DT,
    VL_RECEBIMENTO VL,
    VL_COMPLEMENTO VL,
    VL_MULTA VL,
    VL_JUROS VL,
    VL_DESCONTO VL,
    ID_FORMA_DEBITO ID,
    ID_FORMA_CREDITO ID,
    ID_TIPORECEBIMENTO ID,
    ID_CONTA_DEBITO ID,
    ID_CONTA_RECEITA ID,
    ID_CONTA_CREDITO ID,
    ID_CENTROCUSTO ID,
    ID_PRAZORECEBIMENTO ID,
    PR_BOLETO_JUROS PR,
    VL_BOLETO_JUROS VL,
    PR_BOLETO_MULTA PR,
    VL_BOLETO_MULTA VL,
    PR_BOLETO_DESCONTO_DIA PR,
    VL_BOLETO_DESCONTO_DIA VL,
    PR_BOLETO_DESCONTO_FIXO PR,
    VL_BOLETO_DESCONTO_FIXO VL,
    VL_BOLETO_TAXA VL,
    NR_PROTESTO INTEGER,
    TP_CONFERIDO TP_1,
    TP_CONTABILIZAR TP_1,
    TP_CUSTO TP_1,
    TP_EXPORTADO_ACEITE TP_1,
    TP_EXPORTADO_BAIXA TP_1,
    DT_EXPORTACAO_ACEITE DT,
    DT_EXPORTACAO_BAIXA DT,
    TL_INSTRUCOES TL,
    TL_MENSAGENS TL,
    TL_OBSERVACAO TL,
    TP_SITUACAO TP_1,
    TP_NOTAFISCAL TP_1,
    TP_COBRANCA TP_1,
    ID_PAGAMENTO ID,
    TP_CHEQUE TP_1,
    TX_BANCO TX_10,
    TX_AGENCIA TX_10,
    TX_CONTA CD_10,
    TX_EMITENTE TX_100,
    TX_DOCUMENTO TX_20,
    DT_COMPENSACAO DT,
    DT_DEVOLUCAO DT,
    ID_ALINEA_1 ID,
    ID_ALINEA_2 ID,
    TX_CHEQUE TX_20,
    TX_CHEQUE_OBSERVACAO TX_100,
    CD_RECIBO CD_10,
    DT_CREDITO DT,
    ID_REMESSA ID,
    DT_REMESSA DT,
    DT_RETORNO DT,
    TP_OCORRENCIA TP_2,
    DT_OCORRENCIA DT,
    CD_REGISTRO CD_20,
    TX_MOTIVO TX_100,
    ID_AUTORIZACAO ID,
    DT_NFE_EMISSAO DT,
    CD_NFE_NUMERO CD_10,
    CD_NFE_PROTOCOLO CD_20,
    DT_IMPRESSAO_COBRANCA DT,
    DT_IMPRESSAO_NF DT,
    TP_CONCILIADO TP_1,
    ID_CONCILIACAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_RECEBIMENTOS_CUSTOS (
    ID_CUSTO ID NOT NULL,
    ID_RECEBIMENTO ID,
    ID_CONTA_RECEITA ID,
    ID_CENTROCUSTO ID,
    VL_RECEBIMENTO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_REMESSAS (
    ID_REMESSA ID NOT NULL,
    ID_CONTABANCARIA ID,
    TX_ARQUIVO TX_255,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_CRIACAO DT);


CREATE TABLE CTR_TALOES (
    ID_TALAO ID NOT NULL,
    ID_CONTABANCARIA ID,
    DT_RECEBIMENTO DT,
    CD_INICIAL CD_10,
    CD_FINAL CD_10,
    TX_OBSERVACAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_TIPOSDOCUMENTOS (
    ID_TIPODOCUMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    CD_DOCUMENTO CD_10,
    TP_AUTOMATICO TP_1,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_TIPOSPAGAMENTO (
    ID_TIPOPAGAMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_TIPOSRECEBIMENTO (
    ID_TIPORECEBIMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    TP_PADRAO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE CTR_TRANSFERENCIAS (
    ID_TRANSFERENCIA ID NOT NULL,
    ID_CHEQUE ID,
    ID_CONTA_DEBITO ID,
    ID_CONTA_CREDITO ID,
    DT_TRANSFERENCIA DT,
    VL_TRANSFERENCIA VL,
    TX_DESCRICAO TX_60,
    TX_DOCUMENTO TX_40,
    ID_FORMAPAGAMENTO ID,
    ID_TIPOPAGAMENTO ID,
    TP_EXPORTADO TP_1,
    DT_EXPORTACAO DT,
    TP_CONCILIADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    ID_ESTOQUE_ENTRADA ID,
    ID_ESTOQUE_SAIDA ID,
    ID_FUNCAO_OPERADOR ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_EMBALAGENS (
    ID_EMBALAGEM ID NOT NULL,
    DT_LANCAMENTO DT,
    NR_QUANTIDADE NR,
    TP_LANCAMENTO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_ENTRADAS (
    ID_ENTRADA ID NOT NULL,
    CD_ENTRADA CD_10,
    DT_ENTRADA DT,
    ID_CLIENTE ID,
    VL_TOTAL VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_ENTRADAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_ENTRADA ID,
    ID_RETORNO ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    CD_LOTE CD_20,
    CD_ENTRADA CD_10,
    ID_ORDEM ID,
    ID_ORDEM_ITEM ID,
    TP_RETORNO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_FERRAMENTAS (
    ID_FERRAMENTA ID NOT NULL,
    TX_DESCRICAO TX_60,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_MAQUINAS (
    ID_MAQUINA ID NOT NULL,
    CD_MAQUINA CD_10,
    TX_DESCRICAO TX_60,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    NR_QUANTIDADE_HORA NR,
    VL_PREPARACAO VL,
    TP_PARADA_ALMOCO TP_1,
    HR_INICIO HR,
    HR_TERMINO HR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_OPERACOES (
    ID_OPERACAO ID NOT NULL,
    CD_OPERACAO CD_10,
    TX_DESCRICAO TX_60,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_OPERADORES (
    ID_OPERADOR ID NOT NULL,
    ID_FUNCIONARIO ID,
    TX_NOME TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_ORDENS (
    ID_ORDEM ID NOT NULL,
    ID_TIPOORDEM ID,
    CD_ORDEM CD_10,
    TP_SITUACAO TP_1,
    ID_VENDA ID,
    DT_EMISSAO DT,
    DT_ENCERRAMENTO DT,
    ID_PRODUTO ID,
    TX_DESCRICAO TX_60,
    ID_ESTOQUE_SAIDA ID,
    ID_ESTOQUE_ENTRADA ID,
    TX_REFERENCIA TX_20,
    CD_LOTE CD_20,
    NR_PRAZO INTEGER,
    NR_PESO_BRUTO NR,
    NR_PESO_LIQUIDO NR,
    NR_PEDIDA NR,
    NR_FABRICADA NR,
    NR_DEFEITO_MP NR,
    NR_DEFEITO_SA NR,
    NR_DEFEITO_FR NR,
    VL_UNITARIO_MO VL,
    VL_UNITARIO_MP VL,
    VL_UNITARIO VL,
    VL_TOTAL_MO VL,
    VL_TOTAL_MP VL,
    VL_TOTAL VL,
    HR_TEMPO_REAL HR,
    HR_TEMPO_ESTIMADO HR,
    TP_ESTOQUE TP_1,
    ID_CLIENTE ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_ORDENS_BAIXAS (
    ID_BAIXA ID NOT NULL,
    ID_PROCESSO ID,
    ID_MAQUINA ID,
    ID_OPERADOR ID,
    ID_OPERACAO ID,
    ID_PARADA ID,
    DT_INICIO DT,
    DT_TERMINO DT,
    TX_OBSERVACAO TX_60,
    TP_BAIXA TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_ORDENS_COMPOSICAO (
    ID_ITEM ID NOT NULL,
    ID_ORDEM ID,
    ID_COMPONENTE ID,
    TX_UNIDADE TX_UNIDADE,
    NR_UNITARIO NR,
    NR_TOTAL NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    CD_LOTE CD_20,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_ORDENS_PARCIAIS (
    ID_ITEM ID NOT NULL,
    ID_ORDEM ID,
    DT_FABRICACAO DT,
    NR_QUANTIDADE NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_ORDENS_PARTES (
    ID_PARTE ID NOT NULL,
    ID_ORDEM ID,
    ID_NUMERO ID,
    TX_DESCRICAO TX_60,
    CD_DESENHO CD_20,
    ID_COMPONENTE ID,
    TX_UNIDADE TX_UNIDADE,
    NR_UNITARIO NR,
    NR_TOTAL NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    CD_LOTE CD_20,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_ORDENS_PROCESSOS (
    ID_PROCESSO ID NOT NULL,
    ID_ORDEM ID,
    ID_PARTE ID,
    ID_OPERACAO ID,
    ID_MAQUINA ID,
    ID_FERRAMENTA ID,
    HR_TEMPO HR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_PARADAS (
    ID_PARADA ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_PERDAS (
    ID_PERDA ID NOT NULL);


CREATE TABLE FAC_PRODUTOS_COMPOSICAO (
    ID_COMPOSICAO ID NOT NULL,
    ID_PRODUTO ID,
    ID_COMPONENTE ID,
    ID_ITEM ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    NR_PERDA NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_PRODUTOS_PROCESSOS (
    ID_PROCESSO ID NOT NULL,
    ID_PRODUTO ID,
    NR_SEQUENCIA NI,
    ID_OPERACAO ID,
    ID_FERRAMENTA ID,
    ID_MAQUINA ID,
    HR_TEMPO HS,
    TL_DESCRICAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_RETORNOS (
    ID_RETORNO ID NOT NULL,
    ID_CLIENTE ID,
    ID_SERIE ID,
    DT_RETORNO DT,
    CD_RETORNO CD_10,
    ID_VENDA ID,
    ID_CFOP ID,
    VL_TOTAL VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE FAC_TIPOSORDENS (
    ID_TIPOORDEM ID NOT NULL,
    CD_TIPOORDEM CD_10,
    TP_ORDEM TP_3,
    CD_ORDEM CD_10,
    TX_DESCRICAO TX_60,
    TP_FORMATO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ACABAMENTOS (
    ID_ACABAMENTO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    HR_PREPARACAO HR,
    NR_QUANTIDADE NR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ATENDENTES (
    ID_ATENDENTE ID NOT NULL,
    TP_ATENDENTE TP_1,
    ID_FUNCIONARIO ID,
    TX_NOME TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    ID_CLASSE_TINTA ID,
    ID_CLASSE_PAPEL ID,
    PR_MARGEM PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_IMPRESSORAS (
    ID_IMPRESSORA ID NOT NULL,
    TX_DESCRICAO TX_60,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    NR_QUANTIDADE NR,
    HR_PREPARACAO HR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_OPERADORES (
    ID_OPERADOR ID NOT NULL,
    TP_OPERADOR TP_1,
    ID_FUNCIONARIO ID,
    TX_NOME TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORCAMENTOS (
    ID_ORCAMENTO ID NOT NULL,
    CD_ORCAMENTO CD_10,
    DT_ORCAMENTO DT,
    DT_VALIDADE DT,
    ID_CLIENTE ID,
    TX_DESCRICAO TX_100,
    NR_LARGURA NR,
    NR_COMPRIMENTO NR,
    NR_CORES_FRENTE NI,
    NR_CORES_VERSO NI,
    NR_CHAPA NI,
    TP_SITUACAO TP_1,
    PR_MARGEM PR,
    ID_FORMARECEBIMENTO ID,
    ID_PRAZORECEBIMENTO ID,
    ID_VENDEDOR ID,
    TX_PRAZO TX_10,
    TL_OBSERVACOES TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORCAMENTOS_ACABAMENTO (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_ACABAMENTO ID,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORCAMENTOS_IMPRESSORAS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_IMPRESSORA ID,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORCAMENTOS_PAPEIS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    NR_VIA NI,
    ID_PAPEL ID,
    ID_FORMATO ID,
    NR_FOLHAS NI,
    NR_IMPRESSOS NI,
    VL_UNITARIO VL,
    TX_DESCRICAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORCAMENTOS_QUANTIDADES (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    NR_QUANTIDADE NI,
    VL_CUSTO VL,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    TP_SITUACAO TP_1,
    ID_ORDEMSERVICO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORCAMENTOS_SERVICOS (
    ID_ITEM ID NOT NULL,
    ID_SERVICO ID,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT,
    ID_ORCAMENTO ID);


CREATE TABLE GRP_ORCAMENTOS_TINTAS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_TINTA ID,
    NR_CORES_FRENTE NI,
    NR_CORES_VERSO NI,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORDENS (
    ID_ORDEMSERVICO ID NOT NULL,
    CD_ORDEMSERVICO CD_10,
    ID_ATENDENTE ID,
    DT_EMISSAO DT,
    ID_CLIENTE ID,
    TP_SITUACAO TP_1,
    NR_PRAZO NI,
    DT_ENTREGA DT,
    DT_TERMINO DT,
    DT_RETIRADA DT,
    TL_DESCRICAO TL,
    NR_QUANTIDADE NR,
    NR_LARGURA NR,
    NR_COMPRIMENTO NR,
    NR_CORES_FRENTE NI,
    NR_CORES_VERSO NI,
    NR_CHAPA INTEGER,
    TX_DESENHO TX_100,
    TL_COMPOSICAO TL,
    TL_CORTE TL,
    TL_IMPRESSAO TL,
    TL_ACABAMENTO TL,
    NR_MARGEM NR,
    NR_NUMERACAO_INICIAL NI,
    NR_NUMERACAO_FINAL NI,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORDENS_ACABAMENTO (
    ID_ITEM ID NOT NULL,
    ID_ORDEMSERVICO ID,
    ID_ACABAMENTO ID,
    ID_OPERADOR ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORDENS_IMPRESSORAS (
    ID_ITEM ID NOT NULL,
    ID_ORDEMSERVICO ID,
    ID_IMPRESSORA ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORDENS_PAPEIS (
    ID_ITEM ID NOT NULL,
    ID_ORDEMSERVICO ID,
    NR_VIA NI,
    ID_PAPEL ID,
    ID_FORMATO ID,
    NR_FOLHAS NI,
    NR_IMPRESSOS NI,
    TX_DESCRICAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORDENS_SERVICOS (
    ID_ITEM ID NOT NULL,
    ID_ORDEMSERVICO ID,
    ID_SERVICO ID,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_ORDENS_TINTAS (
    ID_ITEM ID NOT NULL,
    ID_ORDEMSERVICO ID,
    ID_TINTA ID,
    NR_CORES_FRENTE NR,
    NR_CORES_VERSO NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE GRP_SERVICOS (
    ID_SERVICO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    ID_CLASSE_TRATAMENTO ID,
    ID_CLASSE_UNIFORMES ID,
    ID_CLASSE_CESTAS ID,
    ID_CLASSE_MATERIAIS ID,
    VL_PISO VL,
    VL_MINIMO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_CONTRATOS (
    ID_CONTRATO ID NOT NULL,
    ID_CLIENTE ID,
    ID_CENTROCUSTO ID,
    CD_CONTRATO CD_10,
    TX_DESCRICAO TX_100,
    TP_SITUACAO TP_1,
    DT_INICIO DT,
    DT_TERMINO DT,
    VL_TOTAL VL,
    NR_PARCELAS NR,
    VL_PARCELA VL,
    DT_VENCIMENTO DT,
    ID_CONTA_RECEITA ID,
    ID_CONTA_CREDITO ID,
    ID_TIPORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    ID_TIPODOCUMENTO ID,
    TL_CONTRATO TL,
    VL_SERVICOS VL,
    VL_PRODUTOS VL,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_IE,
    TL_DESCRICAO TL,
    ID_NATUREZA ID,
    VL_INSUMOS VL,
    VL_MAOOBRA VL,
    VL_RETENCOES VL,
    VL_CONTRATO VL,
    VL_NOTA VL,
    PR_ISS PR,
    VL_ISS VL,
    TP_ISS_RETIDO TP_1,
    PR_IRRF PR,
    VL_IRRF VL,
    TP_IRRF_RETIDO TP_1,
    PR_INSS PR,
    VL_INSS VL,
    TP_INSS_RETIDO TP_1,
    PR_INSS_BASE PR,
    VL_INSS_DEDUCAO VL,
    PR_FEDERAIS PR,
    VL_FEDERAIS VL,
    TP_FEDERAIS_RETIDO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_CONTRATOS_EQUIPAMENTOS (
    ID_ITEM ID NOT NULL,
    ID_CONTRATO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT,
    ID_PATRIMONIO ID);


CREATE TABLE HDS_CONTRATOS_FUNCIONARIOS (
    ID_CONTRATO_FUNCIONARIO ID NOT NULL,
    ID_CONTRATO ID,
    ID_FUNCAO ID,
    NR_QUANTIDADE NR,
    VL_REMUNERACOES VL,
    VL_ENCARGOS VL,
    VL_BENEFICIOS VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_CONTRATOS_INSUMOS (
    ID_ITEM ID NOT NULL,
    ID_CONTRATO ID,
    TX_DESCRICAO TX_100,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_CONTRATOS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_CONTRATO ID,
    ID_PRODUTO ID,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_CONTRATOS_SERVICOS (
    ID_ITEM ID NOT NULL,
    ID_CONTRATO ID,
    TX_DESCRICAO TX_100,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS (
    ID_ORCAMENTO ID NOT NULL,
    CD_ORCAMENTO CD_10,
    DT_ORCAMENTO DT,
    TP_CLIENTE TX_60,
    ID_CLIENTE ID,
    ID_POTENCIAL ID,
    TP_SITUACAO TP_1,
    ID_ENCARGO ID,
    PR_ENCARGOS PR,
    PR_ADMINISTRACAO PR,
    VL_REMUNERACAO VL,
    VL_ENCARGOS VL,
    VL_BENEFICIOS VL,
    VL_FUNCIONARIOS VL,
    VL_UNIFORMES VL,
    VL_MAQUINAS VL,
    VL_TRATAMENTO_IMPLANTACAO VL,
    PR_CUSTO_FINANCEIRO PR,
    NR_TRATAMENTO_MESES NI,
    VL_TRATAMENTO_MANUTENCAO VL,
    VL_TRATAMENTO VL,
    VL_MATERIAIS VL,
    VL_OUTROS VL,
    VL_SUBTOTAL VL,
    PR_IMPOSTOS PR,
    VL_IMPOSTOS VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS_FUNCIONARIOS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_FUNCAO ID,
    NR_QUANTIDADE NI,
    VL_SALARIO VL,
    VL_FERIADOS VL,
    NR_FERIADOS NI,
    VL_PISO VL,
    PR_GRATIFICACAO PR,
    VL_GRATIFICACAO VL,
    HR_HORAS_MENSAIS HT,
    HR_HORAS_NOTURNAS HR,
    NR_DIAS_NOTURNO NI,
    VL_NOTURNO VL,
    PR_INSALUBRIDADE PR,
    VL_MINIMO VL,
    VL_INSALUBRIDADE VL,
    PR_PERICULOSIDADE PR,
    VL_PERICULOSIDADE VL,
    HR_EXTRAS HR,
    PR_EXTRAS PR,
    VL_EXTRAS VL,
    NR_DIAS NI,
    VL_PASSAGENS VL,
    VL_TRANSPORTE VL,
    VL_ALIMENTACAO_DIA VL,
    VL_ALIMENTACAO VL,
    VL_ASSISTENCIA VL,
    VL_CESTA VL,
    VL_SEGUROS VL,
    VL_OUTROS VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS_IMPOSTOS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_IMPOSTO ID,
    PR_IMPOSTO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS_MAQUINAS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    NR_MESES NI,
    VL_DEPRECIACAO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS_MATERIAIS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_PRODUTO ID,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS_OUTROS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    TX_DESCRICAO TX_100,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS_TRANSPORTES (
    ID_ITEM_TRANSPORTE ID NOT NULL,
    ID_ITEM ID,
    ID_TRANSPORTE ID,
    VL_PASSAGEM VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS_TRATAMENTO (
    ID_ITEM ID NOT NULL,
    TP_TRATAMENTO TP_1,
    ID_ORCAMENTO ID,
    TX_SETOR TX_40,
    NR_AREA NR,
    ID_PRODUTO ID,
    NR_EMBALAGEM NR,
    VL_EMBALAGEM VL,
    NR_DILUICAO NR,
    NR_RENDIMENTO NR,
    NR_RECAMADAS NI,
    VL_UNITARIO_DILUIDO VL,
    VL_UNITARIO_CONCENTRADO VL,
    NR_CONSUMO NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    NR_QUANTIDADE_COMPRA NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HDS_ORCAMENTOS_UNIFORMES (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    NR_MESES NI,
    VL_DEPRECIACAO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_AGENDAMENTO (
    ID_AGENDAMENTO ID NOT NULL,
    HR_INICIO HR,
    HR_TERMINO HR,
    TP_DOMINGO TP_1,
    TP_SEGUNDA TP_1,
    TP_TERCA TP_1,
    TP_QUARTA TP_1,
    TP_QUINTA TP_1,
    TP_SEXTA TP_1,
    TP_SABADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_APONTAMENTOS (
    ID_FUNCIONARIO ID NOT NULL,
    DT_APONTAMENTO DT NOT NULL,
    ID_PERIODO ID,
    ID_JUSTIFICATIVA ID,
    TP_APONTAMENTO TP_2,
    HR_ENTRADA_1 HR,
    HR_SAIDA_1 HR,
    TP_HORAS_1 TP_1,
    ID_CENTROCUSTO_1 ID,
    HR_ENTRADA_2 HR,
    HR_SAIDA_2 HR,
    TP_HORAS_2 TP_1,
    ID_CENTROCUSTO_2 ID,
    HR_ENTRADA_3 HR,
    HR_SAIDA_3 HR,
    TP_HORAS_3 TP_1,
    ID_CENTROCUSTO_3 ID,
    HR_ENTRADA_4 HR,
    HR_SAIDA_4 HR,
    TP_HORAS_4 TP_1,
    ID_CENTROCUSTO_4 ID,
    HR_TRABALHADAS HR,
    HR_EXTRAS_50 HR,
    HR_EXTRAS_100 HR,
    HR_NOTURNO HR,
    HR_FORA HR,
    HR_DEVIDAS HR,
    TX_LEITURA TX_100,
    TL_OBSERVACAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_CANDIDATOS (
    ID_CANDIDATO ID NOT NULL,
    ID_CANDIDATO_WEB ID,
    CD_CANDIDATO CD_10,
    DT_CADASTRO DT,
    TP_SITUACAO TP_1,
    TX_NOME TX_60,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_TELEFONES TX_40,
    TX_CELULAR TX_40,
    TX_RECADO TX_40,
    TX_EMAIL TX_60,
    TX_PAI TX_60,
    TX_MAE TX_60,
    DT_NASCIMENTO DT,
    TP_SEXO TP_1,
    TX_NACIONALIDADE TX_60,
    TX_NATURALIDADE TX_60,
    ID_ESTADOCIVIL ID,
    ID_ESCOLARIDADE ID,
    ID_FORMACAO ID,
    ID_FUNCAO_1 ID,
    ID_FUNCAO_2 ID,
    TX_CPF TX_CPF,
    TX_CI TX_CI,
    TX_CI_ESTADO TX_ESTADO,
    TX_CI_ORGAO TX_10,
    DT_CI_EMISSAO DT,
    TX_CNH_TIPO TP_1,
    TX_CNH TX_10,
    DT_CNH_VENCIMENTO DT,
    TX_CTPS_NUMERO TX_20,
    TX_CTPS_SERIE TX_10,
    TX_PIS TX_40,
    TX_PROFISSAO TX_60,
    TX_CURSOS TX_255,
    TX_IDIOMAS TX_255,
    TX_INFORMATICA TX_255,
    TX_OBSERVACOES TX_255,
    TX_E1_EMPRESA TX_60,
    TX_E1_RAMO TX_60,
    TX_E1_TELEFONE TX_20,
    TX_E1_ADMISSAO TX_20,
    TX_E1_DEMISSAO TX_20,
    TX_E1_SALARIO TX_20,
    ID_E1_FUNCAO ID,
    TX_E1_ATIVIDADES TX_255,
    TX_E2_EMPRESA TX_60,
    TX_E2_RAMO TX_60,
    TX_E2_TELEFONE TX_20,
    TX_E2_ADMISSAO TX_20,
    TX_E2_DEMISSAO TX_20,
    TX_E2_SALARIO TX_20,
    ID_E2_FUNCAO ID,
    TX_E2_ATIVIDADES TX_255,
    TX_E3_EMPRESA TX_60,
    TX_E3_RAMO TX_60,
    TX_E3_TELEFONE TX_20,
    TX_E3_ADMISSAO TX_20,
    TX_E3_DEMISSAO TX_20,
    TX_E3_SALARIO TX_20,
    ID_E3_FUNCAO ID,
    TX_E3_ATIVIDADES TX_255,
    TX_SALARIO TX_20,
    TP_DISPONIBILIDADE TP_1,
    TP_NECESSIDADES TP_1,
    TL_ASPECTOS TL,
    TL_REFERENCIAS TL,
    TX_PARECER TX_20,
    TX_IMAGEM TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_CANDIDATOS_TESTES (
    ID_TESTE ID NOT NULL,
    ID_CANDIDATO ID NOT NULL,
    TX_RESULTADO TX_40,
    TX_IMAGEM TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_CARGOS (
    ID_CARGO INTEGER NOT NULL);


CREATE TABLE HMN_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    TP_PONTO TP_1,
    TP_TED_TECLADO TP_1,
    TP_TED_OFFLINE TP_1,
    VL_MINIMO VL,
    VL_PISO VL,
    TP_EXTRA_DOMINGO TP_1,
    TP_EXTRA_SEGUNDA TP_1,
    TP_EXTRA_TERCA TP_1,
    TP_EXTRA_QUARTA TP_1,
    TP_EXTRA_QUINTA TP_1,
    TP_EXTRA_SEXTA TP_1,
    TP_EXTRA_SABADO TP_1,
    TP_EXTRA_FERIADOS TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_CURSOS (
    ID_CURSO ID NOT NULL,
    TX_DESCRICAO TX_100,
    NR_VALIDADE NI,
    TL_PROGRAMA TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_ENCARGOS (
    ID_ENCARGO ID NOT NULL,
    TX_DESCRICAO TX_60,
    PR_SOCIAIS PR,
    PR_TRABALHISTAS PR,
    PR_DEMISSIONAIS PR,
    PR_INCIDENCIA PR,
    PR_TOTAL PR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_ENCARGOS_DEMISSIONAIS (
    ID_ITEM ID NOT NULL,
    ID_ENCARGO ID,
    TX_DESCRICAO TX_60,
    PR_ENCARGO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_ENCARGOS_SOCIAIS (
    ID_ITEM ID NOT NULL,
    ID_ENCARGO ID,
    TX_DESCRICAO TX_60,
    PR_ENCARGO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_ENCARGOS_TRABALHISTAS (
    ID_ITEM ID NOT NULL,
    ID_ENCARGO ID,
    TX_DESCRICAO TX_60,
    PR_ENCARGO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_ESCOLARIDADE (
    ID_ESCOLARIDADE ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_ESTADOCIVIL (
    ID_ESTADOCIVIL ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_EVENTOS (
    ID_EVENTO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FERIADOS (
    DT_FERIADO DT NOT NULL,
    TX_DESCRICAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FORMACAO (
    ID_FORMACAO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS (
    ID_FUNCIONARIO ID NOT NULL,
    CD_FUNCIONARIO CD_10,
    CD_IDENTIFICACAO CD_20,
    TP_SITUACAO TP_1,
    DT_CADASTRO DT,
    TX_NOME TX_60,
    TX_APELIDO TX_20,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_TELEFONES TX_40,
    TX_CELULAR TX_40,
    TX_RECADO TX_40,
    TX_EMAIL TX_60,
    TX_PAI TX_60,
    TX_MAE TX_60,
    DT_NASCIMENTO DT,
    TX_NACIONALIDADE TX_60,
    TX_NATURALIDADE TX_60,
    ID_ESTADOCIVIL ID,
    TP_ESTADO_CIVIL TP_1,
    TX_CONJUGE TX_60,
    DT_ADMISSAO DT,
    DT_DEMISSAO DT,
    TX_MOTIVO_DEMISSAO TX_100,
    ID_SETOR ID,
    ID_FUNCAO ID,
    ID_FORMACAO ID,
    ID_ESCOLARIDADE ID,
    TX_CPF TX_CPF,
    TX_CI TX_CI,
    TX_CI_ESTADO TX_ESTADO,
    TX_CI_ORGAO TX_10,
    DT_CI_EMISSAO DT,
    TX_CNH TX_10,
    TX_CNH_CAT TP_1,
    DT_CNH_VENCIMENTO DT,
    TX_CTPS_NUMERO TX_20,
    TX_CTPS_SERIE TX_10,
    DT_CTPS_EMISSAO DT,
    TX_PIS TX_40,
    TX_TE TX_40,
    TX_TE_ZONA CD_10,
    TX_TE_SECAO CD_10,
    TX_RESERVISTA TX_20,
    TX_OAB TX_20,
    TX_REGISTRO TX_60,
    TX_PROFISSAO TX_60,
    TX_INSTRUCAO TX_60,
    TL_CURSOS TL,
    TL_EXPERIENCIA TL,
    TP_PAGAMENTO TP_1,
    ID_ENCARGO ID,
    VL_PAGAMENTO VL,
    PR_COMISSAO PR,
    TP_COMISSAO TP_1,
    TP_TRANSPORTE TP_1,
    NR_VALES_DIA INTEGER,
    ID_CENTROCUSTO ID,
    TP_HORARIO_AUTO TP_1,
    TX_UNIFORME CD_10,
    TX_CALCADO NR,
    NR_DEPENDENTES INTEGER,
    TX_BANCO TX_20,
    CD_AGENCIA CHAR(4) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_BANCO CHAR(3) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_CONTA CHAR(10) CHARACTER SET WIN1252 COLLATE WIN1252,
    TL_OBSERVACOES TL,
    TP_HORARIO TP_1,
    ID_HORARIO ID,
    TP_JORNADA TP_1,
    HT_JOR_TRABALHO HT,
    HT_JOR_DESCANSO HT,
    NR_ESCALA_TRABALHO INTEGER,
    NR_ESCALA_DESCANSO INTEGER,
    TP_AUTO_TODOS TP_1,
    TP_AUTO_SAIDA_1 TP_1,
    TP_AUTO_ENTRADA_1 TP_1,
    TP_ACUMULADAS TP_1,
    TP_COMPENSACAO TP_1,
    TP_ALMOCO_FIXO TP_1,
    TP_EXTRAS TP_1,
    TP_NOTURNO TP_1,
    TP_CENTROCUSTO TP_1,
    TP_AUTORIZACAO TP_1,
    HR_TOL_ENTRADA_1 HR,
    HR_TOL_SAIDA_1 HR,
    HR_TOL_ENTRADA_2 HR,
    HR_TOL_SAIDA_2 HR,
    PR_DESCONTO_MAX PR,
    TP_IMPRIMIR TP_1,
    TX_IMAGEM TX_60,
    ID_TIPOCONTATO ID,
    TP_SEXO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS_AFASTAMENTOS (
    ID_AFASTAMENTO ID NOT NULL,
    ID_FUNCIONARIO ID,
    DT_INICIAL DT,
    DT_FINAL DT,
    TP_APONTAMENTO TP_2,
    ID_JUSTIFICATIVA ID,
    TX_DESCRICAO CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS_ATESTADOS (
    ID_ATESTADO ID NOT NULL,
    ID_FUNCIONARIO ID,
    DT_EMISSAO DT,
    TX_DESCRICAO TX_60,
    DT_VALIDADE DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS_CENTROSCUSTO (
    ID_ITEM ID NOT NULL,
    ID_CENTROCUSTO ID,
    ID_FUNCIONARIO ID,
    DT_INICIAL DT,
    DT_FINAL DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS_DEPENDENTES (
    ID_DEPENDENTE ID NOT NULL,
    ID_FUNCIONARIO ID,
    TX_NOME TX_60,
    DT_NASCIMENTO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS_HABILIDADES (
    ID_ITEM ID NOT NULL,
    ID_FUNCIONARIO ID,
    ID_HABILIDADE ID);


CREATE TABLE HMN_FUNCIONARIOS_HISTORICO (
    ID_ITEM ID NOT NULL,
    ID_FUNCIONARIO ID,
    ID_CENTROCUSTO ID,
    ID_FUNCAO ID,
    DT_INICIO DT,
    DT_TERMINO DT,
    TX_OBSERVACOES TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS_HORARIOS (
    ID_FUNCIONARIO ID NOT NULL,
    TP_DIA TP_1 NOT NULL,
    HR_ENTRADA_1 HR,
    HR_SAIDA_1 HR,
    HR_ENTRADA_2 HR,
    HR_SAIDA_2 HR,
    HR_ENTRADA_3 HR,
    HR_SAIDA_3 HR,
    HR_ENTRADA_4 HR,
    HR_SAIDA_4 HR,
    HR_JORNADA HR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS_TOTAIS (
    ID_FUNCIONARIO ID NOT NULL,
    ID_PERIODO ID NOT NULL,
    DT_ESCALA DT,
    HR_ACUMULADAS HT,
    HR_TRABALHADAS HT,
    HR_FORA HT,
    HR_EXTRAS_50 HT,
    HR_EXTRAS_100 HT,
    HR_NOTURNO HT,
    HR_FALTAS HT,
    NR_FALTAS INTEGER,
    HR_SUSPENSAO HT,
    HR_FERIADOS HT,
    HR_DEVIDAS HT,
    HR_PAGAS HT,
    HR_SALDO HT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCIONARIOS_UNIFORMES (
    ID_UNIFORME ID NOT NULL,
    ID_FUNCIONARIO ID,
    DT_EMISSAO DT,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_FUNCOES (
    ID_FUNCAO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TX_CBO CD_10,
    VL_SALARIO VL,
    PR_PERICULOSIDADE PR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_HABILIDADES (
    ID_HABILIDADE ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_HORARIOS (
    ID_HORARIO ID NOT NULL,
    TX_DESCRICAO TX_40,
    TP_JORNADA TP_1,
    NR_ESCALA_TRABALHO INTEGER,
    NR_ESCALA_DESCANSO INTEGER,
    TP_AUTO_TODOS TP_1,
    TP_AUTO_SAIDA_1 TP_1,
    TP_AUTO_ENTRADA_1 TP_1,
    HT_JOR_TRABALHO HT,
    HT_JOR_DESCANSO HT,
    HR_TOL_ENTRADA_1 HR,
    HR_TOL_SAIDA_1 HR,
    HR_TOL_ENTRADA_2 HR,
    HR_TOL_SAIDA_2 HR,
    TP_ACUMULADAS TP_1,
    TP_COMPENSACAO TP_1,
    TP_ALMOCO_FIXO TP_1,
    TP_EXTRAS TP_1,
    TP_NOTURNO TP_1 COLLATE WIN1252,
    TP_AUTORIZACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_HORARIOS_DIAS (
    ID_HORARIO ID NOT NULL,
    TP_DIA TP_1 NOT NULL,
    HR_ENTRADA_1 HR,
    HR_SAIDA_1 HR,
    HR_ENTRADA_2 HR,
    HR_SAIDA_2 HR,
    HR_ENTRADA_3 HR,
    HR_SAIDA_3 HR,
    HR_ENTRADA_4 HR,
    HR_SAIDA_4 HR,
    HR_JORNADA HR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_JUSTIFICATIVAS (
    ID_JUSTIFICATIVA ID NOT NULL,
    CD_JUSTIFICATIVA CHAR(5) CHARACTER SET WIN1252 COLLATE WIN1252,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_OCORRENCIAS (
    ID_OCORRENCIA ID NOT NULL,
    DT_OCORRENCIA DT,
    ID_FUNCIONARIO ID,
    ID_EVENTO ID,
    TL_OCORRENCIA TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_PERIODOS (
    ID_PERIODO ID NOT NULL,
    TX_REFERENCIA CHAR(7) CHARACTER SET WIN1252 COLLATE WIN1252,
    DT_INICIAL DT,
    DT_FINAL DT,
    DT_FECHAMENTO DT,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_RECESSOS (
    DT_RECESSO DT NOT NULL,
    TX_DESCRICAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_SETORES (
    ID_SETOR ID NOT NULL,
    TX_DESCRICAO TX_40,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_SIRENES (
    ID_SIRENE ID NOT NULL,
    HR_TOQUE HR,
    NR_SEGUNDOS NI,
    NR_TOQUES NI,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_TECNICAS (
    ID_TECNICA ID,
    TX_DESCRICAO TX_60,
    TX_DESCRICAO_DETALHADA TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_TESTES (
    ID_TESTE ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_TRANSPORTES (
    ID_TRANSPORTE ID NOT NULL,
    TX_DESCRICAO TX_60,
    VL_PASSAGEM VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_TURMAS (
    ID_TURMA ID NOT NULL,
    ID_CURSO ID,
    CD_TURMA CD_10,
    DT_INICIO DT,
    DT_TERMINO DT,
    HR_INICIO HR,
    HR_TERMINO HR,
    NR_VAGAS NI,
    VL_TOTAL VL,
    VL_INDIVIDUAL VL,
    TX_LOCAL TX_100,
    TX_INSTRUTOR TX_100,
    NR_CARGA_HORARIA NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_TURMAS_FUNCIONARIOS (
    ID_ITEM ID NOT NULL,
    ID_TURMA ID,
    ID_FUNCIONARIO ID,
    NR_NOTA NR,
    PR_FREQUENCIA PR,
    TP_PRESENCA TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_VAGAS (
    ID_VAGA ID NOT NULL,
    TP_SITUACAO TP_1,
    ID_FUNCAO ID,
    ID_FORMACAO ID,
    ID_ESCOLARIDADE ID,
    TX_SALARIO TX_60,
    TX_LOCAL TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TP_MASCULINO TP_1,
    TP_FEMININO TP_1,
    TL_CARACTERISTICAS TL,
    TL_DESCRICAO TL,
    TL_OBSERVACOES TL,
    TP_DESTAQUE TP_1,
    DT_PUBLICACAO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE HMN_VAGAS_CANDIDATOS (
    ID_VAGA ID NOT NULL,
    ID_CANDIDATO ID NOT NULL,
    DT_CONTATO DT,
    DT_ENTREVISTA DT,
    TX_SITUACAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_ARTIGOS (
    ID_PUBLICACAO ID NOT NULL,
    TP_SITUACAO TP_1,
    CD_REGISTRO CD_20,
    TX_CLASSIFICACAO TX_20,
    TX_TITULO TX_100,
    TL_TEXTO TL,
    TX_ORIGEM TX_100,
    TX_VOLUME TX_10,
    TX_NUMERO TX_10,
    TX_ANO TX_10,
    DT_REGISTRO DT,
    DT_CADASTRO DT,
    TP_ORIGEM TP_1,
    TP_IMP_REGISTRO TP_1,
    TP_IMP_CLASSIFICACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_ARTIGOS_ASSUNTOS (
    ID_PUBLICACAO ID NOT NULL,
    ID_ASSUNTO ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_ARTIGOS_AUTORES (
    ID_PUBLICACAO ID NOT NULL,
    ID_AUTOR ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_ARTIGOS_IMAGENS (
    ID_PUBLICACAO ID NOT NULL,
    ID_IMAGEM ID NOT NULL,
    BL_IMAGEM BL,
    TX_DESCRICAO TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_ASSUNTOS (
    ID_ASSUNTO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_AUTORES (
    ID_AUTOR ID NOT NULL,
    TX_NOME TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_COLECOES (
    ID_COLECAO ID NOT NULL,
    TX_NOME TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    NR_PRAZO INTEGER,
    NR_EMPRESTIMOS INTEGER,
    CD_LIVRO CD_10,
    CD_PERIODICO CD_10,
    CD_ARTIGO CD_10,
    CD_DOCUMENTO CD_10,
    CD_MIDIA CD_10,
    TP_LIVRO TP_1,
    TP_PERIODICO TP_1,
    TP_ARTIGO TP_1,
    TP_MIDIA TP_1,
    TP_DOCUMENTO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_DOCUMENTOS (
    ID_PUBLICACAO ID NOT NULL,
    TP_SITUACAO TP_1,
    CD_REGISTRO CD_20,
    TX_CLASSIFICACAO TX_20,
    TX_TITULO TX_100,
    TL_TEXTO TL,
    TX_LOCALIZACAO TX_20,
    DT_CADASTRO DT,
    DT_REGISTRO DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_DOCUMENTOS_ASSUNTOS (
    ID_PUBLICACAO ID NOT NULL,
    ID_ASSUNTO ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_DOCUMENTOS_AUTORES (
    ID_PUBLICACAO ID NOT NULL,
    ID_AUTOR ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_DOCUMENTOS_IMAGENS (
    ID_PUBLICACAO ID NOT NULL,
    ID_IMAGEM ID NOT NULL,
    BL_IMAGEM BL,
    TX_DESCRICAO TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_EDITORAS (
    ID_EDITORA ID NOT NULL,
    TX_NOME TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_EMPRESTIMOS (
    ID_EMPRESTIMO ID NOT NULL,
    ID_PUBLICACAO ID,
    ID_CLIENTE ID,
    ID_FUNCIONARIO ID,
    DT_EMPRESTIMO DT,
    NR_PRAZO INTEGER,
    DT_DEVOLUCAO DT,
    TL_OBSERVACOES TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_LIVROS (
    ID_PUBLICACAO ID NOT NULL,
    TP_SITUACAO TP_1,
    TX_CLASSIFICACAO TX_20,
    CD_REGISTRO CD_20,
    DT_REGISTRO DT,
    DT_CADASTRO DT,
    TX_TITULO TX_100,
    NR_VOLUME INTEGER,
    NR_TOTAL_VOLUMES INTEGER,
    TX_PUBLICACAO_ANO TX_10,
    TP_ORIGEM TP_1,
    ID_EDITORA INTEGER,
    TX_EDICAO TX_20,
    NR_PAGINAS INTEGER,
    TP_ILUSTRADO TP_1,
    TL_OBSERVACOES TL,
    ID_COLECAO ID,
    ID_LOCAL ID,
    CD_ISBN CHAR(14) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_EAN CHAR(13) CHARACTER SET WIN1252 COLLATE WIN1252,
    TP_IMP_REGISTRO TP_1,
    TP_IMP_CLASSIFICACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_LIVROS_ASSUNTOS (
    ID_PUBLICACAO ID NOT NULL,
    ID_ASSUNTO ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_LIVROS_AUTORES (
    ID_PUBLICACAO ID NOT NULL,
    ID_AUTOR ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_LIVROS_IMAGENS (
    ID_PUBLICACAO ID NOT NULL,
    ID_IMAGEM ID NOT NULL,
    BL_IMAGEM BL,
    TX_DESCRICAO TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_LOCAIS (
    ID_LOCAL ID NOT NULL,
    TX_NOME TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_MIDIAS (
    ID_PUBLICACAO ID NOT NULL,
    TP_SITUACAO TP_1,
    TP_MIDIA TP_1,
    CD_REGISTRO CD_20,
    TX_CLASSIFICACAO TX_20,
    DT_CADASTRO DT,
    DT_REGISTRO DT,
    TP_ORIGEM TP_1,
    HR_TEMPO HR,
    TX_TITULO TX_100,
    ID_EDITORA ID,
    ID_LOCAL ID,
    ID_COLECAO ID,
    CD_ISBN CD_20,
    CD_EAN CD_20,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_MIDIAS_ASSUNTOS (
    ID_PUBLICACAO ID NOT NULL,
    ID_ASSUNTO ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_MIDIAS_AUTORES (
    ID_PUBLICACAO ID NOT NULL,
    ID_AUTOR ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_MIDIAS_CONTEUDO (
    ID_CONTEUDO ID NOT NULL,
    ID_PUBLICACAO ID,
    TX_TITULO TX_100,
    HR_TEMPO HR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_MIDIAS_IMAGENS (
    ID_PUBLICACAO ID NOT NULL,
    ID_IMAGEM ID NOT NULL,
    BL_IMAGEM BL,
    TX_DESCRICAO TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_PERIODICOS_ASSUNTOS (
    ID_PUBLICACAO ID NOT NULL,
    ID_ASSUNTO ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_PERIODICOS_AUTORES (
    ID_PUBLICACAO ID NOT NULL,
    ID_AUTOR ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_PERIODICOS_EDICOES (
    ID_PUBLICACAO ID NOT NULL,
    ID_PERIODICO ID,
    TP_SITUACAO TP_1,
    CD_REGISTRO CD_20,
    TX_CLASSIFICACAO TX_20,
    NR_EDICAO INTEGER,
    NR_ANO TX_10,
    NR_NUMERO INTEGER,
    TX_MES TX_10,
    DT_CADASTRO DT,
    TP_ORIGEM TP_1,
    CD_ISSN CHAR(14) CHARACTER SET WIN1252 COLLATE WIN1252,
    CD_EAN CHAR(13) CHARACTER SET WIN1252 COLLATE WIN1252,
    TP_IMP_REGISTRO TP_1,
    TP_IMP_CLASSIFICACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_PERIODICOS_IMAGENS (
    ID_PUBLICACAO ID NOT NULL,
    ID_IMAGEM ID NOT NULL,
    BL_IMAGEM BL,
    TX_DESCRICAO TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIB_PERIODICOS_TITULOS (
    ID_PERIODICO ID NOT NULL,
    TX_TITULO TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LIV_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    ID_FUNCAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LWR_ACOES (
    ID_ACAO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LWR_ADVOGADOS (
    ID_ADVOGADO ID NOT NULL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LWR_ANDAMENTO (
    ID_ANDAMENTO ID NOT NULL,
    ID_PROCESSO ID NOT NULL,
    DT_EVENTO DT NOT NULL,
    TL_DESCRICAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LWR_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    ID_FUNCAO_ADVOGADO ID,
    ID_FUNCAO_ESTAGIARIO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LWR_ESTAGIARIOS (
    ID_ESTAGIARIO ID NOT NULL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LWR_FASES (
    ID_FASE ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LWR_JUIZOS (
    ID_JUIZO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE LWR_PROCESSOS (
    ID_PROCESSO ID NOT NULL,
    TX_PROCESSO TX_60,
    TX_ARQUIVO TX_40,
    TX_TITULO TX_100,
    ID_CLIENTE INTEGER,
    TP_CLIENTE TP_1,
    TP_SITUACAO TP_1,
    ID_ADVOGADO ID,
    TX_ADVERSO TX_60,
    TX_ADVOGADO_ADVERSO TX_100,
    ID_JUIZO ID,
    ID_ACAO ID,
    VL_CAUSA VL,
    DT_INICIO DT,
    DT_TERMINO DT,
    ID_FASE ID,
    TX_PRAZO TX_100,
    DT_TERMO_INICIAL DT,
    DT_TERMO_FINAL DT,
    TL_DISCUSSAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE PDV_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL);


CREATE TABLE PDV_VENDA (
    ID_VENDA ID NOT NULL);


CREATE TABLE PDV_VENDA_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_VENDA ID);


CREATE TABLE QLT_IDENTIFICACOES (
    ID_IDENTIFICACAO ID NOT NULL,
    TX_FORMULARIO TX_60,
    TX_IDENTIFICACAO TX_20,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_ALUNOS_FREQUENCIA (
    ID_FREQUENCIA ID NOT NULL,
    ID_ALUNO ID,
    DT_REFERENCIA DT,
    TX_MES TX_20,
    TP_01 TP_1,
    TP_02 TP_1,
    TP_03 TP_1,
    TP_04 TP_1,
    TP_05 TP_1,
    TP_06 TP_1,
    TP_07 TP_1,
    TP_08 TP_1,
    TP_09 TP_1,
    TP_10 TP_1,
    TP_11 TP_1,
    TP_12 TP_1,
    TP_13 TP_1,
    TP_14 TP_1,
    TP_15 TP_1,
    TP_16 TP_1,
    TP_17 TP_1,
    TP_18 TP_1,
    TP_19 TP_1,
    TP_20 TP_1,
    TP_21 TP_1,
    TP_22 TP_1,
    TP_23 TP_1,
    TP_24 TP_1,
    TP_25 TP_1,
    TP_26 TP_1,
    TP_27 TP_1,
    TP_28 TP_1,
    TP_29 TP_1,
    TP_30 TP_1,
    TP_31 TP_1,
    NI_FALTAS NI);


CREATE TABLE SCH_ALUNOS_MATERIAL (
    ID_ITEM ID NOT NULL,
    ID_CONVENIO ID,
    ID_CLIENTE ID,
    DT_EMISSAO DT,
    TX_DESCRICAO TX_100,
    VL_MATERIAL VL,
    VL_FRETE VL,
    VL_TOTAL VL,
    ID_RECEBIMENTO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_ALUNOS_OCORRENCIAS (
    ID_OCORRENCIA ID NOT NULL,
    ID_ALUNO ID,
    CD_ALUNO CD_10,
    CD_SETOR TX_10,
    DT_OCORRENCIA DT,
    TX_OCORRENCIA TX_200,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_ALUNOS_TAXAS (
    ID_ITEM ID NOT NULL,
    ID_CONVENIO ID,
    ID_CLIENTE ID,
    DT_EMISSAO DT,
    TX_DESCRICAO TX_100,
    VL_TAXA VL,
    ID_RECEBIMENTO ID,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_AVALIACOES (
    ID_AVALIACAO ID NOT NULL,
    CD_AVALIACAO CD_10,
    DT_AVALIACAO DT,
    TP_AVALIACAO TP_1,
    TX_DESCRICAO TX_100,
    ID_CURSO ID,
    ID_NIVEL ID,
    ID_TURMA ID,
    NR_QUESTOES NI,
    TL_AVALIACAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_AVALIACOES_DISCIPLINAS (
    ID_ITEM ID NOT NULL,
    ID_DISCIPLINA ID,
    NR_SEQUENCIA NI,
    TP_DIFICULDADE TP_1,
    NR_QUANTIDADE NI,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT,
    ID_AVALIACAO ID);


CREATE TABLE SCH_AVALIACOES_QUESTOES (
    ID_ITEM ID NOT NULL,
    ID_CLIENTE ID,
    ID_AVALIACAO ID NOT NULL,
    NR_SEQUENCIA NI,
    ID_DISCIPLINA ID,
    TP_DIFICULDADE TP_1,
    ID_QUESTAO ID,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    NR_PESO_1 INTEGER,
    NR_PESO_2 INTEGER,
    NR_PESO_3 INTEGER,
    NR_PESO_4 INTEGER,
    TP_RECUPERACAO TP_1,
    TP_FREQUENCIA TP_1,
    TP_CARGAHORARIA TP_1,
    TP_MEDIA TP_1,
    NR_MEDIA NR,
    NR_FREQUENCIA NR,
    ID_FUNCAO_PROFESSOR ID,
    ID_CONTA_CREDITO ID,
    ID_CONTA_RECEITA ID,
    TX_OBSERVACOES_1 TX_60,
    TX_OBSERVACOES_2 TX_60,
    TX_OBSERVACOES_3 TX_60,
    TX_OBSERVACOES_4 TX_60,
    TX_OBSERVACOES_5 TX_60,
    TX_OBSERVACOES_6 TX_60,
    TX_NACIONALIDADE TX_60,
    TX_NATURALIDADE TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_CONVENIOS (
    ID_CONVENIO ID NOT NULL,
    ID_CLIENTE ID,
    TX_DESCRICAO TX_60,
    TL_CONTRATO TL,
    PR_DESCONTO PR,
    TP_COBRANCA TP_1,
    NR_DIA_VENCIMENTO NR,
    ID_FORMARECEBIMENTO ID,
    ID_CONTA_RECEITA ID,
    ID_TIPODOCUMENTO ID,
    ID_TIPORECEBIMENTO ID,
    ID_CONTA_CREDITO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_CURSOS (
    ID_CURSO ID NOT NULL,
    CD_CURSO CD_10,
    TX_DESCRICAO TX_60,
    NR_AVALIACOES NI,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_CURSOS_DISCIPLINAS (
    ID_DISCIPLINA ID NOT NULL,
    ID_NIVEL ID NOT NULL,
    NR_ORDEM NI,
    NR_CARGA_HORARIA NI,
    TP_ELETIVA TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_DIAS (
    ID_DIA ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_DISCIPLINAS (
    ID_DISCIPLINA ID NOT NULL,
    NR_ORDEM NI,
    CD_DISCIPLINA CD_10,
    TX_DESCRICAO TX_60,
    NR_CARGA_HORARIA NR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_DISCIPLINAS_TOPICOS (
    ID_TOPICO ID NOT NULL,
    ID_DISCIPLINA ID,
    TX_TITULO TX_60,
    TL_DESCRICAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_FREQUENCIAS (
    ID_ALUNO ID NOT NULL,
    DT_APONTAMENTO DT NOT NULL,
    HR_ENTRADA_1 HR,
    HR_SAIDA_1 HR,
    HR_ENTRADA_2 HR,
    HR_SAIDA_2 HR,
    HR_ENTRADA_3 HR,
    HR_SAIDA_3 HR,
    HR_ENTRADA_4 HR,
    HR_SAIDA_4 HR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    ID_ALUNO ID,
    TX_ANO TX_10,
    TX_INSTITUICAO TX_100,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CURSO TX_60,
    TX_NIVEL TX_60,
    NR_CARGA_HORARIA NI,
    NR_DIAS_LETIVOS NI,
    NR_FREQUENCIA NI,
    TP_RESULTADO TP_1,
    TP_SELECIONADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_HISTORICO_DISCIPLINAS (
    ID_ITEM ID NOT NULL,
    ID_HISTORICO ID NOT NULL,
    TX_DISCIPLINA TX_60,
    TX_CONCEITO TX_10,
    NR_MEDIA NR,
    NR_CARGA_HORARIA INTEGER,
    NR_ORDEM NI,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_LOCAIS (
    ID_LOCAL ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_MATRICULAS (
    ID_MATRICULA ID NOT NULL,
    ID_ALUNO ID,
    ID_PERIODO ID,
    ID_TURMA ID,
    ID_CURSO ID,
    ID_NIVEL ID,
    TP_SITUACAO TP_1,
    TP_RESULTADO TP_1,
    CD_CONTRATO CD_20,
    NR_PAUTA INTEGER,
    VL_MATRICULA VL,
    VL_MENSALIDADE_1 VL,
    VL_MENSALIDADE_2 VL,
    VL_MENSALIDADE_3 VL,
    VL_MENSALIDADE_4 VL,
    NR_MATRICULA INTEGER,
    NR_VENCIMENTO_1 INTEGER,
    NR_VENCIMENTO_2 INTEGER,
    NR_VENCIMENTO_3 INTEGER,
    NR_VENCIMENTO_4 INTEGER,
    PR_JUROS PR,
    VL_JUROS VL,
    PR_MULTA PR,
    VL_MULTA VL,
    PR_DESCONTO_FIXO PR,
    VL_DESCONTO_FIXO VL,
    PR_DESCONTO_DIA PR,
    VL_DESCONTO_DIA VL,
    ID_CENTROCUSTO ID,
    ID_FORMARECEBIMENTO ID,
    ID_TIPORECEBIMENTO ID,
    ID_CONTA_CREDITO ID,
    ID_TIPODOCUMENTO ID,
    DT_VENCIMENTO DT,
    NR_PARCELAS NR,
    TX_DESCRICAO TX_60,
    ID_CONTA_RECEITA ID,
    ID_CONVENIO ID,
    TP_COBRANCA TP_1,
    VL_COBRANCA VL,
    NR_CARGA_HORARIA NI,
    NR_FALTA_1 NI,
    NR_FALTA_2 NI,
    NR_FALTA_3 NI,
    NR_FALTA_4 NI,
    NR_FALTAS NI,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_MENSAGENS (
    ID_MENSAGEM ID NOT NULL,
    TX_MENSAGEM TX_100,
    TP_MES TP_2,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_NIVEIS (
    ID_NIVEL ID NOT NULL,
    ID_CURSO INTEGER NOT NULL,
    TX_DESCRICAO TX_60,
    NR_CARGA_HORARIA NI,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_PAUTA (
    ID_PAUTA ID NOT NULL,
    ID_MATRICULA ID,
    ID_DISCIPLINA ID,
    NR_NOTA_1 NR,
    NR_NOTA_2 NR,
    NR_NOTA_3 NUMERIC(15,3),
    NR_NOTA_4 NR,
    NR_REC_1 NR,
    NR_REC_2 NR,
    NR_REC_3 NR,
    NR_REC_4 NR,
    NR_FALTA_1 NI,
    NR_FALTA_2 NI,
    NR_FALTA_3 NI,
    NR_FALTA_4 NI,
    NR_FALTAS NI,
    NR_PRESENCAS NI,
    NR_TOTAL NR,
    NR_MEDIA NR,
    NR_COMPLEMENTO NR,
    NR_FREQUENCIA NR,
    NR_CARGA_HORARIA NI,
    TP_RESULTADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_PERGUNTAS_RESPOSTAS (
    ID_RESPOSTA ID NOT NULL,
    ID_QUESTAO ID,
    NR_RESPOSTA NI,
    TX_RESPOSTA TX_100,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_PERIODOS (
    ID_PERIODO ID NOT NULL,
    TX_REFERENCIA TX_10,
    TX_DESCRICAO TX_40,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_PROFESSORES (
    ID_PROFESSOR ID NOT NULL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_QUESTOES (
    ID_QUESTAO ID NOT NULL,
    CD_QUESTAO CD_10,
    ID_CURSO ID,
    ID_NIVEL ID,
    ID_DISCIPLINA ID,
    TX_DESCRICAO TX_100,
    TL_QUESTAO TL,
    TP_RESPOSTA TP_1,
    TP_DIFICULDADE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_SALAS (
    ID_SALA ID NOT NULL,
    CD_SALA CD_10,
    NR_MAXIMO_ALUNOS NR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_TAXAS (
    ID_TAXA ID NOT NULL,
    TX_DESCRICAO TX_100,
    VL_TAXA VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_TURMAS (
    ID_TURMA ID NOT NULL,
    ID_PERIODO ID,
    ID_CENTROCUSTO ID,
    TP_SITUACAO TP_1,
    CD_TURMA CD_10,
    ID_SALA ID,
    TX_DESCRICAO TX_60,
    ID_CURSO INTEGER,
    ID_NIVEL INTEGER,
    VL_MENSALIDADE VL,
    VL_DESCONTO VL,
    HR_INICIO HR,
    HR_TERMINO HR,
    DT_INICIO DT,
    DT_TERMINO DT,
    TP_TURNO TP_1,
    ID_PROFESSOR ID,
    ID_LOCAL ID,
    ID_DIA ID,
    ID_CONVENIO ID,
    NR_DIAS NI,
    NR_DURACAO INTEGER,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_TURMAS_CALENDARIOS (
    ID_CALENDARIO ID NOT NULL,
    ID_TURMA ID,
    DT_EVENTO DT,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_TURMAS_DISCIPLINAS (
    ID_TURMA ID NOT NULL,
    ID_DISCIPLINA ID NOT NULL,
    ID_PROFESSOR ID,
    NR_CARGA_HORARIA INTEGER,
    TP_ELETIVA TP_1,
    TP_PAUTA TP_1,
    TP_BOLETIM TP_1,
    ID_DISCIPLINA_BOLETIM ID,
    NR_PESO NI,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SCH_TURMAS_HORARIOS (
    ID_TURMA ID NOT NULL,
    TP_DIA TP_1 NOT NULL,
    HR_ENTRADA HR NOT NULL,
    HR_SAIDA HR,
    ID_DISCIPLINA ID NOT NULL,
    ID_PROFESSOR ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SHP_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    ID_ESTOQUE ID,
    TP_ORDENACAO_CONTACAO CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    TP_ORDENACAO_ CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SHP_CONSULTAS (
    ID_CONSULTA ID NOT NULL,
    CD_CONSULTA CD_10,
    DT_CONSULTA DT,
    ID_FORNECEDOR ID,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SHP_CONSULTAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_CONSULTA ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    TX_OBSERVACAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT,
    ID_PRODUTO ID);


CREATE TABLE SIS_ACESSOS (
    ID_ACESSO ID NOT NULL,
    ID_PARENT ID,
    CD_ACESSO TX_20,
    TP_DESCRICAO TP_1,
    TP_ACESSO TP_1,
    TP_SENHA TP_1,
    TX_DESCRICAO TX_100);


CREATE TABLE SIS_BACKUP (
    ID_BACKUP ID NOT NULL,
    HR_BACKUP_1 HR,
    HR_BACKUP_2 HR,
    HR_BACKUP_3 HR,
    HR_BACKUP_4 HR,
    TP_COMPACTAR TP_1,
    TX_SENHA TX_20,
    TX_DIR_HDD TX_200,
    TX_DIR_CDR TX_200,
    TX_DIR_PENDRIVE TX_200,
    TX_EMAIL_ANEXO TX_60,
    TX_EMAIL_AVISO TX_60,
    TX_FTP_DIRETORIO TX_200,
    TX_FTP_SERVIDOR TX_60,
    TX_FTP_PORTA TX_10,
    TX_FTP_USUARIO TX_40,
    TX_FTP_SENHA TX_40,
    NR_ARQUIVOS NI,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_BACKUP_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    DT_BACKUP DT,
    TX_DESCRICAO TX_100);


CREATE TABLE SIS_CODIGOS (
    TX_TABELA TX_60 NOT NULL,
    ID_CODIGO ID,
    ID_CODIGO_INICIAL ID,
    ID_CODIGO_FINAL ID,
    TP_EXPORTAR TP_1,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_CONFIG (
    ID_CONFIGURACAO ID NOT NULL,
    TP_MAIUSCULAS TP_1,
    TP_ACENTOS TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_EMPRESA (
    ID_EMPRESA INTEGER NOT NULL,
    TX_NOME TX_100,
    TX_FANTASIA TX_40,
    TX_ENDERECO TX_100,
    NR_NUMERO NI,
    TX_COMPLEMENTO TX_20,
    TX_BAIRRO TX_60,
    CD_CIDADE CD_10,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_TELEFONE TX_40,
    TX_EMAIL TX_60,
    TX_WEBSITE TX_60,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_20,
    TX_IM TX_20,
    BL_LOGOMARCA BL,
    TX_EMAIL_CONTA TX_40,
    TX_EMAIL_USUARIO TX_40,
    TX_EMAIL_SENHA TX_40,
    TX_EMAIL_SMTP TX_40,
    TX_EMAIL_SMTP_PORTA INTEGER,
    TX_EMAIL_POP TX_40,
    TX_EMAIL_POP_PORTA INTEGER,
    TL_EMAIL_ASSINATURA TL,
    TX_LOGOMARCA TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_GRUPOS (
    ID_GRUPO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_GRUPOS_ACESSOS (
    ID_GRUPO ID NOT NULL,
    ID_ACESSO ID NOT NULL,
    TP_ACESSO TP_1,
    TP_SENHA TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_IMPRESSORAS (
    ID_IMPRESSORA ID NOT NULL,
    TX_DESCRICAO TX_60,
    TX_PORTA TX_60,
    TP_PADRAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_INTERNET (
    ID_INTERNET ID NOT NULL,
    TP_PROXY TP_1,
    TX_PROXY_SERVIDOR TX_40,
    TX_PROXY_PORTA TX_10,
    TX_PROXY_USUARIO TX_40,
    TX_PROXY_SENHA TX_40,
    TX_EMAIL_CONTA TX_40,
    TX_EMAIL_USUARIO TX_40,
    TX_EMAIL_SENHA TX_40,
    TX_EMAIL_SMTP TX_60,
    TX_EMAIL_SMTP_PORTA TX_10,
    TX_EMAIL_POP TX_60,
    TX_EMAIL_POP_PORTA TX_10,
    TX_EMAIL_SSL TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_LICENCAS (
    ID_LICENCA ID NOT NULL,
    TX_MODULO TX_40,
    TX_COMPUTADOR TX_40,
    TX_REGISTRO TX_40,
    DT_REGISTRO DT,
    TX_DESCRICAO TX_40);


CREATE TABLE SIS_NUMERACAO (
    TX_TABELA TX_60 NOT NULL,
    TX_DESCRICAO TX_60,
    CD_NUMERACAO CD_10,
    TP_AUTOMATICO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_REGISTRO (
    ID_REGISTRO ID NOT NULL,
    TP_INICIALIZADO TP_1,
    TX_USUARIO TX_40,
    TX_SENHA TX_40,
    TX_LOCAL TX_40,
    TX_SERIE TX_40,
    DT_REGISTRO DT,
    TX_DESCRICAO TX_40);


CREATE TABLE SIS_RELATORIOS (
    ID_RELATORIO ID NOT NULL,
    CD_RELATORIO TX_100,
    TX_RELATORIO TX_100,
    TP_RELATORIO TP_1,
    TL_RELATORIO BLOB SUB_TYPE 0 SEGMENT SIZE 80,
    TP_PADRAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_USUARIOS (
    ID_USUARIO ID NOT NULL,
    TP_USUARIO TP_1,
    TX_NOME TX_60,
    ID_FUNCIONARIO ID,
    TX_DESCRICAO TX_100,
    TX_USUARIO TX_20,
    TX_SENHA TX_20,
    TX_SENHA2 TX_20,
    ID_GRUPO ID,
    TP_DESATIVADA TP_1,
    TP_BLOQUEADA TP_1,
    TP_ALTERAR_LOGON TP_1,
    TP_ALTERAR_SENHA TP_1,
    TP_VALIDADE TP_1,
    TP_AVISO_BACKUP TP_1,
    TP_AVISO_ATUALIZACAO TP_1,
    TP_CENTROSCUSTO TP_1,
    DT_SENHA DT,
    TX_EMAIL_NOME TX_60,
    TX_EMAIL_CONTA TX_60,
    TX_EMAIL_COPIA TX_60,
    TX_EMAIL_USUARIO TX_40,
    TX_EMAIL_SENHA TX_40,
    TX_EMAIL_POP TX_60,
    TX_EMAIL_POP_PORTA TX_10,
    TX_EMAIL_SMTP TX_60,
    TX_EMAIL_SMTP_PORTA TX_10,
    TP_EMAIL_SSL TP_1,
    TL_EMAIL_ASSINATURA TL,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_USUARIOS_ACESSOS (
    ID_ITEM ID NOT NULL,
    ID_USUARIO INTEGER,
    TX_COMPUTADOR TX_40,
    TX_MODULO TX_40,
    TX_FORMULARIO TX_40,
    TX_HISTORICO TX_255,
    DT_ENTRADA DT,
    DT_SAIDA DT);


CREATE TABLE SIS_USUARIOS_CENTROSCUSTO (
    ID_USUARIO ID NOT NULL,
    ID_CENTROCUSTO ID NOT NULL,
    TP_ACESSAR TP_1,
    TP_VISUALIZAR TP_1,
    TP_INSERIR TP_1,
    TP_MODIFICAR TP_1,
    TP_RELATORIOS TP_1);


CREATE TABLE SIS_USUARIOS_EMAIL (
    ID_EMAIL ID NOT NULL,
    DT_ENVIO DT,
    TX_ENDERECO TX_100,
    TL_MENSAGEM TL,
    ID_USUARIO INTEGER,
    DT_ATUALIZACAO DT);


CREATE TABLE SIS_VERSAO (
    CD_VERSAO CD_10 NOT NULL,
	CD_ANTERIOR CD_10,
	CD_ATUALIZAR CD_10);


CREATE TABLE SRV_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    TP_APLICACAO TP_1,
    TP_ESTOQUE TP_1,
    TP_FATURAMENTO TP_1,
    PR_ISS PR,
    PR_INSS PR,
    PR_IRPJ PR,
    PR_FEDERAIS PR,
    ID_FUNCAO_OPERADOR ID,
    ID_FUNCAO_ATENDENTE ID,
    ID_CONTA_VENDA ID,
    ID_CONTA_SERVICOS ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_CONTRATOS (
    ID_CONTRATO ID NOT NULL,
    CD_CONTRATO CD_10,
    TX_DESCRICAO TX_100,
    ID_CLIENTE ID,
    ID_VENDEDOR ID,
    DT_CONTRATO DT,
    DT_INICIO DT,
    DT_TERMINO DT,
    DT_VENCIMENTO DT,
    NR_MESES NI,
    TP_SITUACAO TP_1,
    VL_TOTAL VL,
    VL_MENSAL VL,
    ID_CENTROCUSTO ID,
    ID_FORMARECEBIMENTO ID,
    ID_PRAZORECEBIMENTO ID,
    ID_CONTA_CREDITO ID,
    ID_CONTA_RECEITA ID,
    ID_TIPODOCUMENTO ID,
    TL_CONTRATO TL,
    TL_OBSERVACOES TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_CONTRATOS_SERVICOS (
    ID_ITEM ID NOT NULL,
    ID_CONTRATO ID,
    NR_QUANTIDADE NR,
    ID_SERVICO ID,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_EQUIPAMENTOS (
    ID_EQUIPAMENTO ID NOT NULL,
    ID_PRODUTO CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    ID_CLIENTE ID,
    TX_DESCRICAO TX_100,
    CD_SERIE CD_20,
    DT_COMPRA DT,
    DT_GARANTIA DT,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_NATUREZA (
    ID_NATUREZA ID NOT NULL,
    TX_CODIGO CD_10,
    TX_DESCRICAO TX_100,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_NOTAS (
    ID_NOTA ID NOT NULL,
    CD_NOTA CD_10,
    DT_EMISSAO DT,
    TP_SITUACAO TP_1,
    ID_CLIENTE ID,
    ID_SERIE ID,
    ID_ORDEMSERVICO ID,
    ID_CENTROCUSTO ID,
    ID_CONTA_RECEITA ID,
    ID_TIPODOCUMENTO ID,
    ID_NATUREZA ID,
    TP_TABELA TP_1,
    VL_SERVICOS VL,
    PR_SERVICOS_DESCONTO PR,
    VL_SERVICOS_DESCONTO VL,
    VL_SERVICOS_TOTAL VL,
    VL_PRODUTOS VL,
    PR_PRODUTOS_DESCONTO PR,
    VL_PRODUTOS_DESCONTO VL,
    VL_PRODUTOS_TOTAL VL,
    VL_TOTAL VL,
    VL_RETENCOES VL,
    VL_NOTA VL,
    DT_APURACAO DT,
    PR_ISS PR,
    VL_ISS VL,
    TP_ISS_RETIDO TP_1,
    PR_IRRF PR,
    VL_IRRF VL,
    TP_IRRF_RETIDO TP_1,
    DT_IRRF DT,
    PR_INSS PR,
    VL_INSS VL,
    TP_INSS_RETIDO TP_1,
    PR_INSS_BASE PR,
    VL_INSS_DEDUCAO VL,
    PR_FEDERAIS PR,
    VL_FEDERAIS VL,
    TP_FEDERAIS_RETIDO TP_1,
    TX_FEDERAIS_LEI TX_20,
    TL_DESCRICAO TL,
    TL_OBSERVACOES TL,
    TL_MENSAGEM TL,
    ID_VENDEDOR ID,
    ID_COMISSAO ID,
    VL_COMISSAO VL,
    ID_PRAZORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    ID_CONTA_CREDITO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_NOTAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_NOTA ID,
    ID_PRODUTO ID,
    TX_DESCRICAO TX_100,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    VL_TOTAL VL,
    ID_ORDEMSERVICO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_NOTAS_SERVICOS (
    ID_ITEM ID NOT NULL,
    ID_NOTA ID,
    ID_SERVICO ID,
    TX_DESCRICAO TX_200,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    VL_TOTAL VL,
    ID_ORDEMSERVICO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_ORCAMENTOS (
    ID_ORCAMENTO ID NOT NULL,
    CD_ORCAMENTO CD_10,
    TP_SITUACAO TP_1,
    ID_CENTROCUSTO ID,
    ID_CLIENTE ID,
    DT_ORCAMENTO DT,
    NR_PRAZO INTEGER,
    NR_VALIDADE INTEGER,
    ID_VENDEDOR ID,
    DT_ENTREGA DT,
    TL_DESCRICAO TL,
    ID_PRODUTO ID,
    NR_QUANTIDADE INTEGER,
    VL_SERVICOS VL,
    PR_SERVICOS_DESCONTO PR,
    VL_SERVICOS_DESCONTO VL,
    VL_SERVICOS_TOTAL VL,
    VL_PRODUTOS VL,
    VL_PRODUTOS_DESCONTO VL,
    PR_PRODUTOS_DESCONTO PR,
    VL_PRODUTOS_TOTAL VL,
    VL_TOTAL VL,
    ID_PRAZORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    TL_OBSERVACOES TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_ORCAMENTOS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_PRODUTO ID,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_ORCAMENTOS_SERVICOS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_SERVICO ID,
    TX_DESCRICAO TX_200,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_ORDENS (
    ID_ORDEMSERVICO ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_CENTROCUSTO ID,
    ID_EQUIPAMENTO ID,
    ID_VEICULO ID,
    ID_TIPOORDEM ID,
    ID_CLIENTE ID,
    ID_ESTOQUE ID,
    TP_ATENDIMENTO TP_1,
    CD_ORDEMSERVICO CD_10,
    TP_SITUACAO TP_1,
    TP_SITUACAO_PRODUTOS TP_1,
    TP_SITUACAO_SERVICOS TP_1,
    TP_TABELA TP_1,
    DT_EMISSAO DT,
    DT_ENTRADA DT,
    NR_PRAZO INTEGER,
    DT_ENTREGA DT,
    DT_INICIO DT,
    DT_TERMINO DT,
    DT_RETIRADA DT,
    DT_AGENDAMENTO DT,
    HR_AGENDAMENTO HR,
    DT_VISITA DT,
    HR_CHEGADA HR,
    HR_SAIDA HR,
    CD_SERIE CD_20,
    TP_GARANTIA TP_1,
    NR_GARANTIA INTEGER,
    DT_GARANTIA DT,
    TL_DESCRICAO TL,
    TL_SERVICOS TL,
    TL_OBSERVACOES TL,
    NR_QUANTIDADE NR,
    VL_SERVICOS VL,
    PR_SERVICOS_DESCONTO PR,
    VL_SERVICOS_DESCONTO VL,
    VL_SERVICOS_TOTAL VL,
    VL_PRODUTOS VL,
    PR_PRODUTOS_DESCONTO PR,
    VL_PRODUTOS_DESCONTO VL,
    VL_PRODUTOS_TOTAL VL,
    VL_TOTAL VL,
    ID_CFOP ID,
    ID_PRAZORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    ID_ATENDENTE ID,
    ID_VENDEDOR ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_ORDENS_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    ID_ORDEMSERVICO ID,
    DT_HISTORICO DT,
    TX_DESCRICAO TX_100,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_ORDENS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_ORDEMSERVICO ID,
    ID_PRODUTO ID,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    VL_TOTAL VL,
    ID_VENDA ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_ORDENS_SERVICOS (
    ID_ITEM ID NOT NULL,
    ID_ORDEMSERVICO ID,
    ID_SERVICO ID,
    TX_DESCRICAO TX_200,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    VL_TOTAL VL,
    ID_TECNICO ID,
    DT_SERVICO DT,
    HR_INICIO HR,
    HR_TERMINO HR,
    ID_NOTA ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_SERIES (
    ID_SERIE ID NOT NULL,
    CD_SERIE CD_10,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_SERVICOS (
    ID_SERVICO ID NOT NULL,
    CD_SERVICO CD_10,
    TX_DESCRICAO TX_60,
    VL_SERVICO VL,
    TX_UNIDADE TX_UNIDADE,
    NR_GARANTIA INTEGER,
    PR_ISS PR,
    TP_SITUACAO TP_1,
    TP_PADRAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_TECNICOS (
    ID_TECNICO ID NOT NULL,
    ID_FUNCIONARIO ID,
    TP_TECNICO TP_1,
    TX_NOME TX_100,
    PR_COMISSAO PR,
    VL_COMISSAO VL,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_TIPOSORDENS (
    ID_TIPOORDEM ID NOT NULL,
    TX_DESCRICAO TX_60,
    PR_COMISSAO PR,
    TP_SITUACAO TP_1,
    TP_PADRAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_VEICULOS (
    ID_VEICULO ID NOT NULL,
    ID_CLIENTE ID,
    TP_PROPRIETARIO TP_1,
    TP_CLIENTE TP_1,
    TX_NOME TX_60,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_IE,
    TX_CPF TX_CPF,
    TX_CI TX_CI,
    TX_TELEFONE TX_60,
    TX_CELULAR TX_60,
    TX_PLACA TX_10,
    TX_MODELO TX_60,
    TX_ANO TX_10,
    TX_CHASSIS TX_40,
    TX_COR TX_40,
    TX_RENAVAM TX_60,
    TX_COMBUSTIVEL TX_60,
    TX_BICOMBUSTIVEL TX_60,
    TX_LOTACAO TX_40,
    TX_KM TX_20,
    TX_CATEGORIA TX_60,
    TX_ESPECIE TX_60,
    TX_TARA TX_40,
    TX_PBT TX_40,
    TX_POTENCIA TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE SRV_VENDEDORES (
    ID_VENDEDOR ID NOT NULL,
    TX_NOME TX_60,
    PR_COMISSAO PR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STK_CONFIGURACAO (
    ID_CONFIGURACAO ID NOT NULL,
    TP_ENTRADAS TP_1,
    TP_SAIDAS TP_1,
    TP_TRANSFERENCIAS TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STK_MOVIMENTO (
    ID_ITEM ID NOT NULL,
    DT_MOVIMENTO DT,
    NR_SEQUENCIA NI,
    TP_MOVIMENTO TP_1,
    CD_DOCUMENTO CD_20,
    TX_DESCRICAO TX_100,
    CD_LOTE CD_20,
    NR_QUANTIDADE NR,
    NR_ENTREGUE NR,
    NR_RESERVADO NR,
    NR_ESTOQUE NR);


CREATE TABLE STR_ACABAMENTOS (
    ID_ACABAMENTO ID NOT NULL,
    TX_DESCRICAO TX_40,
    PR_CALCULO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ALIQUOTAS (
    ID_ALIQUOTA ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ALIQUOTAS_CFOP (
    ID_ITEM ID NOT NULL,
    ID_ALIQUOTA ID,
    TX_ESTADO TX_ESTADO,
    CD_CFOP CD_10,
    CD_TRIBUTARIO_REVENDA CD_10,
    CD_TRIBUTARIO_CONSUMIDOR CD_10,
    PR_ICMS_REVENDA PR,
    PR_ICMS_CONSUMIDOR PR,
    PR_ICMS_COMPRA PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_CFOP (
    ID_CFOP ID NOT NULL,
    CD_CFOP CD_20,
    TX_TITULO TX_100,
    TL_DESCRICAO TL,
    TP_NF TP_1,
    TP_ICMS TP_1,
    TP_IPI TP_1,
    TP_VENDA TP_1,
    TP_COMISSAO TP_1,
    TP_IMPORTACAO TP_1,
    TP_EXPORTACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);

CREATE TABLE STR_MOTORISTAS (
    ID_MOTORISTA ID NOT NULL,
    TX_NOME TX_40,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);

CREATE TABLE STR_APLICACOES (
    ID_APLICACAO ID NOT NULL,
    TX_DESCRICAO TX_40,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT
);

CREATE TABLE STR_CLASSES (
    ID_CLASSE ID NOT NULL,
    CD_CLASSE CD_10,
    TX_DESCRICAO TX_40,
    TP_SITE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);

CREATE TABLE STR_CLIENTES_CLASSES (
    ID_ITEM ID NOT NULL,
    ID_CLIENTE ID,
    PR_DESCONTO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_CLIENTES_MOVIMENTO (
    ID_ITEM ID NOT NULL,
    ID_CLIENTE ID,
    DT_VENDA DT,
    VL_VENDA VL,
    NR_QUANTIDADE NR,
    TX_VENDEDOR TX_60,
    TX_FORMA TX_60,
    TX_PRAZO TX_60,
    TX_PONTOVENDA TX_60,
    TX_RECEBIMENTOS TX_100,
    TX_OBSERVACOES TX_255,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_CLIENTES_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_CLIENTE ID,
    ID_PRODUTO ID,
    VL_VENDA VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_COMISSOES (
    ID_COMISSAO ID NOT NULL,
    TX_DESCRICAO TX_40,
    PR_COMISSAO_A PR,
    PR_COMISSAO_B PR,
    PR_COMISSAO_C PR,
    PR_COMISSAO_D PR,
    PR_COMISSAO_E PR,
    PR_COMISSAO_F PR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_COMPRAS (
    ID_COMPRA ID NOT NULL,
    CD_COMPRA CD_10,
    TP_COMPRA TP_1,
    ID_ORDEMCOMPRA ID,
    ID_CFOP ID,
    CD_DOCUMENTO CD_10,
    DT_COMPRA DT,
    DT_LANCAMENTO DT,
    TP_SITUACAO TP_1,
    ID_CENTROCUSTO ID,
    ID_ESTOQUE ID,
    ID_CONTA_DESPESA ID,
    ID_FORNECEDOR ID,
    TX_CONTATO TX_40,
    ID_TIPODOCUMENTO ID,
    VL_BASE_CALCULO VL,
    VL_ICMS VL,
    VL_BASE_SUBSTITUICAO VL,
    VL_ICMS_SUBSTITUICAO VL,
    VL_IPI PR,
    VL_SUBTOTAL VL,
    PR_DESCONTO PR,
    VL_DESCONTO VL,
    VL_TOTAL VL,
    ID_TRANSPORTADORA ID,
    VL_FRETE VL,
    TP_FRETE TP_1,
    VL_SEGURO VL,
    TP_RATEIO TP_1,
    NR_PESO_BRUTO NR,
    NR_PESO_LIQUIDO NR,
    TP_TRANSPORTE TP_1,
    ID_PRAZOPAGAMENTO ID,
    ID_FORMAPAGAMENTO ID,
    TL_OBSERVACOES TL,
    TP_ATUALIZACAO TP_1,
    TP_EXPORTADO TP_1,
    DT_EXPORTACAO DT,
    TP_SELECIONADO TP_1,
    TP_IPI TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_COMPRAS_ORDENSCOMPRA (
    ID_COMPRA ID NOT NULL,
    ID_ORDEMCOMPRA ID NOT NULL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_COMPRAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_COMPRA ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    NR_CONTAGEM NR,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    PR_ICMS PR,
    PR_IPI PR,
    VL_TOTAL VL,
    NR_PESO NR,
    CD_LOTE CD_20,
    CD_SERIE CD_20,
    CD_CFOP CD_10,
    CD_CLASSIFICACAO_FISCAL CD_20,
    CD_SITUACAO_TRIBUTARIA CD_10,
    ID_ORDEMCOMPRA ID,
    ID_ORDEMCOMPRA_ITEM ID,
	ID_APLICACAO ID,
	TX_OBSERVACAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_CONFIGURACAO (
    ID_CONFIGURACAO INTEGER NOT NULL,
    TX_TABELA_A TX_40,
    TX_TABELA_B TX_40,
    TX_TABELA_C TX_40,
    TX_TABELA_D TX_40,
    TX_TABELA_E TX_40,
    TX_TABELA_F TX_40,
    ID_FORMA_LIMITE ID,
    ID_FUNCAO_VENDEDOR ID,
    ID_ESTOQUE_PEDIDO ID,
    ID_ESTOQUE_VENDA ID,
    ID_ESTOQUE_COMPRA ID,
    ID_COMISSAO ID,
    ID_CENTROCUSTO ID,
    ID_TIPODOCUMENTO ID,
    TP_TABELA TP_1,
    ID_CONTA_CREDITO ID,
    ID_CONTA_RECEITA ID,
    TP_CALCULO_PRECO TP_1,
    TP_ARREDONDAMENTO TP_1,
    NR_LINHAS_PEDIDO INTEGER,
    NR_LINHAS_VENDA INTEGER,
    TP_ESTOQUE_PERGUNTA TP_1,
    TP_ESTOQUE_NEGATIVO TP_1,
    TP_ESTOQUE_ZERADO TP_1,
    TP_LOTE_PERGUNTA TP_1,
    TP_LOTE_NEGATIVO TP_1,
    TP_LOTE_ZERADO TP_1,
    TP_COMPRAS_LOTE TP_1,
    TP_VENDAS_SIMPLES TP_1,
    TP_VENDAS_COMPLETA TP_1,
    TP_VENDAS_LOTE TP_1,
    TP_ORDEM_PRODUTOS TP_1,
    TP_FILTRO_PRODUTOS TP_1,
    ID_CONTA_DEBITO ID,
    TX_PORTA_MATRICIAL TX_10,
    NR_LINHAS_CORTE NI,
    PR_IPI_VENDA PR,
    NR_CRIPTOGRAFIA NI,
    TP_APLICACAO TP_1,
    TP_PEDIDOS_RECEBIMENTOS TP_1,
    TP_VENDAS_RECEBIMENTOS TP_1,
    TP_MOVIMENTO TP_1,
    TP_PEDIDOS_AGRUPAR TP_1,
    TP_VENDAS_AGRUPAR TP_1,
    TX_NFE_CERTIFICADO TX_60,
    TX_NFE_ESTADO TX_ESTADO,
    TP_NFE_AMBIENTE TP_1,
    TX_NFE_MENSAGEM_1 TX_255,
    TX_NFE_MENSAGEM_2 TX_255,
    TP_NFE_SIMPLES TP_1,
    TP_NFE_ISENTO TP_1,
    TP_NFE_TABELA TP_1,
    TP_NFE_CRT TP_1,
    TP_NFE_TRIBUTOS TP_1,
    CD_NFE_ORIGEM CD_10,
    NR_NFE_TRIBUTOS NR,
    CD_CSOSN CD_10,
    CD_IPI CD_10,
    CD_PIS CD_10,
    CD_COFINS CD_10,
    PR_ICMS_CREDITO PR,
    PR_ICMS_VENDA PR,
    TP_PEDIDOS_HISTORICO TP_1,
    TX_ESPECIE TX_10,
    NR_QUANTIDADE_VOLUME NI,
    NR_DIGITOS_LOTE NI,
    TP_NUMERO_BOLETOS TP_1,
    TP_MULTI_EMPRESA TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_CONVENIOS (
    ID_CONVENIO ID NOT NULL,
    TX_DESCRICAO TX_60,
    ID_FORMARECEBIMENTO ID,
    ID_PRAZORECEBIMENTO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_CORES (
    ID_COR ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_COTACOES (
    ID_COTACAO ID NOT NULL,
    TP_COTACAO TP_1,
    ID_REQUISICAO ID,
    ID_CENTROCUSTO ID,
    ID_ESTOQUE ID,
    CD_COTACAO CD_10,
    DT_COTACAO DT,
    NR_PRAZO INTEGER,
    DT_ENTREGA DT,
    TP_SITUACAO TP_1,
    ID_FORNECEDOR ID,
    TX_CONTATO TX_40,
    VL_IPI VL,
    VL_SUBTOTAL VL,
    PR_DESCONTO PR,
    VL_DESCONTO VL,
    ID_TRANSPORTADORA ID,
    VL_FRETE VL,
    TP_FRETE TP_1,
    VL_TOTAL VL,
    TP_TRANSPORTE TP_1,
    ID_PRAZOPAGAMENTO ID,
    ID_FORMAPAGAMENTO ID,
    TL_OBSERVACOES TL,
    TP_SELECIONADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_COTACOES_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_COTACAO ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    PR_IPI PR,
    VL_TOTAL VL,
    TP_SITUACAO TP_1,
    TP_APROVADO TP_1,
    NR_COMPRADO NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_DEVOLUCOES (
    ID_DEVOLUCAO ID NOT NULL,
    CD_DEVOLUCAO CD_10,
    TP_SITUACAO TP_1,
    DT_DEVOLUCAO DT,
    ID_CLIENTE ID,
    ID_VENDA ID,
    ID_ESTOQUE ID,
    ID_CONTA_RECEITA ID,
    ID_TIPODOCUMENTO ID,
    TP_TABELA TP_1,
    VL_SUBTOTAL VL,
    PR_DESCONTO PR,
    VL_DESCONTO VL,
    VL_TOTAL VL,
    VL_SALDO VL,
    ID_COMISSAO ID,
    ID_VENDEDOR ID,
    VL_COMISSAO VL,
    TL_OBSERVACOES TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_DEVOLUCOES_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_DEVOLUCAO ID,
    ID_PRODUTO ID,
    NR_COMPRIMENTO NR,
    NR_LARGURA NR,
    NR_ALTURA NR,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    PR_COMISSAO PR,
    VL_TOTAL VL,
    CD_LOTE CD_20,
    CD_SERIE CD_20,
    TP_ESTOQUE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ENTRADAS (
    ID_ENTRADA ID NOT NULL,
    CD_ENTRADA CD_10,
    DT_ENTRADA DT,
    TP_SITUACAO TP_1,
    ID_ESTOQUE ID,
    ID_CENTROCUSTO ID,
    ID_HISTORICO ID,
    TP_TABELA TP_1,
    ID_CONTA_RECEITA ID,
    TL_OBSERVACOES TL,
    NR_ITENS NI,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ENTRADAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_ENTRADA ID,
    ID_PRODUTO ID,
    NR_COMPRIMENTO NR,
    NR_LARGURA NR,
    NR_ALTURA NR,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_CUSTO VL,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    CD_LOTE CD_20,
    CD_SERIE CD_20,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ESTOQUES (
    ID_ESTOQUE ID NOT NULL,
    TX_DESCRICAO TX_40,
    ID_CENTROCUSTO ID,
    TP_SITUACAO TP_1,
    TP_PADRAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_FABRICANTES (
    ID_FABRICANTE ID NOT NULL,
    CD_FABRICANTE CD_10,
    TX_NOME TX_40,
    PR_REPRESENTANTE PR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT,
    TX_ENDERECO CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    TX_BAIRRO CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    TX_CIDADE CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    TX_ESTADO CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    TX_CEP CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252);


CREATE TABLE STR_GRADES (
    ID_GRADE ID NOT NULL,
    CD_TAMANHO_01 CD_10,
    CD_TAMANHO_02 CD_10,
    CD_TAMANHO_03 CD_10,
    CD_TAMANHO_04 CD_10,
    CD_TAMANHO_05 CD_10,
    CD_TAMANHO_06 CD_10,
    CD_TAMANHO_07 CD_10,
    CD_TAMANHO_08 CD_10,
    CD_TAMANHO_09 CD_10,
    CD_TAMANHO_10 CD_10,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_GRUPOS (
    ID_GRUPO ID NOT NULL,
    ID_CLASSE ID,
    CD_GRUPO CD_10,
    TX_DESCRICAO TX_40,
    TP_SITE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_HISTORICO (
    ID_HISTORICO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ICMS (
    ID_ICMS ID NOT NULL,
    TX_ESTADO TX_ESTADO,
    PR_ICMS PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_INDICACOES (
    ID_INDICACAO ID NOT NULL,
    TX_NOME TX_60,
    PR_COMISSAO PR,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_TELEFONE TX_20,
    TX_CELULAR TX_20,
    ID_CENTROCUSTO ID,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_INVENTARIO (
    ID_INVENTARIO ID NOT NULL,
    CD_INVENTARIO CD_10,
    ID_CENTROCUSTO ID,
    ID_ESTOQUE ID,
    DT_INVENTARIO DT,
    DT_LANCAMENTO DT,
    DT_CONCILIACAO DT,
    DT_PROCESSAMENTO DT,
    NR_CONTAGEM NR,
    NR_ESTOQUE NR,
    NR_DIFERENCA NR,
    VL_CONTAGEM VL,
    VL_ESTOQUE VL,
    VL_DIFERENCA VL,
    TP_INVENTARIO TP_1 COLLATE WIN1252,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_INVENTARIO_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_INVENTARIO ID NOT NULL,
    ID_PRODUTO ID,
    NR_CONTAGEM NR,
    NR_ESTOQUE NR,
    NR_DIFERENCA NR,
    VL_CUSTO VL,
    VL_VENDA VL,
    VL_UNITARIO VL,
    VL_CONTAGEM VL,
    VL_ESTOQUE VL,
    VL_DIFERENCA VL,
    TX_UNIDADE TX_UNIDADE,
    CD_LOTE CD_20,
    TX_OBSERVACAO TX_60,
    TP_ESTOQUE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_LOJAS (
    ID_LOJA ID NOT NULL,
    TP_SITUACAO TP_1,
    ID_CENTROCUSTO ID,
    CD_LOJA CD_10,
    TX_DESCRICAO TX_60,
    TX_ENDERECO TX_60,
    TX_BARRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_TELEFONES TX_40,
    TX_GERENTE TX_60,
    TX_EMAIL TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_OBSERVACOES (
    ID_OBSERVACAO ID NOT NULL,
    TL_OBSERVACAO TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ORCAMENTOS (
    ID_ORCAMENTO ID NOT NULL,
    TP_SITUACAO TP_1 DEFAULT 'N',
    ID_CENTROCUSTO ID,
    CD_ORCAMENTO CD_10,
    CD_SOLICITACAO_CLIENTE CD_20,
    DT_ORCAMENTO DT,
    ID_CLIENTE INTEGER,
    ID_VENDEDOR ID,
    ID_DIVISAO ID,
    TX_CONTATO TX_40,
    TP_TABELA TP_1,
    TP_PRODUTOS TP_1,
    ID_COMISSAO ID,
    VL_SUBTOTAL VL,
    PR_DESCONTO PR,
    VL_DESCONTO VL,
    PR_ADICIONAL PR,
    VL_ADICIONAL VL,
    VL_IPI VL,
    VL_TOTAL VL,
    VL_FRETE VL,
    TP_FRETE TP_1,
    TP_TRANSPORTE TP_1,
    NR_VALIDADE INTEGER,
    NR_PRAZO INTEGER,
    ID_PRAZORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    ID_TRANSPORTADORA ID,
    TL_OBSERVACOES TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ORCAMENTOS_COMPONENTES (
    ID_ITEM_COMPONENTE ID NOT NULL,
    ID_ITEM ID,
    ID_COMPONENTE ID,
    NR_ITEM NI,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    CD_LOTE CD_20,
    TP_ESTOQUE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ORCAMENTOS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_ORCAMENTO ID,
    ID_PRODUTO ID,
    TX_DESCRICAO TX_60,
    ID_APLICACAO ID,
    ID_ACABAMENTO ID,
    TX_COMPLEMENTO TX_20,
    NR_COMPRIMENTO NR,
    NR_LARGURA NR,
    NR_ALTURA NR,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    VL_SUBTOTAL VL,
    PR_IPI PR,
    VL_IPI VL,
    PR_DESCONTO PR,
    PR_ACRESCIMO PR,
    PR_APLICACAO PR,
    PR_ACABAMENTO PR,
    VL_TOTAL VL,
    TP_PERDA TP_1,
    PR_PERDA_COMPRIMENTO PR,
    NR_PERDA_LARGURA NR,
    TP_APROVADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ORDENSCOMPRA (
    ID_ORDEMCOMPRA ID NOT NULL,
    TP_ORDEMCOMPRA TP_1,
    ID_COTACAO ID,
    ID_REQUISICAO ID,
    CD_ORDEMCOMPRA CD_10,
    DT_ORDEMCOMPRA DT,
    NR_PRAZO INTEGER,
    DT_ENTREGA DT,
    TX_HORARIO TX_40,
    TP_SITUACAO TP_1,
    ID_CENTROCUSTO ID,
    ID_ESTOQUE ID,
    ID_CONTA_DESPESA ID,
    ID_FORNECEDOR ID,
    TX_CONTATO TX_40,
    ID_TIPODOCUMENTO ID,
    VL_IPI VL,
    VL_SUBTOTAL VL,
    PR_DESCONTO PR,
    VL_DESCONTO VL,
    VL_TOTAL VL,
    ID_TRANSPORTADORA ID,
    VL_FRETE VL,
    TP_FRETE TP_1,
    TP_TRANSPORTE TP_1,
    ID_PRAZOPAGAMENTO ID,
    ID_FORMAPAGAMENTO ID,
    TL_OBSERVACOES TL,
    TP_CARGA TP_1,
    TP_DESCARGA TP_1,
    TP_SELECIONADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ORDENSCOMPRA_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_ORDEMCOMPRA ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    NR_ENTREGUE NR,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    PR_IPI PR,
    VL_TOTAL VL,
    NR_PESO NR,
    TP_ESTOQUE TP_1,
    ID_COMPRA ID,
	ID_APLICACAO ID,
	TX_OBSERVACAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PEDIDOS (
    ID_PEDIDO ID NOT NULL,
    CD_PEDIDO CD_10,
    ID_ORCAMENTO ID,
    ID_FABRICANTE ID,
    TP_SITUACAO TP_1 DEFAULT 'A',
    TP_SEPARACAO TP_1,
    DT_PEDIDO DT,
    ID_CFOP ID,
    TP_PRODUTOS TP_1,
    NR_PRAZO INTEGER,
    DT_ENTREGA DT,
    ID_CENTROCUSTO ID,
    ID_CLIENTE ID,
    ID_DIVISAO ID,
    ID_VENDEDOR ID,
    TX_CONTATO TX_40,
    CD_PEDIDO_CLIENTE CD_20,
    ID_ESTOQUE ID,
    ID_TIPODOCUMENTO ID,
    ID_CONTA_RECEITA ID,
    TP_TABELA TP_1,
    ID_COMISSAO ID,
    VL_SUBTOTAL VL,
    PR_DESCONTO PR,
    VL_DESCONTO VL,
    PR_ADICIONAL PR,
    VL_ADICIONAL VL,
    NR_QUANTIDADE NR,
    NR_ITENS NI,
    VL_IPI VL,
    VL_TOTAL VL,
    ID_TRANSPORTADORA ID,
    VL_FRETE VL,
    TP_FRETE TP_1,
    TP_TRANSPORTE TP_1,
    TL_OBSERVACOES TL,
    TL_ALTERACOES TL,
    ID_PRAZORECEBIMENTO ID,
    ID_FORMARECEBIMENTO ID,
    PR_REPRESENTANTE PR,
    NR_VOLUMES NI,
    TX_ESPECIE TX_40,
    NR_PESO_BRUTO NR,
    NR_PESO_LIQUIDO NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PEDIDOS_COMPONENTES (
    ID_ITEM_COMPONENTE ID NOT NULL,
    ID_ITEM ID NOT NULL,
    ID_COMPONENTE ID NOT NULL,
    NR_ITEM ID,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    CD_LOTE CD_20,
    TP_ESTOQUE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PEDIDOS_HISTORICO (
    ID_ITEM ID NOT NULL,
    ID_PEDIDO ID);


CREATE TABLE STR_PEDIDOS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_PEDIDO ID,
    ID_PRODUTO ID,
    TX_DESCRICAO TX_60,
    ID_APLICACAO ID,
    ID_ACABAMENTO ID,
    TX_COMPLEMENTO TX_20,
    NR_COMPRIMENTO NR,
    NR_LARGURA NR,
    NR_ALTURA NR,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    NR_ENTREGUE NR,
    VL_UNITARIO VL,
    VL_SUBTOTAL VL,
    PR_IPI PR,
    VL_IPI VL,
    PR_DESCONTO PR,
    PR_ACRESCIMO PR,
    PR_APLICACAO PR,
    PR_ACABAMENTO PR,
    VL_TOTAL VL,
    NR_PESO NR,
    CD_LOTE CD_20,
    CD_SERIE CD_20,
    TP_PERDA TP_1,
    PR_PERDA_COMPRIMENTO PR,
    NR_PERDA_LARGURA NR,
    ID_VENDA ID,
    ID_ALTERACAO ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PONTOSVENDA (
    ID_PONTOVENDA ID NOT NULL,
    TX_NOME TX_60,
    ID_CENTROCUSTO ID,
    TP_AUTENTICACAO TP_1,
    TP_CONTROLE TP_1,
    TP_CONTROLE_RECEBIMENTO TP_1,
    TP_GERENTE TP_1,
    TP_VENDEDOR TP_1,
    TP_VENDEDOR_PRODUTO TP_1,
    TP_TABELA TP_1,
    TP_CLIENTE TP_1,
    ID_CLIENTE ID,
    ID_ESTOQUE ID,
    ID_COMISSAO ID,
    TP_ACRESCIMO TP_1,
    TP_ACRESCIMO_PRODUTO TP_1,
    TP_DESCONTO TP_1,
    TP_DESCONTO_PRODUTO TP_1,
    TP_DESCONTO_BLOQUEADO TP_1,
    TP_TABELA_PADRAO TP_1,
    TP_QUANTIDADE TP_1,
    TP_VALOR TP_1,
    TP_VENDA_INICIO TP_1 COLLATE WIN1252,
    TP_VENDA_BALCAO TP_1,
    TP_IMPRESSAO_BALCAO TP_1,
    TP_PORTA_BALCAO TP_1,
    TX_NOME_IMPRESSORA TX_100,
    TP_GAVETA_BALCAO TP_1,
    NR_LINHAS_CORTE NI,
    TP_CORTE_BALCAO TP_1,
    TP_VENDA_CUPOM TP_1,
    TP_IMPRESSAO_CUPOM TP_1,
    TP_MODELO_CUPOM TP_1,
    TP_PORTA_CUPOM NI,
    TP_GAVETA_CUPOM TP_1,
    TP_CORTE_CUPOM TP_1,
    ID_CONTA_CREDITO ID,
    ID_CONTA_RECEITA ID,
    TP_FORMULARIO TP_1,
    TP_TROCAS TP_1,
    TP_PENDENTE TP_1,
    TP_CREDITO TP_1,
    TP_VALE TP_1,
    TP_SENHA_DESCONTO TP_1,
    TP_LEITOR TP_1,
    TP_PEDIDO TP_1,
    TP_ORDEM_PRODUTOS TP_1,
    TP_ORDEM_CLIENTES TP_1,
    TP_EXPORTAR TP_1,
    TP_IMPORTAR TP_1,
    TP_CREDIARIO TP_1,
    TX_CRIPTOGRAFIA TX_20,
    TX_CABECALHO TX_255,
    TX_RODAPE TX_255,
    TX_MENSAGEM_ECF TX_100,
    TP_IMPRIME_ASSINATURA TP_1,
    TP_IMPRIME_CLIENTE TP_1,
    TP_ITENS TP_1,
    TP_CODIGO_CLIENTE TP_1,
    CD_CLIENTE CD_10,
    TP_CODIGO_VENDA TP_1,
    CD_VENDA CD_10,
    ID_CODIGO_INICIAL ID,
    ID_CODIGO_FINAL ID,
    TP_CAIXA TP_1,
    DT_CAIXA DT,
    VL_SALDO_INICIAL VL,
    VL_DESPESAS VL,
    VL_SALDO_FINAL VL,
    ID_FORMA_CREDIARIO ID,
    TP_ESTOQUE TP_1,
    TP_INVENTARIO TP_1,
    TP_TRANSFERENCIAS TP_1,
    TP_PRECOS TP_1,
    TP_CONFIGURACAO TP_1,
    TP_INICIAR_VENDA TP_1,
    NR_VIAS NI,
    ID_GERENTE ID,
    ID_VENDEDOR ID,
    TP_TABELA_A TP_1,
    TP_TABELA_B TP_1,
    TP_TABELA_C TP_1,
    TP_TABELA_D TP_1,
    TP_TABELA_E TP_1,
    TP_TABELA_F TP_1,
    TP_DIGITACAO TP_1,
    TP_LEITURA TP_1,
    DT_EXPORTACAO DT,
    DT_IMPORTACAO DT,
    ID_SERIE_CUPOM ID,
    ID_SERIE_BALCAO ID,
    TP_INTEGRACAO TP_1 COLLATE WIN1252,
    TX_EMAIL_CONTA TX_60,
    TX_EMAIL_USUARIO TX_40,
    TX_EMAIL_SENHA TX_40,
    TX_EMAIL_POP TX_40,
    TX_EMAIL_POP_PORTA INTEGER,
    TX_EMAIL_SMTP TX_40,
    TX_EMAIL_SMTP_PORTA INTEGER,
    TX_EMAIL_DESTINO TX_60,
    TX_DIR_REDE TX_100,
    ID_FORMA_LIMITE ID,
    NR_VALIDADE_VALE NR,
    TX_BANCO TX_100,
    TX_USUARIO TX_40,
    TX_SENHA TX_40,
    TX_SERIE TX_40,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PONTOSVENDA_CAIXAS (
    ID_CAIXA ID NOT NULL,
    ID_PONTOVENDA ID,
    DT_CAIXA DT,
    DT_LEITURA DT,
    VL_CAIXA CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    VL_TROCO VL,
    TP_CONFERIDO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS (
    ID_PRODUTO ID NOT NULL,
    TP_PRODUTO TP_1,
    TP_CLASSIFICACAO TP_1,
    CD_PRODUTO CD_20,
    CD_PRODUTO_FABRICANTE CD_20,
    CD_EAN CD_20,
    TP_SITUACAO TP_1,
    TX_DESCRICAO TX_100,
    TX_DESCRICAO_INGLES TX_100,
    TX_DESCRICAO_ESPANHOL TX_100,
    TX_DESCRICAO_REDUZIDA TX_40,
    TL_DESCRICAO_COMPLETA TL,
    TX_LOCALIZACAO TX_60,
    ID_CLASSE ID,
    ID_GRUPO ID,
    ID_TIPO ID,
    ID_FABRICANTE ID,
    TP_CONSIGNADO TP_1,
    ID_CONSIGNATARIO ID,
    DT_COMPRA DT,
    VL_COMPRA VL,
    VL_FRETE VL,
    VL_OUTROS VL,
    VL_SUBSTITUICAO_TRIBUTARIA VL,
    PR_DIFERENCA_ICMS PR,
    VL_DIFERENCA_ICMS VL,
    PR_COMISSAO PR,
    VL_COMISSAO DT,
    PR_ICMS_COMPRA PR,
    VL_ICMS_COMPRA VL,
    TP_ICMS_VENDA TP_1,
    PR_ICMS_VENDA PR,
    VL_ICMS_VENDA VL,
    PR_IPI_COMPRA PR,
    VL_IPI_COMPRA VL,
    PR_IPI_VENDA PR,
    VL_IPI VL,
    VL_DESCONTO VL,
    DT_DESCONTO DT,
    DT_PROMOCAO DT,
    VL_PROMOCAO VL,
    TP_TABELA TP_1,
    TP_CALCULO TP_2,
    TP_PRECO TP_1,
    VL_CUSTO VL,
    DT_CUSTO DT,
    VL_MAIOR_CUSTO VL,
    DT_MAIOR_CUSTO DT,
    VL_MENOR_CUSTO VL,
    DT_MENOR_CUSTO DT,
    PR_DESCONTO_CUSTO PR,
    VL_DESCONTO_CUSTO VL,
    PR_FINANCEIRO_CUSTO PR,
    VL_FINANCEIRO_CUSTO VL,
    VL_VENDA_A VL,
    VL_VENDA_B VL,
    VL_VENDA_C VL,
    VL_VENDA_D VL,
    VL_VENDA_E VL,
    VL_VENDA_F VL,
    PR_MARGEM_A PR,
    PR_MARGEM_B PR,
    PR_MARGEM_C PR,
    PR_MARGEM_D PR,
    PR_MARGEM_E PR,
    PR_MARGEM_F PR,
    ID_ALIQUOTA ID,
    TP_ICMS_ISENTO TP_1,
    TX_UNIDADE_ESTOQUE TX_UNIDADE,
    TX_UNIDADE_EMBALAGEM TX_UNIDADE,
    NR_QUANTIDADE_EMBALAGEM NR,
    NR_FATOR_COMPRA NR,
    TX_UNIDADE_COMPRA TX_UNIDADE,
    TP_FATOR_COMPRA TP_1,
    NR_FATOR_FABRICACAO NR,
    TX_UNIDADE_FABRICACAO TX_UNIDADE,
    TP_FATOR_FABRICACAO TP_1,
    NR_PESO_BRUTO NR,
    NR_PESO_LIQUIDO NR,
    NR_LARGURA NR,
    NR_ALTURA NR,
    NR_COMPRIMENTO NR,
    NR_DECIMAIS NI,
    TX_TAMANHO TX_10,
    TP_IMPRIMIR TP_1,
    NR_ETIQUETAS INTEGER,
    PR_LUCRO_SUBSTITUICAO PR,
    CD_CLASSIFICACAO_FISCAL CD_20,
    CD_CLASSIFICACAO_EXPORTACAO CD_20,
    CD_CEST CD_20,
    CD_CSOSN CD_10,
    CD_CST CD_10,
    CD_SITUACAO_TRIBUTARIA CD_10,
    CD_MINISTERIO_SAUDE CD_20,
    TX_CONTEUDO TX_40,
    NR_VALIDADE INTEGER,
    TP_LOTE TP_1,
    CD_LOTE CD_20,
    TP_VALIDADE TP_1,
    TP_VENDAS TP_1,
    TP_COMPRAS TP_1,
    ID_CONTA_DESPESA ID,
    TP_SERIE TP_1,
    TP_GARANTIA TP_1,
    NR_GARANTIA INTEGER,
    TP_COMPONENTES TP_1,
    TP_ESTOQUE TP_1,
    TX_NORMA_TECNICA TX_20,
    DT_CADASTRO DT,
    TP_SITE TP_1,
    TP_VITRINE TP_1,
    CD_MODELO CD_20,
    ID_MODELO ID,
    ID_GRADE ID,
    ID_COR ID,
    ID_TAMANHO ID,
    TP_BALANCA TP_1,
    CD_ATALHO CD_10,
    TP_FABRICACAO TP_1,
    NR_FABRICACAO_QUANTIDADE NR,
    VL_FABRICACAO_PRODUTOS VL,
    VL_FABRICACAO_SERVICOS VL,
    VL_FABRICACAO_CUSTO VL,
    VL_FABRICACAO_MEDIO VL,
    VL_FABRICACAO_MINIMO VL,
    VL_FABRICACAO_MAXIMO VL,
    VL_FABRICACAO_UNITARIO VL,
    TX_PROCESSO_VERSAO TX_10,
    PR_PERDA_COMPRIMENTO PR,
    NR_PERDA_LARGURA NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_APLICACOES (
    ID_APLICACAO ID NOT NULL,
    ID_PRODUTO ID,
    TX_DESCRICAO TX_40,
    VL_VENDA VL,
    PR_CALCULO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_COMPONENTES (
    ID_ITEM ID NOT NULL,
    ID_COMPONENTE ID,
    ID_PRODUTO ID,
    NR_ITEM INTEGER,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    TP_APAGAR TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_COMPRAS (
    ID_ITEM ID NOT NULL,
    ID_PRODUTO ID);


CREATE TABLE STR_PRODUTOS_EAN (
    ID_ITEM ID NOT NULL,
    ID_PRODUTO ID,
    CD_EAN CD_20,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_ESTOQUES (
    ID_ITEM ID NOT NULL,
    ID_ESTOQUE ID NOT NULL,
    ID_PRODUTO ID NOT NULL,
    TX_ENDERECAMENTO TX_20,
    NR_ESTOQUE_MAXIMO NR,
    NR_ESTOQUE_PEDIDO NR,
    NR_ESTOQUE_MINIMO NR,
    TP_REGULADOR TP_1,
    TP_PROMOCAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_FORMATOS (
    ID_FORMATO ID NOT NULL,
    ID_PRODUTO ID,
    TX_DESCRICAO TX_60,
    NR_QUANTIDADE NI,
    NR_LARGURA NR,
    NR_COMPRIMENTO NR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_FORNECEDORES (
    ID_PRODUTO ID NOT NULL,
    ID_FORNECEDOR ID NOT NULL,
    CD_PRODUTO_FORNECEDOR CD_20,
    DT_COMPRA DT,
    VL_COMPRA VL,
    VL_FRETE VL,
    PR_ICMS PR,
    VL_ICMS VL,
    PR_IPI PR,
    VL_IPI VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_FOTOS (
    ID_FOTO ID NOT NULL,
    ID_PRODUTO ID,
    TP_PRINCIPAL TP_1,
    TP_SITE TP_1,
    NR_SEQUENCIA NI,
    TX_DESCRICAO TX_60,
    TX_IMAGEM TX_60,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_LOTES (
    ID_LOTE ID NOT NULL,
    ID_PRODUTO ID,
    CD_LOTE CD_20,
    DT_FABRICACAO DT,
    DT_ENTRADA DT,
    TX_VALIDADE TX_20,
    NR_TOTAL_FABRICADO NR,
    NR_ESTOQUE_ATUAL NR,
    NR_ESTOQUE_RESERVADO NR,
    TP_IMPRIMIR TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_PRECOS (
    ID_PRECO ID NOT NULL,
    ID_PRODUTO ID,
    NR_MINIMO NR,
    NR_MAXIMO NR,
    PR_MARGEM_A PR,
    PR_MARGEM_B PR,
    PR_MARGEM_C PR,
    PR_MARGEM_D PR,
    PR_MARGEM_E PR,
    PR_MARGEM_F PR,
    VL_VENDA_A VL,
    VL_VENDA_B VL,
    VL_VENDA_C VL,
    VL_VENDA_D VL,
    VL_VENDA_E VL,
    VL_VENDA_F VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_REAJUSTES (
    ID_ITEM ID NOT NULL,
    ID_PRODUTO ID,
    DT_REAJUSTE CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252,
    PR_REAJUSTE CHAR(18) CHARACTER SET WIN1252 COLLATE WIN1252);


CREATE TABLE STR_PRODUTOS_RELACIONADOS (
    ID_ITEM ID NOT NULL,
    ID_PRODUTO ID,
    ID_PRODUTO_RELACIONADO ID);


CREATE TABLE STR_PRODUTOS_SERIES (
    ID_SERIE ID NOT NULL,
    ID_PRODUTO ID,
    ID_LOTE ID,
    CD_SERIE CD_20,
    ID_COMPRA ID,
    ID_VENDA ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_PRODUTOS_SIMILARES (
    ID_ITEM ID NOT NULL,
    ID_PRODUTO ID,
    ID_PRODUTO_SIMILAR ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_REQUISICOES (
    ID_REQUISICAO ID NOT NULL,
    TP_REQUISICAO TP_1,
    ID_CENTROCUSTO ID,
    ID_ESTOQUE ID,
    CD_REQUISICAO CD_10,
    CD_DOCUMENTO CD_10,
    TP_SITUACAO TP_1,
    DT_REQUISICAO DT,
    NR_PRAZO INTEGER,
    DT_ENTREGA DT,
    TL_OBSERVACAO TL,
    TL_OBSERVACOES TL,
    TX_SOLICITANTE TX_100,
    TX_APLICACAO TX_100,
    TP_SELECIONADO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_REQUISICOES_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_REQUISICAO ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    NR_COMPRADO NR,
	ID_APLICACAO ID,
    TX_OBSERVACAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_RETORNO (
    ID_RETORNO ID NOT NULL,
    DT_RETORNO DT,
    CD_RETORNO CD_10,
    ID_COMPRA ID,
    ID_FORNECEDOR ID,
    ID_ESTOQUE ID,
    ID_CONTA_DESPESA ID,
    ID_TIPODOCUMENTO ID,
    CD_DOCUMENTO CD_10,
    VL_SUBTOTAL VL,
    PR_DESCONTO PR,
    VL_DESCONTO VL,
    VL_TOTAL VL,
    TP_SITUACAO TP_1,
    TL_OBSERVACOES TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_RETORNO_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_RETORNO ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_ROTAS (
    ID_ROTA ID NOT NULL,
    TX_DESCRICAO TX_60,
    PR_PAGAMENTO PR,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_SAIDAS (
    ID_SAIDA ID NOT NULL,
    CD_SAIDA CD_10,
    DT_SAIDA DT,
    TP_SITUACAO TP_1,
    ID_ESTOQUE ID,
    ID_CENTROCUSTO ID,
    ID_CONTA_DESPESA ID,
    ID_HISTORICO ID,
    TP_TABELA TP_1,
    TX_RNC TX_20,
    TL_OBSERVACOES TL,
    NR_ITENS NI,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_SAIDAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_SAIDA ID,
    ID_PRODUTO ID,
    NR_COMPRIMENTO NR,
    NR_LARGURA NR,
    NR_ALTURA NR,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_CUSTO VL,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    CD_LOTE CD_20,
    CD_SERIE CD_20,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_SERIES (
    ID_SERIE ID NOT NULL,
    CD_SERIE CD_10,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_20,
    TX_FANTASIA TX_40,
    TX_TELEFONE TX_40,
    TX_CEP TX_CEP,
    TX_ENDERECO TX_100,
    NR_NUMERO NI,
    TX_COMPLEMENTO TX_20,
    TX_BAIRRO TX_60,
    CD_CIDADE CD_10,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TP_NFE TP_1,
    TX_NFE_CERTIFICADO TX_60,
    TP_NFE_AMBIENTE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_TABELAS (
    ID_TABELA ID NOT NULL,
    ID_CLIENTE ID,
    DT_TABELA DT,
    TX_DESCRICAO TX_60,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_TABELAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_TABELA ID,
    ID_PRODUTO ID,
    VL_UNITARIO VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_TIPOS (
    ID_TIPO ID NOT NULL,
    TX_DESCRICAO TX_60,
    TP_VENDA TP_1,
    TP_COMPRA TP_1,
    TP_SERVICO TP_1,
    TP_FABRICACAO TP_1,
    TP_COMPONENTE TP_1,
    TP_IMOBILIZADO TP_1,
    TP_SITUACAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_TRANSFERENCIAS (
    ID_TRANSFERENCIA ID NOT NULL,
    CD_TRANSFERENCIA CD_10,
    TP_SITUACAO TP_1,
    DT_TRANSFERENCIA DT,
    ID_HISTORICO ID,
    TP_TABELA TP_1,
    ID_CENTROCUSTO_SAIDA ID,
    ID_CENTROCUSTO_ENTRADA ID,
    ID_ESTOQUE_SAIDA ID,
    ID_ESTOQUE_ENTRADA ID,
    DT_ENTRADA DT,
    TL_OBSERVACOES TL,
    NR_ITENS NI,
    VL_TOTAL VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_TRANSFERENCIAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_TRANSFERENCIA ID,
    ID_PRODUTO ID,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_CUSTO VL,
    VL_UNITARIO VL,
    VL_TOTAL VL,
    CD_LOTE CD_20,
    TP_ESTOQUE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_TRANSPORTADORAS (
    ID_TRANSPORTADORA ID NOT NULL,
    CD_TRANSPORTADORA CD_10,
    TP_SITUACAO TP_1,
    TP_TRANSPORTADORA TP_1,
    TX_NOME TX_60,
    TX_FANTASIA TX_60,
    TX_ENDERECO TX_60,
    TX_BAIRRO TX_60,
    TX_CIDADE TX_60,
    TX_ESTADO TX_ESTADO,
    TX_CEP TX_CEP,
    TX_TELEFONES TX_40,
    TX_EMAIL TX_40,
    TX_SITE TX_40,
    TX_CNPJ TX_CNPJ,
    TX_IE TX_IE,
    TX_CPF TX_CPF,
    TX_CI TX_CI,
    TX_PLACA CD_PLACA,
    TX_PLACA_ESTADO TX_ESTADO,
    TX_ANTT TX_10,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_TRANSPORTADORAS_CONTATOS (
    ID_CONTATO ID NOT NULL,
    ID_TRANSPORTADORA ID,
    TX_NOME TX_60,
    TX_SETOR TX_40,
    TX_COMERCIAL TX_40,
    TX_CELULAR TX_40,
    TX_EMAIL TX_40,
    DT_NASCIMENTO DT,
    TP_IMPRESSAO TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_UNIDADES (
    ID_UNIDADE ID NOT NULL,
    TX_UNIDADE TX_UNIDADE,
    NR_DECIMAIS NI,
    TX_DESCRICAO TX_40,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_VENDAS (
    ID_VENDA ID NOT NULL,
    TP_VENDA TP_1,
    ID_SERIE ID,
    ID_PONTOVENDA ID,
    ID_FABRICANTE ID,
    TP_PRODUTOS TP_1,
    TP_NOTA TP_1,
    CD_VENDA CD_10,
    CD_CUPOM CD_10,
    CD_PEDIDO_CLIENTE CD_20,
    ID_CFOP ID,
    ID_PEDIDO ID,
    ID_ORDEMSERVICO ID,
    ID_RETORNO ID,
    ID_DIVISAO ID,
    ID_DEVOLUCAO ID,
    VL_DEVOLUCAO VL,
    TP_SITUACAO TP_1,
    DT_VENDA DT,
    DT_CAIXA DT,
    DT_ENTREGA DT,
    NR_ENTREGA NI,
    ID_CENTROCUSTO ID,
    ID_CLIENTE ID,
    TX_CONTATO TX_40,
    ID_CONTA_RECEITA ID,
    ID_TIPODOCUMENTO ID,
    TP_TABELA TP_1,
    ID_ESTOQUE ID,
    ID_VENDEDOR ID,
    VL_IPI VL,
    VL_SUBTOTAL VL,
    PR_DESCONTO PL,
    VL_DESCONTO VL,
    PR_ADICIONAL PL,
    VL_ADICIONAL VL,
    VL_BASE_CALCULO VL,
    PR_ICMS PR,
    VL_ICMS VL,
    PR_ICMS_SUBSTITUICAO PR,
    VL_ICMS_SUBSTITUICAO VL,
    PR_ICMS_CREDITO PR,
    VL_ICMS_CREDITO VL,
    VL_BC_II VL,
    VL_II VL,
    VL_PIS VL,
    VL_COFINS VL,
    VL_OUTROS VL,
    VL_TOTAL VL,
    VL_VALE VL,
    VL_VENDA VL,
    VL_RECEBIDO VL,
    VL_TROCO VL,
    ID_COMISSAO ID,
    VL_COMISSAO VL,
    ID_TRANSPORTADORA ID,
    VL_FRETE VL,
    TP_FRETE TP_1,
    TP_TRANSPORTE TP_1,
    VL_SEGURO VL,
    VL_DESPESAS VL,
    TX_ESPECIE TX_40,
    NR_VOLUMES NI,
    NR_PESO_BRUTO NR,
    NR_PESO_LIQUIDO NR,
    TL_OBSERVACOES TL,
    TL_MENSAGEM TL,
    ID_FORMARECEBIMENTO ID,
    ID_PRAZORECEBIMENTO ID,
    ID_CONTA_CREDITO ID,
    TP_IMPRESSAO_ETIQUETA TP_1,
    TP_IMPRESSAO_MINUTA TP_1,
    ID_CONVENIO ID,
    ID_GERENTE ID,
    ID_AUTORIZACAO ID,
    ID_INDICACAO ID,
    NR_QUANTIDADE NR,
    NR_ITENS NI,
    NR_DEVOLUCOES NI,
    PR_REPRESENTANTE PR,
    TX_PEDIDOS TX_100,
    TX_ORDENS TX_100,
    DT_SAIDA DT,
    HR_SAIDA HR,
    ID_ROTA ID,
    CD_NFCE CD_10,
    CD_NFE_PROTOCOLO TX_40,
    CD_NFE_CANCELAMENTO TX_40,
    CD_NFE_RECIBO TX_40,
    CD_NFE_CHAVE TX_60,
    TP_NFE_XML TP_1,
    TP_MOVIMENTO TP_1,
    TX_PLACA CD_PLACA,
    TP_EXPORTACAO TP_1,
    TX_DI TX_20,
    DT_DI DT,
    TX_EXPORTADOR TX_20,
    TX_DES_LOCAL TX_60,
    TX_DES_UF TX_ESTADO,
    DT_DESEMBARACO DT,
	ID_MOTORISTA ID,
    VL_ICMS_ST_BC VL,
    VL_ICMS_ST VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_VENDAS_COMPONENTES (
    ID_ITEM_COMPONENTE ID NOT NULL,
    ID_ITEM ID NOT NULL,
    ID_COMPONENTE ID NOT NULL,
    NR_ITEM INTEGER,
    NR_QUANTIDADE NR,
    TX_UNIDADE TX_UNIDADE,
    CD_LOTE CD_20,
    TP_ESTOQUE TP_1,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_VENDAS_PRODUTOS (
    ID_ITEM ID NOT NULL,
    ID_VENDA ID,
    TP_PRODUTO TP_1,
    ID_PRODUTO ID,
    TX_DESCRICAO TX_60,
    ID_APLICACAO ID,
    ID_ACABAMENTO ID,
    TX_COMPLEMENTO TX_20,
    NR_COMPRIMENTO NR,
    NR_LARGURA NR,
    NR_ALTURA NR,
    TX_UNIDADE TX_UNIDADE,
    NR_QUANTIDADE NR,
    VL_UNITARIO VL,
    PR_DESCONTO PR,
    VL_UNITARIO_DESCONTO VL,
    VL_DESCONTO VL,
    VL_SUBTOTAL VL,
    PR_ACRESCIMO PR,
    PR_APLICACAO PR,
    PR_ACABAMENTO PR,
    CD_CRT CD_10,
    PR_ICMS PR,
    VL_ICMS_BC VL,
    VL_ICMS VL,
    PR_ICMS_ST PR,
    CD_CFOP CD_10,
    CD_NCM CD_10,
    CD_ORIGEM CD_10,
    CD_CST CD_10,
    CD_CSOSN CD_10,

    CD_IPI_CST CD_10,
    CD_IPI_CLENQ CD_10,
    CD_IPI_CENQ CD_10,
    TX_IPI_CNPJ_PRODUTOR TX_CNPJ,
    PR_IPI PR,
    VL_IPI_BC VL,
    NR_IPI_QUANTIDADE NR,
    VL_IPI_UNIDADE VL,
    TP_IPI_CALCULO TP_1,
    VL_IPI VL,


    CD_PIS_CST CD_10,
    TP_PIS_CALCULO TP_1,
    VL_PIS_BC VL,
    PR_PIS PR,
    NR_PIS_QUANTIDADE NR,
    VL_PIS_UNIDADE VL,

    CD_COFINS_CST CD_10,
    TP_COFINS_CALCULO TP_1,
    VL_COFINS_BC VL,
    PR_COFINS PR,
    NR_COFINS_QUANTIDADE NR,
    VL_COFINS_UNIDADE VL,

    PR_ICMS_ST_REDUCAO PR,
    PR_ICMS_ST_MARGEM PR,
    VL_BASE_CALCULO_SUB VL,
    VL_ICMS_ST VL,

    VL_TOTAL VL,
    VL_VENDA VL,
    NR_PESO NR,
    ID_VENDEDOR ID,
    PR_COMISSAO PR,
    CD_LOTE CD_20,
    CD_SERIE CD_20,
    CD_SITUACAO_TRIBUTARIA CD_10,
    ID_PEDIDO ID,
    ID_PEDIDO_ITEM ID,
    ID_ORDEMSERVICO ID,
    ID_ORDEMFABRICACAO ID,
    NR_ADICAO NI,
    NR_SEQUENCIAL NI,
    TX_FABRICANTE TX_60,
    VL_FRETE VL,
    VL_DESCONTO_DI VL,
    NR_QUANTIDADE_LIQ NR,
    VL_TOTAL_LIQ VL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_VENDEDORES (
    ID_VENDEDOR ID NOT NULL,
    CD_VENDEDOR CD_10,
    TP_VENDEDOR TP_1,
    ID_FUNCIONARIO ID,
    TX_NOME TX_60,
    PR_COMISSAO PR,
    TP_COMISSAO TP_1,
    PR_DESCONTO PR,
    TP_SITUACAO TP_1,
    TX_AUTORIZACAO TX_10,
    PR_AUTORIZACAO PR,
    TP_PDV TP_1,
    TL_OBSERVACOES TL,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_VENDEDORES_FABRICANTES (
    ID_ITEM ID NOT NULL,
    ID_VENDEDOR ID,
    ID_FABRICANTE ID,
    PR_COMISSAO PR,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);


CREATE TABLE STR_VENDEDORES_PDV (
    ID_ITEM ID NOT NULL,
    ID_VENDEDOR ID,
    ID_PONTOVENDA ID,
    ID_USUARIO ID,
    DT_ATUALIZACAO DT);




/******************************************************************************/
/***                              Primary keys                              ***/
/******************************************************************************/


ALTER TABLE BLD_CONFIGURACAO ADD CONSTRAINT XPKBLD_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE BLD_OBRAS ADD CONSTRAINT XPKBLD_OBRAS PRIMARY KEY (ID_OBRA);
ALTER TABLE BLD_OBRAS_ART ADD CONSTRAINT XPKBLD_OBRAS_ART PRIMARY KEY (ID_ART);
ALTER TABLE BLD_TIPOSOBRAS ADD CONSTRAINT XPKBLD_TIPOSOBRAS PRIMARY KEY (ID_TIPOOBRA);
ALTER TABLE CAB_AJUSTES ADD CONSTRAINT XPKCAB_AJUSTES PRIMARY KEY (ID_AJUSTE);
ALTER TABLE CAB_AREAS ADD CONSTRAINT XPKCAB_AREAS PRIMARY KEY (ID_AREA);
ALTER TABLE CAB_ATENDENTES ADD CONSTRAINT XPKCAB_ATENDENTES PRIMARY KEY (ID_ATENDENTE);
ALTER TABLE CAB_ATENDIMENTOS ADD CONSTRAINT XPKCAB_ATENDIMENTOS PRIMARY KEY (ID_ATENDIMENTO);
ALTER TABLE CAB_CAIXAS ADD CONSTRAINT XPKCAB_CAIXAS PRIMARY KEY (ID_CAIXA);
ALTER TABLE CAB_CANCELAMENTOS ADD CONSTRAINT XPKCAB_CANCELAMENTOS PRIMARY KEY (ID_CANCELAMENTO);
ALTER TABLE CAB_COMENTARIOS ADD CONSTRAINT XPKCAB_COMENTARIOS PRIMARY KEY (ID_COMENTARIO);
ALTER TABLE CAB_CONDOMINIOS ADD CONSTRAINT XPKCAB_CONDOMINIOS PRIMARY KEY (ID_CONDOMINIO);
ALTER TABLE CAB_CONFIGURACAO ADD CONSTRAINT XPKCAB_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE CAB_CONTRATOS ADD CONSTRAINT XPKCAB_CONTRATOS PRIMARY KEY (ID_CONTRATO);
ALTER TABLE CAB_CONTRATOS_REAJUSTES ADD CONSTRAINT XPKCAB_CONTRATOS_REAJUSTES PRIMARY KEY (ID_ITEM);
ALTER TABLE CAB_CONTRATOS_SEQUENCIAS ADD CONSTRAINT XPKCAB_CONTRATOS_SEQUENCIAS PRIMARY KEY (ID_SEQUENCIA);
ALTER TABLE CAB_GRUPOS ADD CONSTRAINT XPKCAB_GRUPOS PRIMARY KEY (ID_GRUPO);
ALTER TABLE CAB_HISTORICO ADD CONSTRAINT XPKCAB_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE CAB_INTERRUPCOES ADD CONSTRAINT XPKCAB_INTERRUPCOES PRIMARY KEY (ID_INTERRUPCAO);
ALTER TABLE CAB_MODEMS ADD CONSTRAINT XPKCAB_MODEMS PRIMARY KEY (ID_MODEM);
ALTER TABLE CAB_OBSERVACOES ADD CONSTRAINT XPKCAB_OBSERVACOES PRIMARY KEY (ID_OBSERVACAO);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT XPKCAB_ORDENS PRIMARY KEY (ID_ORDEM);
ALTER TABLE CAB_PLANOS ADD CONSTRAINT XPKCAB_PLANOS PRIMARY KEY (ID_PLANO);
ALTER TABLE CAB_NOTAS ADD CONSTRAINT XPKCAB_NOTAS PRIMARY KEY (ID_NOTA);
ALTER TABLE CAB_NOTAS_ITENS ADD CONSTRAINT XPKCAB_NOTAS_ITENS PRIMARY KEY (ID_ITEM);
ALTER TABLE CAB_SERVICOS ADD CONSTRAINT XPKCAB_SERVICOS PRIMARY KEY (ID_SERVICO);
ALTER TABLE CAB_TECNICOS ADD CONSTRAINT XPKCAB_TECNICOS PRIMARY KEY (ID_TECNICO);
ALTER TABLE CAB_TIPOSATENDIMENTO ADD CONSTRAINT XPKCAB_TIPOSATENDIMENTO PRIMARY KEY (ID_TIPOATENDIMENTO);
ALTER TABLE CAB_TRABALHOS ADD CONSTRAINT XPKCAB_TRABALHOS PRIMARY KEY (ID_TRABALHO);
ALTER TABLE CAB_VENDEDORES ADD CONSTRAINT XPKCAB_VENDEDORES PRIMARY KEY (ID_VENDEDOR);
ALTER TABLE CRM_ACOES ADD CONSTRAINT XPKCRM_ACOES PRIMARY KEY (ID_ACAO);
ALTER TABLE CRM_AREAS ADD CONSTRAINT XPKCRM_AREAS PRIMARY KEY (ID_AREA);
ALTER TABLE CRM_ATIVIDADES ADD CONSTRAINT XPKCRM_ATIVIDADES PRIMARY KEY (ID_ATIVIDADE);
ALTER TABLE CRM_BAIRROS ADD CONSTRAINT XPKCRM_BAIRROS PRIMARY KEY (ID_BAIRRO);
ALTER TABLE CRM_CIDADES ADD CONSTRAINT XPKCRM_CIDADES PRIMARY KEY (ID_CIDADE);
ALTER TABLE CRM_CLIENTES_HISTORICO ADD CONSTRAINT XPKCRM_CLIENTES_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE CRM_CONFIGURACAO ADD CONSTRAINT XPKCRM_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE CRM_CONTATOS ADD CONSTRAINT XPKCRM_CONTATOS PRIMARY KEY (ID_CONTATO);
ALTER TABLE CRM_ESTADOS ADD CONSTRAINT XPKCRM_ESTADOS PRIMARY KEY (ID_ESTADO);
ALTER TABLE CRM_FORNECEDORES_HISTORICO ADD CONSTRAINT XPKCRM_FORNECEDORES_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE CRM_ORIGENS ADD CONSTRAINT XPKCRM_ORIGENS PRIMARY KEY (ID_ORIGEM);
ALTER TABLE CRM_PAISES ADD CONSTRAINT XPKCRM_PAISES PRIMARY KEY (ID_PAIS);
ALTER TABLE CRM_PERFISCLIENTES ADD CONSTRAINT XPKCRM_PERFISCLIENTES PRIMARY KEY (ID_PERFIL);
ALTER TABLE CRM_PERFISFORNECEDORES ADD CONSTRAINT XPKCRM_PERFISFORNECEDORES PRIMARY KEY (ID_PERFIL);
ALTER TABLE CRM_PERFISPOTENCIAIS ADD CONSTRAINT XPKCRM_PERFISPOTENCIAIS PRIMARY KEY (ID_PERFIL);
ALTER TABLE CRM_PORTE ADD CONSTRAINT XPKCRM_PORTE PRIMARY KEY (ID_PORTE);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT XPKCRM_POTENCIAIS PRIMARY KEY (ID_POTENCIAL);
ALTER TABLE CRM_POTENCIAIS_CONTATOS ADD CONSTRAINT XPKCRM_POTENCIAIS_CONTATOS PRIMARY KEY (ID_CONTATO);
ALTER TABLE CRM_POTENCIAIS_HISTORICO ADD CONSTRAINT XPKCRM_POTENCIAIS_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE CRM_REGIOES ADD CONSTRAINT XPKCRM_REGIOES PRIMARY KEY (ID_REGIAO);
ALTER TABLE CRM_SEGMENTOS ADD CONSTRAINT XPKCRM_SEGMENTOS PRIMARY KEY (ID_SEGMENTO);
ALTER TABLE CRM_SITUACOES ADD CONSTRAINT XPKCRM_SITUACOES PRIMARY KEY (ID_SITUACAO);
ALTER TABLE CRM_TIPOSCONTATOS ADD CONSTRAINT XPKCRM_TIPOSCONTATOS PRIMARY KEY (ID_TIPOCONTATO);
ALTER TABLE CTR_ADIANTAMENTOS ADD CONSTRAINT XPKCTR_ADIANTAMENTOS PRIMARY KEY (ID_ADIANTAMENTO);
ALTER TABLE CTR_ADIANTAMENTOS_CHEQUES ADD CONSTRAINT XPKCTR_ADIANTAMENTOS_CHEQUES PRIMARY KEY (ID_ITEM);
ALTER TABLE CTR_ALINEAS ADD CONSTRAINT XPKCTR_ALINEAS PRIMARY KEY (ID_ALINEA);
ALTER TABLE CTR_BANCARIO ADD CONSTRAINT XPKCTR_BANCARIO PRIMARY KEY (ID_MOVIMENTO);
ALTER TABLE CTR_BANCARIO_PERIODOS ADD CONSTRAINT XPKCTR_BANCARIO_PERIODOS PRIMARY KEY (ID_PERIODO);
ALTER TABLE CTR_BANCOS ADD CONSTRAINT XPKCTR_BANCOS PRIMARY KEY (ID_BANCO);
ALTER TABLE CTR_CAIXA ADD CONSTRAINT XPKCTR_CAIXA PRIMARY KEY (ID_MOVIMENTO);
ALTER TABLE CTR_CAIXA_PERIODOS ADD CONSTRAINT XPKCTR_CAIXA_PERIODOS PRIMARY KEY (ID_PERIODO);
ALTER TABLE CTR_CARTEIRAS ADD CONSTRAINT XPKCTR_CARTEIRAS PRIMARY KEY (ID_CARTEIRA);
ALTER TABLE CTR_CENTROSCUSTO ADD CONSTRAINT XPKCTR_CENTROSCUSTO PRIMARY KEY (ID_CENTROCUSTO);
ALTER TABLE CTR_CHEQUES ADD CONSTRAINT XPKCTR_CHEQUES PRIMARY KEY (ID_CHEQUE);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT XPKCTR_CLIENTES PRIMARY KEY (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_BANCOS ADD CONSTRAINT XPKCTR_CLIENTES_BANCOS PRIMARY KEY (ID_REFERENCIA);
ALTER TABLE CTR_CLIENTES_CHEQUES ADD CONSTRAINT XPKCTR_CLIENTES_CHEQUES PRIMARY KEY (ID_CHEQUE);
ALTER TABLE CTR_CLIENTES_COMERCIAIS ADD CONSTRAINT XPKCTR_CLIENTES_COMERCIAIS PRIMARY KEY (ID_REFERENCIA);
ALTER TABLE CTR_CLIENTES_CONTATOS ADD CONSTRAINT XPKCTR_CLIENTES_CONTATOS PRIMARY KEY (ID_CONTATO);
ALTER TABLE CTR_CLIENTES_CONVENIOS ADD CONSTRAINT XPKCTR_CLIENTES_CONVENIOS PRIMARY KEY (ID_CONVENIO);
ALTER TABLE CTR_CLIENTES_DIVISOES ADD CONSTRAINT XPKCTR_CLIENTES_DIVISOES PRIMARY KEY (ID_DIVISAO);
ALTER TABLE CTR_CLIENTES_RELACOES ADD CONSTRAINT XPKCTR_CLIENTES_RELACOES PRIMARY KEY (ID_ITEM);
ALTER TABLE CTR_CLIENTES_SPC ADD CONSTRAINT XPKCTR_CLIENTES_SPC PRIMARY KEY (ID_SPC);
ALTER TABLE CTR_CONFIGURACAO ADD CONSTRAINT XPKCTR_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE CTR_CONTASBANCARIAS ADD CONSTRAINT XPKCTR_CONTASBANCARIAS PRIMARY KEY (ID_CONTABANCARIA);
ALTER TABLE CTR_CONTASCAIXA ADD CONSTRAINT XPKCTR_CONTASCAIXA PRIMARY KEY (ID_CONTACAIXA);
ALTER TABLE CTR_CONTRATOS_CLIENTES ADD CONSTRAINT XPKCTR_CONTRATOS_CLIENTES PRIMARY KEY (ID_CONTRATO);
ALTER TABLE CTR_CONTRATOS_FORNECEDORES ADD CONSTRAINT XPKCTR_CONTRATOS_FORNECEDORES PRIMARY KEY (ID_CONTRATO);
ALTER TABLE CTR_FINANCIAMENTOS ADD CONSTRAINT XPKCTR_FINANCIAMENTOS PRIMARY KEY (ID_FINANCIAMENTO);
ALTER TABLE CTR_FORMASPAGAMENTO ADD CONSTRAINT XPKCTR_FORMASPAGAMENTO PRIMARY KEY (ID_FORMAPAGAMENTO);
ALTER TABLE CTR_FORMASRECEBIMENTO ADD CONSTRAINT XPKCTR_FORMASRECEBIMENTO PRIMARY KEY (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_FORMASRECEBIMENTO_PRAZOS ADD CONSTRAINT XPKCTR_FORMASRECEBIMENTO_PRAZOS PRIMARY KEY (ID_ITEM);
ALTER TABLE CTR_FORMASRECEBIMENTO_TAXAS ADD CONSTRAINT XPKCTR_FORMASRECEBIMENTO_TAXAS PRIMARY KEY (ID_ITEM);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT XPKCTR_FORNECEDORES PRIMARY KEY (ID_FORNECEDOR);
ALTER TABLE CTR_FORNECEDORES_BANCOS ADD CONSTRAINT XPKCTR_FORNECEDORES_BANCOS PRIMARY KEY (ID_REFERENCIA);
ALTER TABLE CTR_FORNECEDORES_COMERCIAIS ADD CONSTRAINT XPKCTR_FORNECEDORES_COMERCIAIS PRIMARY KEY (ID_REFERENCIA);
ALTER TABLE CTR_FORNECEDORES_CONTATOS ADD CONSTRAINT XPKCTR_FORNECEDORES_CONTATOS PRIMARY KEY (ID_CONTATO);
ALTER TABLE CTR_HISTORICOS ADD CONSTRAINT XPKCTR_HISTORICOS PRIMARY KEY (ID_HISTORICO);
ALTER TABLE CTR_IMPOSTOS ADD CONSTRAINT XPKCTR_IMPOSTOS PRIMARY KEY (ID_IMPOSTO);
ALTER TABLE CTR_INDICES ADD CONSTRAINT XPKCTR_INDICES PRIMARY KEY (ID_INDICE);
ALTER TABLE CTR_INDICES_PERCENTUAIS ADD CONSTRAINT XPKCTR_INDICES_PERCENTUAIS PRIMARY KEY (ID_PERCENTUAL);
ALTER TABLE CTR_LOCAIS ADD CONSTRAINT XPKCTR_LOCAIS PRIMARY KEY (ID_LOCAL);
ALTER TABLE CTR_REMESSAS ADD CONSTRAINT XPKCTR_REMESSAS PRIMARY KEY (ID_REMESSA);
ALTER TABLE CTR_MENSAGENS ADD CONSTRAINT XPKCTR_MENSAGENS PRIMARY KEY (ID_MENSAGEM);
ALTER TABLE CTR_MOEDAS ADD CONSTRAINT XPKCTR_MOEDAS PRIMARY KEY (ID_MOEDA);
ALTER TABLE CTR_MOEDAS_COTACOES ADD CONSTRAINT XPKCTR_MOEDAS_COTACOES PRIMARY KEY (ID_COTACAO);
ALTER TABLE CTR_ORCAMENTOS_ANOS ADD CONSTRAINT XPKCTR_ORCAMENTOS_ANOS PRIMARY KEY (ID_ANO);
ALTER TABLE CTR_ORCAMENTOS_PLANOCONTA ADD CONSTRAINT XPKCTR_ORCAMENTOS_PLANOCONTA PRIMARY KEY (ID_ANO);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT XPKCTR_PAGAMENTOS PRIMARY KEY (ID_PAGAMENTO);
ALTER TABLE CTR_PAGAMENTOS_CUSTOS ADD CONSTRAINT XPKCTR_PAGAMENTOS_CUSTOS PRIMARY KEY (ID_CUSTO);
ALTER TABLE CTR_PATRIMONIO ADD CONSTRAINT XPKCTR_PATRIMONIO PRIMARY KEY (ID_PATRIMONIO);
ALTER TABLE CTR_PATRIMONIO_HISTORICO ADD CONSTRAINT XPKCTR_PATRIMONIO_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE CTR_PATRIMONIO_MANUTENCAO ADD CONSTRAINT XPKCTR_PATRIMONIO_MANUTENCAO PRIMARY KEY (ID_MANUTENCAO);
ALTER TABLE CTR_PLANOCONTAS ADD CONSTRAINT XPKCTR_PLANOCONTAS PRIMARY KEY (ID_PLANOCONTA);
ALTER TABLE CTR_PRAZOSPAGAMENTO ADD CONSTRAINT XPKCTR_PRAZOSPAGAMENTO PRIMARY KEY (ID_PRAZOPAGAMENTO);
ALTER TABLE CTR_PRAZOSRECEBIMENTO ADD CONSTRAINT XPKCTR_PRAZOSRECEBIMENTO PRIMARY KEY (ID_PRAZORECEBIMENTO);
ALTER TABLE CTR_PREVISOES_DESPESAS ADD CONSTRAINT XPKCTR_PREVISOES_DESPESAS PRIMARY KEY (ID_PREVISAO);
ALTER TABLE CTR_PREVISOES_RECEITAS ADD CONSTRAINT XPKCTR_PREVISOES_RECEITAS PRIMARY KEY (ID_PREVISAO);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT XPKCTR_RECEBIMENTOS PRIMARY KEY (ID_RECEBIMENTO);
ALTER TABLE CTR_RECEBIMENTOS_CUSTOS ADD CONSTRAINT XPKCTR_RECEBIMENTOS_CUSTOS PRIMARY KEY (ID_CUSTO);
ALTER TABLE CTR_TALOES ADD CONSTRAINT XPKCTR_TALOES PRIMARY KEY (ID_TALAO);
ALTER TABLE CTR_TIPOSDOCUMENTOS ADD CONSTRAINT XPKCTR_TIPOSDOCUMENTOS PRIMARY KEY (ID_TIPODOCUMENTO);
ALTER TABLE CTR_TIPOSPAGAMENTO ADD CONSTRAINT XPKCTR_TIPOSPAGAMENTO PRIMARY KEY (ID_TIPOPAGAMENTO);
ALTER TABLE CTR_TIPOSRECEBIMENTO ADD CONSTRAINT XPKCTR_TIPOSRECEBIMENTO PRIMARY KEY (ID_TIPORECEBIMENTO);
ALTER TABLE CTR_TRANSFERENCIAS ADD CONSTRAINT XPKCTR_TRANSFERENCIAS PRIMARY KEY (ID_TRANSFERENCIA);
ALTER TABLE FAC_CONFIGURACAO ADD CONSTRAINT XPKFAC_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE FAC_EMBALAGENS ADD CONSTRAINT XPKFAC_EMBALAGENS PRIMARY KEY (ID_EMBALAGEM);
ALTER TABLE FAC_ENTRADAS ADD CONSTRAINT XPKFAC_ENTRADAS PRIMARY KEY (ID_ENTRADA);
ALTER TABLE FAC_ENTRADAS_PRODUTOS ADD CONSTRAINT XPKFAC_ENTRADAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE FAC_FERRAMENTAS ADD CONSTRAINT XPKFAC_FERRAMENTAS PRIMARY KEY (ID_FERRAMENTA);
ALTER TABLE FAC_MAQUINAS ADD CONSTRAINT XPKFAC_MAQUINAS PRIMARY KEY (ID_MAQUINA);
ALTER TABLE FAC_OPERACOES ADD CONSTRAINT XPKFAC_OPERACOES PRIMARY KEY (ID_OPERACAO);
ALTER TABLE FAC_OPERADORES ADD CONSTRAINT XPKFAC_OPERADORES PRIMARY KEY (ID_OPERADOR);
ALTER TABLE FAC_ORDENS ADD CONSTRAINT XPKFAC_ORDENS PRIMARY KEY (ID_ORDEM);
ALTER TABLE FAC_ORDENS_BAIXAS ADD CONSTRAINT XPKFAC_ORDENS_BAIXAS PRIMARY KEY (ID_BAIXA);
ALTER TABLE FAC_ORDENS_COMPOSICAO ADD CONSTRAINT XPKFAC_ORDENS_COMPOSICAO PRIMARY KEY (ID_ITEM);
ALTER TABLE FAC_ORDENS_PARCIAIS ADD CONSTRAINT XPKFAC_ORDENS_PARCIAIS PRIMARY KEY (ID_ITEM);
ALTER TABLE FAC_ORDENS_PARTES ADD CONSTRAINT XPKFAC_ORDENS_PARTES PRIMARY KEY (ID_PARTE);
ALTER TABLE FAC_ORDENS_PROCESSOS ADD CONSTRAINT XPKFAC_ORDENS_PROCESSOS PRIMARY KEY (ID_PROCESSO);
ALTER TABLE FAC_PARADAS ADD CONSTRAINT XPKFAC_PARADAS PRIMARY KEY (ID_PARADA);
ALTER TABLE FAC_PERDAS ADD CONSTRAINT XPKFAC_PERDAS PRIMARY KEY (ID_PERDA);
ALTER TABLE FAC_PRODUTOS_COMPOSICAO ADD CONSTRAINT XPKFAC_PRODUTOS_COMPOSICAO PRIMARY KEY (ID_COMPOSICAO);
ALTER TABLE FAC_PRODUTOS_PROCESSOS ADD CONSTRAINT XPKFAC_PRODUTOS_PROCESSOS PRIMARY KEY (ID_PROCESSO);
ALTER TABLE FAC_RETORNOS ADD CONSTRAINT XPKFAC_RETORNOS PRIMARY KEY (ID_RETORNO);
ALTER TABLE FAC_TIPOSORDENS ADD CONSTRAINT XPKFAC_TIPOSORDENS PRIMARY KEY (ID_TIPOORDEM);
ALTER TABLE GRP_ACABAMENTOS ADD CONSTRAINT XPKGRP_ACABAMENTOS PRIMARY KEY (ID_ACABAMENTO);
ALTER TABLE GRP_ATENDENTES ADD CONSTRAINT XPKGRP_ATENDENTES PRIMARY KEY (ID_ATENDENTE);
ALTER TABLE GRP_CONFIGURACAO ADD CONSTRAINT XPKGRP_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE GRP_IMPRESSORAS ADD CONSTRAINT XPKGRP_IMPRESSORAS PRIMARY KEY (ID_IMPRESSORA);
ALTER TABLE GRP_OPERADORES ADD CONSTRAINT XPKGRP_OPERADORES PRIMARY KEY (ID_OPERADOR);
ALTER TABLE GRP_ORCAMENTOS ADD CONSTRAINT XPKGRP_ORCAMENTOS PRIMARY KEY (ID_ORCAMENTO);
ALTER TABLE GRP_ORCAMENTOS_ACABAMENTO ADD CONSTRAINT XPKGRP_ORCAMENTOS_ACABAMENTO PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORCAMENTOS_IMPRESSORAS ADD CONSTRAINT XPKGRP_ORCAMENTOS_IMPRESSORAS PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORCAMENTOS_PAPEIS ADD CONSTRAINT XPKGRP_ORCAMENTOS_PAPEIS PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORCAMENTOS_QUANTIDADES ADD CONSTRAINT XPKGRP_ORCAMENTOS_QUANTIDADES PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORCAMENTOS_SERVICOS ADD CONSTRAINT XPKGRP_ORCAMENTOS_SERVICOS PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORCAMENTOS_TINTAS ADD CONSTRAINT XPKGRP_ORCAMENTOS_TINTAS PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORDENS ADD CONSTRAINT XPKGRP_ORDENS PRIMARY KEY (ID_ORDEMSERVICO);
ALTER TABLE GRP_ORDENS_ACABAMENTO ADD CONSTRAINT XPKGRP_ORDENS_ACABAMENTO PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORDENS_IMPRESSORAS ADD CONSTRAINT XPKGRP_ORDENS_IMPRESSORAS PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORDENS_PAPEIS ADD CONSTRAINT XPKGRP_ORDENS_PAPEIS PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORDENS_SERVICOS ADD CONSTRAINT XPKGRP_ORDENS_SERVICOS PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_ORDENS_TINTAS ADD CONSTRAINT XPKGRP_ORDENS_TINTAS PRIMARY KEY (ID_ITEM);
ALTER TABLE GRP_SERVICOS ADD CONSTRAINT XPKGRP_SERVICOS PRIMARY KEY (ID_SERVICO);
ALTER TABLE HDS_CONFIGURACAO ADD CONSTRAINT XPKHDS_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT XPKHDS_CONTRATOS PRIMARY KEY (ID_CONTRATO);
ALTER TABLE HDS_CONTRATOS_EQUIPAMENTOS ADD CONSTRAINT XPKHDS_CONTRATOS_EQUIPAMENTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_CONTRATOS_FUNCIONARIOS ADD CONSTRAINT XPKHDS_CONTRATOS_FUNCIONARIOS PRIMARY KEY (ID_CONTRATO_FUNCIONARIO);
ALTER TABLE HDS_CONTRATOS_INSUMOS ADD CONSTRAINT XPKHDS_CONTRATOS_INSUMOS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_CONTRATOS_PRODUTOS ADD CONSTRAINT XPKHDS_CONTRATOS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_CONTRATOS_SERVICOS ADD CONSTRAINT XPKHDS_CONTRATOS_SERVICOS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_ORCAMENTOS ADD CONSTRAINT XPKHDS_ORCAMENTOS PRIMARY KEY (ID_ORCAMENTO);
ALTER TABLE HDS_ORCAMENTOS_FUNCIONARIOS ADD CONSTRAINT XPKHDS_ORCAMENTOS_FUNCIONARIOS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_ORCAMENTOS_IMPOSTOS ADD CONSTRAINT XPKHDS_ORCAMENTOS_IMPOSTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_ORCAMENTOS_MAQUINAS ADD CONSTRAINT XPKHDS_ORCAMENTOS_MAQUINAS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_ORCAMENTOS_MATERIAIS ADD CONSTRAINT XPKHDS_ORCAMENTOS_MATERIAIS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_ORCAMENTOS_OUTROS ADD CONSTRAINT XPKHDS_ORCAMENTOS_OUTROS PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_ORCAMENTOS_TRANSPORTES ADD CONSTRAINT XPKHDS_ORCAMENTOS_TRANSPORTES PRIMARY KEY (ID_ITEM_TRANSPORTE);
ALTER TABLE HDS_ORCAMENTOS_TRATAMENTO ADD CONSTRAINT XPKHDS_ORCAMENTOS_TRATAMENTO PRIMARY KEY (ID_ITEM);
ALTER TABLE HDS_ORCAMENTOS_UNIFORMES ADD CONSTRAINT XPKHDS_ORCAMENTOS_UNIFORMES PRIMARY KEY (ID_ITEM);
ALTER TABLE HMN_AGENDAMENTO ADD CONSTRAINT XPKHMN_AGENDAMENTO PRIMARY KEY (ID_AGENDAMENTO);
ALTER TABLE HMN_APONTAMENTOS ADD CONSTRAINT XPKHMN_APONTAMENTOS PRIMARY KEY (ID_FUNCIONARIO, DT_APONTAMENTO);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT XPKHMN_CANDIDATOS PRIMARY KEY (ID_CANDIDATO);
ALTER TABLE HMN_CANDIDATOS_TESTES ADD CONSTRAINT XPKHMN_CANDIDATOS_TESTES PRIMARY KEY (ID_TESTE, ID_CANDIDATO);
ALTER TABLE HMN_CARGOS ADD CONSTRAINT PK_HMN_CARGOS PRIMARY KEY (ID_CARGO);
ALTER TABLE HMN_CONFIGURACAO ADD CONSTRAINT XPKHMN_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE HMN_CURSOS ADD CONSTRAINT PK_HMN_CURSOS PRIMARY KEY (ID_CURSO);
ALTER TABLE HMN_ENCARGOS ADD CONSTRAINT XPKHMN_ENCARGOS PRIMARY KEY (ID_ENCARGO);
ALTER TABLE HMN_ENCARGOS_DEMISSIONAIS ADD CONSTRAINT XPKHMN_ENCARGOS_DEMISSIONAIS PRIMARY KEY (ID_ITEM);
ALTER TABLE HMN_ENCARGOS_SOCIAIS ADD CONSTRAINT XPKHMN_ENCARGOS_SOCIAIS PRIMARY KEY (ID_ITEM);
ALTER TABLE HMN_ENCARGOS_TRABALHISTAS ADD CONSTRAINT XPKHMN_ENCARGOS_TRABALHISTAS PRIMARY KEY (ID_ITEM);
ALTER TABLE HMN_ESCOLARIDADE ADD CONSTRAINT XPKHMN_ESCOLARIDADE PRIMARY KEY (ID_ESCOLARIDADE);
ALTER TABLE HMN_ESTADOCIVIL ADD CONSTRAINT XPKHMN_ESTADOCIVIL PRIMARY KEY (ID_ESTADOCIVIL);
ALTER TABLE HMN_EVENTOS ADD CONSTRAINT XPKHMN_EVENTOS PRIMARY KEY (ID_EVENTO);
ALTER TABLE HMN_FERIADOS ADD CONSTRAINT XPKHMN_FERIADOS PRIMARY KEY (DT_FERIADO);
ALTER TABLE HMN_FORMACAO ADD CONSTRAINT XPKHMN_FORMACAO PRIMARY KEY (ID_FORMACAO);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT XPKHMN_FUNCIONARIOS PRIMARY KEY (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_AFASTAMENTOS ADD CONSTRAINT XPKHMN_FUNCIONARIOS_AFASTAMENTO PRIMARY KEY (ID_AFASTAMENTO);
ALTER TABLE HMN_FUNCIONARIOS_ATESTADOS ADD CONSTRAINT XPKHMN_FUNCIONARIOS_ATESTADOS PRIMARY KEY (ID_ATESTADO);
ALTER TABLE HMN_FUNCIONARIOS_CENTROSCUSTO ADD CONSTRAINT XPKHMN_FUNCIONARIOS_CENTROSCUST PRIMARY KEY (ID_ITEM);
ALTER TABLE HMN_FUNCIONARIOS_DEPENDENTES ADD CONSTRAINT XPKHMN_FUNCIONARIOS_DEPENDENTES PRIMARY KEY (ID_DEPENDENTE);
ALTER TABLE HMN_FUNCIONARIOS_HABILIDADES ADD CONSTRAINT PK_HMN_FUNCIONARIOS_HABILIDADES PRIMARY KEY (ID_ITEM);
ALTER TABLE HMN_FUNCIONARIOS_HISTORICO ADD CONSTRAINT XPKHMN_FUNCIONARIOS_HISTORICO PRIMARY KEY (ID_ITEM);
ALTER TABLE HMN_FUNCIONARIOS_HORARIOS ADD CONSTRAINT XPKHMN_FUNCIONARIOS_HORARIOS PRIMARY KEY (ID_FUNCIONARIO, TP_DIA);
ALTER TABLE HMN_FUNCIONARIOS_TOTAIS ADD CONSTRAINT XPKHMN_FUNCIONARIOS_TOTAIS PRIMARY KEY (ID_FUNCIONARIO, ID_PERIODO);
ALTER TABLE HMN_FUNCIONARIOS_UNIFORMES ADD CONSTRAINT XPKHMN_FUNCIONARIOS_UNIFORMES PRIMARY KEY (ID_UNIFORME);
ALTER TABLE HMN_FUNCOES ADD CONSTRAINT XPKHMN_FUNCOES PRIMARY KEY (ID_FUNCAO);
ALTER TABLE HMN_HABILIDADES ADD CONSTRAINT PK_HMN_HABILIDADES PRIMARY KEY (ID_HABILIDADE);
ALTER TABLE HMN_HORARIOS ADD CONSTRAINT XPKHMN_HORARIOS PRIMARY KEY (ID_HORARIO);
ALTER TABLE HMN_HORARIOS_DIAS ADD CONSTRAINT XPKHMN_HORARIOS_DIAS PRIMARY KEY (ID_HORARIO, TP_DIA);
ALTER TABLE HMN_JUSTIFICATIVAS ADD CONSTRAINT XPKHMN_JUSTIFICATIVAS PRIMARY KEY (ID_JUSTIFICATIVA);
ALTER TABLE HMN_OCORRENCIAS ADD CONSTRAINT XPKHMN_OCORRENCIAS PRIMARY KEY (ID_OCORRENCIA);
ALTER TABLE HMN_PERIODOS ADD CONSTRAINT XPKHMN_PERIODOS PRIMARY KEY (ID_PERIODO);
ALTER TABLE HMN_RECESSOS ADD CONSTRAINT XPKHMN_RECESSOS PRIMARY KEY (DT_RECESSO);
ALTER TABLE HMN_SETORES ADD CONSTRAINT XPKHMN_SETORES PRIMARY KEY (ID_SETOR);
ALTER TABLE HMN_SIRENES ADD CONSTRAINT XPKHMN_SIRENES PRIMARY KEY (ID_SIRENE);
ALTER TABLE HMN_TESTES ADD CONSTRAINT XPKHMN_TESTES PRIMARY KEY (ID_TESTE);
ALTER TABLE HMN_TRANSPORTES ADD CONSTRAINT XPKHMN_TRANSPORTES PRIMARY KEY (ID_TRANSPORTE);
ALTER TABLE HMN_TURMAS ADD CONSTRAINT PK_HMN_TURMAS PRIMARY KEY (ID_TURMA);
ALTER TABLE HMN_TURMAS_FUNCIONARIOS ADD CONSTRAINT PK_HMN_TURMAS_FUNCIONARIOS PRIMARY KEY (ID_ITEM);
ALTER TABLE HMN_VAGAS ADD CONSTRAINT XPKHMN_VAGAS PRIMARY KEY (ID_VAGA);
ALTER TABLE HMN_VAGAS_CANDIDATOS ADD CONSTRAINT XPKHMN_VAGAS_CANDIDATOS PRIMARY KEY (ID_VAGA, ID_CANDIDATO);
ALTER TABLE LIB_ARTIGOS ADD CONSTRAINT XPKLIB_ARTIGOS PRIMARY KEY (ID_PUBLICACAO);
ALTER TABLE LIB_ARTIGOS_ASSUNTOS ADD CONSTRAINT XPKLIB_ARTIGOS_ASSUNTOS PRIMARY KEY (ID_PUBLICACAO, ID_ASSUNTO);
ALTER TABLE LIB_ARTIGOS_AUTORES ADD CONSTRAINT XPKLIB_ARTIGOS_AUTORES PRIMARY KEY (ID_PUBLICACAO, ID_AUTOR);
ALTER TABLE LIB_ARTIGOS_IMAGENS ADD CONSTRAINT XPKLIB_ARTIGOS_IMAGENS PRIMARY KEY (ID_PUBLICACAO, ID_IMAGEM);
ALTER TABLE LIB_ASSUNTOS ADD CONSTRAINT XPKLIB_ASSUNTOS PRIMARY KEY (ID_ASSUNTO);
ALTER TABLE LIB_AUTORES ADD CONSTRAINT XPKLIB_AUTORES PRIMARY KEY (ID_AUTOR);
ALTER TABLE LIB_COLECOES ADD CONSTRAINT XPKLIB_COLECOES PRIMARY KEY (ID_COLECAO);
ALTER TABLE LIB_CONFIGURACAO ADD CONSTRAINT XPKLIB_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE LIB_DOCUMENTOS ADD CONSTRAINT XPKLIB_DOCUMENTOS PRIMARY KEY (ID_PUBLICACAO);
ALTER TABLE LIB_DOCUMENTOS_ASSUNTOS ADD CONSTRAINT XPKLIB_DOCUMENTOS_ASSUNTOS PRIMARY KEY (ID_PUBLICACAO, ID_ASSUNTO);
ALTER TABLE LIB_DOCUMENTOS_AUTORES ADD CONSTRAINT XPKLIB_DOCUMENTOS_AUTORES PRIMARY KEY (ID_PUBLICACAO, ID_AUTOR);
ALTER TABLE LIB_DOCUMENTOS_IMAGENS ADD CONSTRAINT XPKLIB_DOCUMENTOS_IMAGENS PRIMARY KEY (ID_PUBLICACAO, ID_IMAGEM);
ALTER TABLE LIB_EDITORAS ADD CONSTRAINT XPKLIB_EDITORAS PRIMARY KEY (ID_EDITORA);
ALTER TABLE LIB_EMPRESTIMOS ADD CONSTRAINT XPKLIB_EMPRESTIMOS PRIMARY KEY (ID_EMPRESTIMO);
ALTER TABLE LIB_LIVROS ADD CONSTRAINT XPKLIB_LIVROS PRIMARY KEY (ID_PUBLICACAO);
ALTER TABLE LIB_LIVROS_ASSUNTOS ADD CONSTRAINT XPKLIB_LIVROS_ASSUNTOS PRIMARY KEY (ID_PUBLICACAO, ID_ASSUNTO);
ALTER TABLE LIB_LIVROS_AUTORES ADD CONSTRAINT XPKLIB_LIVROS_AUTORES PRIMARY KEY (ID_PUBLICACAO, ID_AUTOR);
ALTER TABLE LIB_LIVROS_IMAGENS ADD CONSTRAINT XPKLIB_LIVROS_IMAGENS PRIMARY KEY (ID_PUBLICACAO, ID_IMAGEM);
ALTER TABLE LIB_LOCAIS ADD CONSTRAINT XPKLIB_LOCAIS PRIMARY KEY (ID_LOCAL);
ALTER TABLE LIB_MIDIAS ADD CONSTRAINT XPKLIB_MIDIAS PRIMARY KEY (ID_PUBLICACAO);
ALTER TABLE LIB_MIDIAS_ASSUNTOS ADD CONSTRAINT XPKLIB_MIDIAS_ASSUNTOS PRIMARY KEY (ID_PUBLICACAO, ID_ASSUNTO);
ALTER TABLE LIB_MIDIAS_AUTORES ADD CONSTRAINT XPKLIB_MIDIAS_AUTORES PRIMARY KEY (ID_PUBLICACAO, ID_AUTOR);
ALTER TABLE LIB_MIDIAS_CONTEUDO ADD CONSTRAINT XPKLIB_MIDIAS_CONTEUDO PRIMARY KEY (ID_CONTEUDO);
ALTER TABLE LIB_MIDIAS_IMAGENS ADD CONSTRAINT XPKLIB_MIDIAS_IMAGENS PRIMARY KEY (ID_PUBLICACAO, ID_IMAGEM);
ALTER TABLE LIB_PERIODICOS_ASSUNTOS ADD CONSTRAINT XPKLIB_PERIODICOS_ASSUNTOS PRIMARY KEY (ID_PUBLICACAO, ID_ASSUNTO);
ALTER TABLE LIB_PERIODICOS_AUTORES ADD CONSTRAINT XPKLIB_PERIODICOS_AUTORES PRIMARY KEY (ID_PUBLICACAO, ID_AUTOR);
ALTER TABLE LIB_PERIODICOS_EDICOES ADD CONSTRAINT XPKLIB_PERIODICOS_EDICOES PRIMARY KEY (ID_PUBLICACAO);
ALTER TABLE LIB_PERIODICOS_IMAGENS ADD CONSTRAINT XPKLIB_PERIODICOS_IMAGENS PRIMARY KEY (ID_PUBLICACAO, ID_IMAGEM);
ALTER TABLE LIB_PERIODICOS_TITULOS ADD CONSTRAINT XPKLIB_PERIODICOS_TITULOS PRIMARY KEY (ID_PERIODICO);
ALTER TABLE LIV_CONFIGURACAO ADD CONSTRAINT XPKLIV_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE LWR_ACOES ADD CONSTRAINT XPKLWR_ACOES PRIMARY KEY (ID_ACAO);
ALTER TABLE LWR_ADVOGADOS ADD CONSTRAINT XPKLWR_ADVOGADOS PRIMARY KEY (ID_ADVOGADO);
ALTER TABLE LWR_ANDAMENTO ADD CONSTRAINT XPKLWR_ANDAMENTO PRIMARY KEY (ID_ANDAMENTO);
ALTER TABLE LWR_CONFIGURACAO ADD CONSTRAINT XPKLWR_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE LWR_ESTAGIARIOS ADD CONSTRAINT XPKLWR_ESTAGIARIOS PRIMARY KEY (ID_ESTAGIARIO);
ALTER TABLE LWR_FASES ADD CONSTRAINT XPKLWR_FASES PRIMARY KEY (ID_FASE);
ALTER TABLE LWR_JUIZOS ADD CONSTRAINT XPKLWR_JUIZOS PRIMARY KEY (ID_JUIZO);
ALTER TABLE LWR_PROCESSOS ADD CONSTRAINT XPKLWR_PROCESSOS PRIMARY KEY (ID_PROCESSO);
ALTER TABLE PDV_CONFIGURACAO ADD CONSTRAINT XPKPDV_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE PDV_VENDA ADD CONSTRAINT XPKPDV_VENDA PRIMARY KEY (ID_VENDA);
ALTER TABLE PDV_VENDA_PRODUTOS ADD CONSTRAINT XPKPDV_VENDA_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE QLT_IDENTIFICACOES ADD CONSTRAINT XPKQLT_IDENTIFICACOES PRIMARY KEY (ID_IDENTIFICACAO);
ALTER TABLE SCH_ALUNOS_FREQUENCIA ADD CONSTRAINT PK_SCH_ALUNOS_FREQUENCIA PRIMARY KEY (ID_FREQUENCIA);
ALTER TABLE SCH_ALUNOS_MATERIAL ADD CONSTRAINT XPKSCH_ALUNOS_MATERIAL PRIMARY KEY (ID_ITEM);
ALTER TABLE SCH_ALUNOS_OCORRENCIAS ADD CONSTRAINT PK_SCH_ALUNOS_OCORRENCIAS PRIMARY KEY (ID_OCORRENCIA);
ALTER TABLE SCH_ALUNOS_TAXAS ADD CONSTRAINT XPKSCH_ALUNOS_TAXAS PRIMARY KEY (ID_ITEM);
ALTER TABLE SCH_AVALIACOES ADD CONSTRAINT XPKSCH_AVALIACOES PRIMARY KEY (ID_AVALIACAO);
ALTER TABLE SCH_AVALIACOES_DISCIPLINAS ADD CONSTRAINT XPKSCH_AVALIACOES_DISCIPLINAS PRIMARY KEY (ID_ITEM);
ALTER TABLE SCH_AVALIACOES_QUESTOES ADD CONSTRAINT XPKSCH_AVALIACOES_QUESTOES PRIMARY KEY (ID_ITEM);
ALTER TABLE SCH_CONFIGURACAO ADD CONSTRAINT XPKSCH_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE SCH_CONVENIOS ADD CONSTRAINT XPKSCH_CONVENIOS PRIMARY KEY (ID_CONVENIO);
ALTER TABLE SCH_CURSOS ADD CONSTRAINT XPKSCH_CURSOS PRIMARY KEY (ID_CURSO);
ALTER TABLE SCH_CURSOS_DISCIPLINAS ADD CONSTRAINT XPKSCH_CURSOS_DISCIPLINAS PRIMARY KEY (ID_DISCIPLINA, ID_NIVEL);
ALTER TABLE SCH_DIAS ADD CONSTRAINT XPKSCH_DIAS PRIMARY KEY (ID_DIA);
ALTER TABLE SCH_DISCIPLINAS ADD CONSTRAINT XPKSCH_DISCIPLINAS PRIMARY KEY (ID_DISCIPLINA);
ALTER TABLE SCH_DISCIPLINAS_TOPICOS ADD CONSTRAINT XPKSCH_DISCIPLINAS_TOPICOS PRIMARY KEY (ID_TOPICO);
ALTER TABLE SCH_FREQUENCIAS ADD CONSTRAINT XPKSCH_FREQUENCIAS PRIMARY KEY (ID_ALUNO, DT_APONTAMENTO);
ALTER TABLE SCH_HISTORICO ADD CONSTRAINT XPKSCH_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE SCH_HISTORICO_DISCIPLINAS ADD CONSTRAINT XPKSCH_HISTORICO_DISCIPLINAS PRIMARY KEY (ID_ITEM);
ALTER TABLE SCH_LOCAIS ADD CONSTRAINT XPKSCH_LOCAIS PRIMARY KEY (ID_LOCAL);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT XPKSCH_MATRICULAS PRIMARY KEY (ID_MATRICULA);
ALTER TABLE SCH_MENSAGENS ADD CONSTRAINT XPKSCH_MENSAGENS PRIMARY KEY (ID_MENSAGEM);
ALTER TABLE SCH_NIVEIS ADD CONSTRAINT XPKSCH_NIVEIS PRIMARY KEY (ID_NIVEL);
ALTER TABLE SCH_PAUTA ADD CONSTRAINT XPKSCH_PAUTA PRIMARY KEY (ID_PAUTA);
ALTER TABLE SCH_PERGUNTAS_RESPOSTAS ADD CONSTRAINT XPKSCH_PERGUNTAS_RESPOSTAS PRIMARY KEY (ID_RESPOSTA);
ALTER TABLE SCH_PERIODOS ADD CONSTRAINT XPKSCH_PERIODOS PRIMARY KEY (ID_PERIODO);
ALTER TABLE SCH_PROFESSORES ADD CONSTRAINT XPKSCH_PROFESSORES PRIMARY KEY (ID_PROFESSOR);
ALTER TABLE SCH_QUESTOES ADD CONSTRAINT XPKSCH_QUESTOES PRIMARY KEY (ID_QUESTAO);
ALTER TABLE SCH_SALAS ADD CONSTRAINT XPKSCH_SALAS PRIMARY KEY (ID_SALA);
ALTER TABLE SCH_TAXAS ADD CONSTRAINT XPKSCH_TAXAS PRIMARY KEY (ID_TAXA);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT XPKSCH_TURMAS PRIMARY KEY (ID_TURMA);
ALTER TABLE SCH_TURMAS_CALENDARIOS ADD CONSTRAINT XPKSCH_TURMAS_CALENDARIOS PRIMARY KEY (ID_CALENDARIO);
ALTER TABLE SCH_TURMAS_DISCIPLINAS ADD CONSTRAINT XPKSCH_TURMAS_DISCIPLINAS PRIMARY KEY (ID_TURMA, ID_DISCIPLINA);
ALTER TABLE SCH_TURMAS_HORARIOS ADD CONSTRAINT XPKSCH_TURMAS_HORARIOS PRIMARY KEY (ID_TURMA, TP_DIA, HR_ENTRADA);
ALTER TABLE SHP_CONFIGURACAO ADD CONSTRAINT XPKSHP_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE SHP_CONSULTAS ADD CONSTRAINT XPKSHP_CONSULTAS PRIMARY KEY (ID_CONSULTA);
ALTER TABLE SHP_CONSULTAS_PRODUTOS ADD CONSTRAINT XPKSHP_CONSULTAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SIS_ACESSOS ADD CONSTRAINT XPKSIS_ACESSOS PRIMARY KEY (ID_ACESSO);
ALTER TABLE SIS_BACKUP ADD CONSTRAINT XPKSIS_BACKUP PRIMARY KEY (ID_BACKUP);
ALTER TABLE SIS_BACKUP_HISTORICO ADD CONSTRAINT XPKSIS_BACKUP_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE SIS_CODIGOS ADD CONSTRAINT XPKSIS_CODIGOS PRIMARY KEY (TX_TABELA);
ALTER TABLE SIS_CONFIG ADD CONSTRAINT XPKSIS_CONFIG PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE SIS_EMPRESA ADD CONSTRAINT XPKSIS_EMPRESA PRIMARY KEY (ID_EMPRESA);
ALTER TABLE SIS_GRUPOS ADD CONSTRAINT XPKSIS_GRUPOS PRIMARY KEY (ID_GRUPO);
ALTER TABLE SIS_GRUPOS_ACESSOS ADD CONSTRAINT XPKSIS_GRUPOS_ACESSOS PRIMARY KEY (ID_GRUPO, ID_ACESSO);
ALTER TABLE SIS_IMPRESSORAS ADD CONSTRAINT XPKSIS_IMPRESSORAS PRIMARY KEY (ID_IMPRESSORA);
ALTER TABLE SIS_INTERNET ADD CONSTRAINT XPKSIS_INTERNET PRIMARY KEY (ID_INTERNET);
ALTER TABLE SIS_LICENCAS ADD CONSTRAINT XPKSIS_LICENCAS PRIMARY KEY (ID_LICENCA);
ALTER TABLE SIS_NUMERACAO ADD CONSTRAINT XPKSIS_NUMERACAO PRIMARY KEY (TX_TABELA);
ALTER TABLE SIS_REGISTRO ADD CONSTRAINT XPKSIS_REGISTRO PRIMARY KEY (ID_REGISTRO);
ALTER TABLE SIS_RELATORIOS ADD CONSTRAINT XPKSIS_RELATORIOS PRIMARY KEY (ID_RELATORIO);
ALTER TABLE SIS_USUARIOS ADD CONSTRAINT XPKSIS_USUARIOS PRIMARY KEY (ID_USUARIO);
ALTER TABLE SIS_USUARIOS_ACESSOS ADD CONSTRAINT XPKSIS_USUARIOS_ACESSOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SIS_USUARIOS_CENTROSCUSTO ADD CONSTRAINT PK_SIS_USUARIOS_CENTROSCUSTO PRIMARY KEY (ID_USUARIO, ID_CENTROCUSTO);
ALTER TABLE SIS_USUARIOS_EMAIL ADD CONSTRAINT XPKSIS_USUARIOS_EMAIL PRIMARY KEY (ID_EMAIL);
ALTER TABLE SIS_VERSAO ADD CONSTRAINT XPKSIS_VERSAO PRIMARY KEY (CD_VERSAO);
ALTER TABLE SRV_CONFIGURACAO ADD CONSTRAINT XPKSRV_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE SRV_CONTRATOS ADD CONSTRAINT XPKSRV_CONTRATOS PRIMARY KEY (ID_CONTRATO);
ALTER TABLE SRV_CONTRATOS_SERVICOS ADD CONSTRAINT XPKSRV_CONTRATOS_SERVICOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SRV_EQUIPAMENTOS ADD CONSTRAINT XPKSRV_EQUIPAMENTOS PRIMARY KEY (ID_EQUIPAMENTO);
ALTER TABLE SRV_NATUREZA ADD CONSTRAINT XPKSRV_NATUREZA PRIMARY KEY (ID_NATUREZA);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT XPKSRV_NOTAS PRIMARY KEY (ID_NOTA);
ALTER TABLE SRV_NOTAS_PRODUTOS ADD CONSTRAINT XPKSRV_NOTAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SRV_NOTAS_SERVICOS ADD CONSTRAINT XPKSRV_NOTAS_SERVICOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SRV_ORCAMENTOS ADD CONSTRAINT XPKSRV_ORCAMENTOS PRIMARY KEY (ID_ORCAMENTO);
ALTER TABLE SRV_ORCAMENTOS_PRODUTOS ADD CONSTRAINT XPKSRV_ORCAMENTOS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SRV_ORCAMENTOS_SERVICOS ADD CONSTRAINT XPKSRV_ORCAMENTOS_SERVICOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT XPKSRV_ORDENS PRIMARY KEY (ID_ORDEMSERVICO);
ALTER TABLE SRV_ORDENS_HISTORICO ADD CONSTRAINT XPKSRV_ORDENS_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE SRV_ORDENS_PRODUTOS ADD CONSTRAINT XPKSRV_ORDENS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SRV_ORDENS_SERVICOS ADD CONSTRAINT XPKSRV_ORDENS_SERVICOS PRIMARY KEY (ID_ITEM);
ALTER TABLE SRV_SERIES ADD CONSTRAINT XPKSRV_SERIES PRIMARY KEY (ID_SERIE);
ALTER TABLE SRV_SERVICOS ADD CONSTRAINT XPKSRV_SERVICOS PRIMARY KEY (ID_SERVICO);
ALTER TABLE SRV_TECNICOS ADD CONSTRAINT XPKSRV_TECNICOS PRIMARY KEY (ID_TECNICO);
ALTER TABLE SRV_TIPOSORDENS ADD CONSTRAINT XPKSRV_TIPOSORDENS PRIMARY KEY (ID_TIPOORDEM);
ALTER TABLE SRV_VEICULOS ADD CONSTRAINT XPKSRV_VEICULOS PRIMARY KEY (ID_VEICULO);
ALTER TABLE SRV_VENDEDORES ADD CONSTRAINT XPKSRV_VENDEDORES PRIMARY KEY (ID_VENDEDOR);
ALTER TABLE STK_CONFIGURACAO ADD CONSTRAINT XPKSTK_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE STK_MOVIMENTO ADD CONSTRAINT XPKSTK_MOVIMENTO PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_ACABAMENTOS ADD CONSTRAINT XPKSTR_ACABAMENTOS PRIMARY KEY (ID_ACABAMENTO);
ALTER TABLE STR_ALIQUOTAS ADD CONSTRAINT XPKSTR_ALIQUOTAS PRIMARY KEY (ID_ALIQUOTA);
ALTER TABLE STR_ALIQUOTAS_CFOP ADD CONSTRAINT XPKSTR_ALIQUOTAS_CFOP PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_CFOP ADD CONSTRAINT XPKSTR_CFOP PRIMARY KEY (ID_CFOP);
ALTER TABLE STR_MOTORISTAS ADD CONSTRAINT XPKSTR_MOTORISTAS PRIMARY KEY (ID_MOTORISTA);
ALTER TABLE STR_APLICACOES ADD CONSTRAINT XPKSTR_APLICACOES PRIMARY KEY (ID_APLICACAO);
ALTER TABLE STR_CLASSES ADD CONSTRAINT XPKSTR_CLASSES PRIMARY KEY (ID_CLASSE);
ALTER TABLE STR_CLIENTES_CLASSES ADD CONSTRAINT XPKSTR_CLIENTES_CLASSES PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_CLIENTES_MOVIMENTO ADD CONSTRAINT XPKSTR_CLIENTES_MOVIMENTO PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_CLIENTES_PRODUTOS ADD CONSTRAINT XPKSTR_CLIENTES_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_COMISSOES ADD CONSTRAINT XPKSTR_COMISSOES PRIMARY KEY (ID_COMISSAO);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT XPKSTR_COMPRAS PRIMARY KEY (ID_COMPRA);
ALTER TABLE STR_COMPRAS_ORDENSCOMPRA ADD CONSTRAINT XPKSTR_COMPRAS_ORDENSCOMPRA PRIMARY KEY (ID_COMPRA, ID_ORDEMCOMPRA);
ALTER TABLE STR_COMPRAS_PRODUTOS ADD CONSTRAINT XPKSTR_COMPRAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_CONFIGURACAO ADD CONSTRAINT XPKSTR_CONFIGURACAO PRIMARY KEY (ID_CONFIGURACAO);
ALTER TABLE STR_CONVENIOS ADD CONSTRAINT XPKSTR_CONVENIOS PRIMARY KEY (ID_CONVENIO);
ALTER TABLE STR_CORES ADD CONSTRAINT XPKSTR_CORES PRIMARY KEY (ID_COR);
ALTER TABLE STR_COTACOES ADD CONSTRAINT XPKSTR_COTACOES PRIMARY KEY (ID_COTACAO);
ALTER TABLE STR_COTACOES_PRODUTOS ADD CONSTRAINT XPKSTR_COTACOES_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_DEVOLUCOES ADD CONSTRAINT XPKSTR_DEVOLUCOES PRIMARY KEY (ID_DEVOLUCAO);
ALTER TABLE STR_DEVOLUCOES_PRODUTOS ADD CONSTRAINT XPKSTR_DEVOLUCOES_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_ENTRADAS ADD CONSTRAINT XPKSTR_ENTRADAS PRIMARY KEY (ID_ENTRADA);
ALTER TABLE STR_ENTRADAS_PRODUTOS ADD CONSTRAINT XPKSTR_ENTRADAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_ESTOQUES ADD CONSTRAINT XPKSTR_ESTOQUES PRIMARY KEY (ID_ESTOQUE);
ALTER TABLE STR_FABRICANTES ADD CONSTRAINT XPKSTR_FABRICANTES PRIMARY KEY (ID_FABRICANTE);
ALTER TABLE STR_GRADES ADD CONSTRAINT XPKSTR_GRADES PRIMARY KEY (ID_GRADE);
ALTER TABLE STR_GRUPOS ADD CONSTRAINT XPKSTR_GRUPOS PRIMARY KEY (ID_GRUPO);
ALTER TABLE STR_HISTORICO ADD CONSTRAINT XPKSTR_HISTORICO PRIMARY KEY (ID_HISTORICO);
ALTER TABLE STR_ICMS ADD CONSTRAINT XPKSTR_ICMS PRIMARY KEY (ID_ICMS);
ALTER TABLE STR_INDICACOES ADD CONSTRAINT XPKSTR_INDICACOES PRIMARY KEY (ID_INDICACAO);
ALTER TABLE STR_INVENTARIO ADD CONSTRAINT XPKSTR_INVENTARIO PRIMARY KEY (ID_INVENTARIO);
ALTER TABLE STR_INVENTARIO_PRODUTOS ADD CONSTRAINT XPKSTR_INVENTARIO_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_LOJAS ADD CONSTRAINT XPKSTR_LOJAS PRIMARY KEY (ID_LOJA);
ALTER TABLE STR_OBSERVACOES ADD CONSTRAINT XPKSTR_OBSERVACOES PRIMARY KEY (ID_OBSERVACAO);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT XPKSTR_ORCAMENTOS PRIMARY KEY (ID_ORCAMENTO);
ALTER TABLE STR_ORCAMENTOS_COMPONENTES ADD CONSTRAINT XPKSTR_ORCAMENTOS_COMPONENTES PRIMARY KEY (ID_ITEM_COMPONENTE);
ALTER TABLE STR_ORCAMENTOS_PRODUTOS ADD CONSTRAINT XPKSTR_ORCAMENTOS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT XPKSTR_ORDENSCOMPRA PRIMARY KEY (ID_ORDEMCOMPRA);
ALTER TABLE STR_ORDENSCOMPRA_PRODUTOS ADD CONSTRAINT XPKSTR_ORDENSCOMPRA_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT XPKSTR_PEDIDOS PRIMARY KEY (ID_PEDIDO);
ALTER TABLE STR_PEDIDOS_COMPONENTES ADD CONSTRAINT XPKSTR_PEDIDOS_COMPONENTES PRIMARY KEY (ID_ITEM_COMPONENTE);
ALTER TABLE STR_PEDIDOS_HISTORICO ADD CONSTRAINT XPKSTR_PEDIDOS_HISTORICO PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PEDIDOS_PRODUTOS ADD CONSTRAINT XPKSTR_PEDIDOS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PONTOSVENDA ADD CONSTRAINT XPKSTR_PONTOSVENDA PRIMARY KEY (ID_PONTOVENDA);
ALTER TABLE STR_PONTOSVENDA_CAIXAS ADD CONSTRAINT XPKSTR_PONTOSVENDA_CAIXAS PRIMARY KEY (ID_CAIXA);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT XPKSTR_PRODUTOS PRIMARY KEY (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_APLICACOES ADD CONSTRAINT XPKSTR_PRODUTOS_APLICACOES PRIMARY KEY (ID_APLICACAO);
ALTER TABLE STR_PRODUTOS_COMPONENTES ADD CONSTRAINT XPKSTR_PRODUTOS_COMPONENTES PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PRODUTOS_COMPRAS ADD CONSTRAINT XPKSTR_PRODUTOS_COMPRAS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PRODUTOS_EAN ADD CONSTRAINT XPKSTR_PRODUTOS_EAN PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PRODUTOS_ESTOQUES ADD CONSTRAINT XPKSTR_PRODUTOS_ESTOQUES PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PRODUTOS_FORMATOS ADD CONSTRAINT XPKSTR_PRODUTOS_FORMATOS PRIMARY KEY (ID_FORMATO);
ALTER TABLE STR_PRODUTOS_FORNECEDORES ADD CONSTRAINT XPKSTR_PRODUTOS_FORNECEDORES PRIMARY KEY (ID_PRODUTO, ID_FORNECEDOR);
ALTER TABLE STR_PRODUTOS_FOTOS ADD CONSTRAINT XPKSTR_PRODUTOS_FOTOS PRIMARY KEY (ID_FOTO);
ALTER TABLE STR_PRODUTOS_LOTES ADD CONSTRAINT XPKSTR_PRODUTOS_LOTES PRIMARY KEY (ID_LOTE);
ALTER TABLE STR_PRODUTOS_PRECOS ADD CONSTRAINT XPKSTR_PRODUTOS_PRECOS PRIMARY KEY (ID_PRECO);
ALTER TABLE STR_PRODUTOS_REAJUSTES ADD CONSTRAINT XPKSTR_PRODUTOS_REAJUSTES PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PRODUTOS_RELACIONADOS ADD CONSTRAINT XPKSTR_PRODUTOS_RELACIONADOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_PRODUTOS_SERIES ADD CONSTRAINT XPKSTR_PRODUTOS_SERIES PRIMARY KEY (ID_SERIE);
ALTER TABLE STR_PRODUTOS_SIMILARES ADD CONSTRAINT XPKSTR_PRODUTOS_SIMILARES PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_REQUISICOES ADD CONSTRAINT XPKSTR_REQUISICOES PRIMARY KEY (ID_REQUISICAO);
ALTER TABLE STR_REQUISICOES_PRODUTOS ADD CONSTRAINT XPKSTR_REQUISICOES_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_RETORNO ADD CONSTRAINT XPKSTR_RETORNO PRIMARY KEY (ID_RETORNO);
ALTER TABLE STR_RETORNO_PRODUTOS ADD CONSTRAINT XPKSTR_RETORNO_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_ROTAS ADD CONSTRAINT XPKSTR_ROTAS PRIMARY KEY (ID_ROTA);
ALTER TABLE STR_SAIDAS ADD CONSTRAINT XPKSTR_SAIDAS PRIMARY KEY (ID_SAIDA);
ALTER TABLE STR_SAIDAS_PRODUTOS ADD CONSTRAINT XPKSTR_SAIDAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_SERIES ADD CONSTRAINT XPKSTR_SERIES PRIMARY KEY (ID_SERIE);
ALTER TABLE STR_TABELAS ADD CONSTRAINT XPKSTR_TABELAS PRIMARY KEY (ID_TABELA);
ALTER TABLE STR_TABELAS_PRODUTOS ADD CONSTRAINT XPKSTR_TABELAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_TIPOS ADD CONSTRAINT XPKSTR_TIPOS PRIMARY KEY (ID_TIPO);
ALTER TABLE STR_TRANSFERENCIAS ADD CONSTRAINT XPKSTR_TRANSFERENCIAS PRIMARY KEY (ID_TRANSFERENCIA);
ALTER TABLE STR_TRANSFERENCIAS_PRODUTOS ADD CONSTRAINT XPKSTR_TRANSFERENCIAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_TRANSPORTADORAS ADD CONSTRAINT XPKSTR_TRANSPORTADORAS PRIMARY KEY (ID_TRANSPORTADORA);
ALTER TABLE STR_TRANSPORTADORAS_CONTATOS ADD CONSTRAINT XPKSTR_TRANSPORTADORAS_CONTATOS PRIMARY KEY (ID_CONTATO);
ALTER TABLE STR_UNIDADES ADD CONSTRAINT XPKSTR_UNIDADES PRIMARY KEY (ID_UNIDADE);
ALTER TABLE STR_VENDAS ADD CONSTRAINT XPKSTR_VENDAS PRIMARY KEY (ID_VENDA);
ALTER TABLE STR_VENDAS_COMPONENTES ADD CONSTRAINT XPKSTR_VENDAS_COMPONENTES PRIMARY KEY (ID_ITEM_COMPONENTE);
ALTER TABLE STR_VENDAS_PRODUTOS ADD CONSTRAINT XPKSTR_VENDAS_PRODUTOS PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_VENDEDORES ADD CONSTRAINT XPKSTR_VENDEDORES PRIMARY KEY (ID_VENDEDOR);
ALTER TABLE STR_VENDEDORES_FABRICANTES ADD CONSTRAINT XPKSTR_VENDEDORES_FABRICANTES PRIMARY KEY (ID_ITEM);
ALTER TABLE STR_VENDEDORES_PDV ADD CONSTRAINT XPKSTR_VENDEDORES_PDV PRIMARY KEY (ID_ITEM);

/******************************************************************************/
/***                           Unique constraints                           ***/
/******************************************************************************/



/******************************************************************************/
/***                              Foreign keys                              ***/
/******************************************************************************/


ALTER TABLE BLD_OBRAS ADD CONSTRAINT R_638 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE BLD_OBRAS ADD CONSTRAINT R_639 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE BLD_OBRAS ADD CONSTRAINT R_870 FOREIGN KEY (ID_TIPOOBRA) REFERENCES BLD_TIPOSOBRAS (ID_TIPOOBRA);
ALTER TABLE BLD_OBRAS_ART ADD CONSTRAINT R_2454 FOREIGN KEY (ID_OBRA) REFERENCES BLD_OBRAS (ID_OBRA);
ALTER TABLE CAB_AJUSTES ADD CONSTRAINT R_2911 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CAB_ATENDIMENTOS ADD CONSTRAINT R_2838 FOREIGN KEY (ID_TIPOATENDIMENTO) REFERENCES CAB_TIPOSATENDIMENTO (ID_TIPOATENDIMENTO);
ALTER TABLE CAB_ATENDIMENTOS ADD CONSTRAINT R_2839 FOREIGN KEY (ID_AREA) REFERENCES CAB_AREAS (ID_AREA);
ALTER TABLE CAB_ATENDIMENTOS ADD CONSTRAINT R_2840 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CAB_ATENDIMENTOS ADD CONSTRAINT R_2868 FOREIGN KEY (ID_INTERRUPCAO) REFERENCES CAB_INTERRUPCOES (ID_INTERRUPCAO);
ALTER TABLE CAB_CAIXAS ADD CONSTRAINT R_2818 FOREIGN KEY (ID_CONTACAIXA) REFERENCES CTR_CONTASCAIXA (ID_CONTACAIXA);
ALTER TABLE CAB_COMENTARIOS ADD CONSTRAINT R_2837 FOREIGN KEY (ID_ATENDIMENTO) REFERENCES CAB_ATENDIMENTOS (ID_ATENDIMENTO);
ALTER TABLE CAB_CONTRATOS ADD CONSTRAINT R_2662 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CAB_CONTRATOS ADD CONSTRAINT R_2743 FOREIGN KEY (ID_PLANO) REFERENCES CAB_PLANOS (ID_PLANO);
ALTER TABLE CAB_CONTRATOS ADD CONSTRAINT R_2748 FOREIGN KEY (ID_CANCELAMENTO) REFERENCES CAB_CANCELAMENTOS (ID_CANCELAMENTO);
ALTER TABLE CAB_CONTRATOS ADD CONSTRAINT R_2759 FOREIGN KEY (ID_INDICE) REFERENCES CTR_INDICES (ID_INDICE);
ALTER TABLE CAB_CONTRATOS ADD CONSTRAINT R_2805 FOREIGN KEY (ID_MODEM) REFERENCES CAB_MODEMS (ID_MODEM);
ALTER TABLE CAB_CONTRATOS ADD CONSTRAINT R_2817 FOREIGN KEY (ID_VENDEDOR) REFERENCES CAB_VENDEDORES (ID_VENDEDOR);
ALTER TABLE CAB_CONTRATOS_REAJUSTES ADD CONSTRAINT R_2795 FOREIGN KEY (ID_CONTRATO) REFERENCES CAB_CONTRATOS (ID_CONTRATO);
ALTER TABLE CAB_CONTRATOS_REAJUSTES ADD CONSTRAINT R_2799 FOREIGN KEY (ID_PLANO) REFERENCES CAB_PLANOS (ID_PLANO);
ALTER TABLE CAB_OBSERVACOES ADD CONSTRAINT R_2856 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2742 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2754 FOREIGN KEY (ID_SERVICO) REFERENCES CAB_SERVICOS (ID_SERVICO);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2757 FOREIGN KEY (ID_CANCELAMENTO) REFERENCES CAB_CANCELAMENTOS (ID_CANCELAMENTO);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2815 FOREIGN KEY (ID_ATENDENTE) REFERENCES CAB_ATENDENTES (ID_ATENDENTE);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2819 FOREIGN KEY (ID_TECNICO) REFERENCES CAB_TECNICOS (ID_TECNICO);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2820 FOREIGN KEY (ID_AJUDANTE) REFERENCES CAB_TECNICOS (ID_TECNICO);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2821 FOREIGN KEY (ID_MOTORISTA) REFERENCES CAB_TECNICOS (ID_TECNICO);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2828 FOREIGN KEY (ID_CONTRATO) REFERENCES CAB_CONTRATOS (ID_CONTRATO);
ALTER TABLE CAB_ORDENS ADD CONSTRAINT R_2852 FOREIGN KEY (ID_ATENDIMENTO) REFERENCES CAB_ATENDIMENTOS (ID_ATENDIMENTO);
ALTER TABLE CAB_NOTAS ADD CONSTRAINT R_2853 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CAB_NOTAS_ITENS ADD CONSTRAINT R_2854 FOREIGN KEY (ID_NOTA) REFERENCES CAB_NOTAS (ID_NOTA);
ALTER TABLE CAB_PLANOS ADD CONSTRAINT R_2886 FOREIGN KEY (ID_GRUPO) REFERENCES CAB_GRUPOS (ID_GRUPO);
ALTER TABLE CAB_SERVICOS ADD CONSTRAINT R_2745 FOREIGN KEY (ID_PLANO) REFERENCES CAB_PLANOS (ID_PLANO);
ALTER TABLE CAB_SERVICOS ADD CONSTRAINT R_2855 FOREIGN KEY (ID_TIPOATENDIMENTO) REFERENCES CAB_TIPOSATENDIMENTO (ID_TIPOATENDIMENTO);
ALTER TABLE CAB_TRABALHOS ADD CONSTRAINT R_2887 FOREIGN KEY (ID_TECNICO) REFERENCES CAB_TECNICOS (ID_TECNICO);
ALTER TABLE CRM_BAIRROS ADD CONSTRAINT R_1025 FOREIGN KEY (ID_CIDADE) REFERENCES CRM_CIDADES (ID_CIDADE);
ALTER TABLE CRM_BAIRROS ADD CONSTRAINT R_2495 FOREIGN KEY (ID_REGIAO) REFERENCES CRM_REGIOES (ID_REGIAO);
ALTER TABLE CRM_CIDADES ADD CONSTRAINT R_1016 FOREIGN KEY (ID_ESTADO) REFERENCES CRM_ESTADOS (ID_ESTADO);
ALTER TABLE CRM_CIDADES ADD CONSTRAINT R_2493 FOREIGN KEY (ID_REGIAO) REFERENCES CRM_REGIOES (ID_REGIAO);
ALTER TABLE CRM_CLIENTES_HISTORICO ADD CONSTRAINT R_2500 FOREIGN KEY (ID_ACAO) REFERENCES CRM_ACOES (ID_ACAO);
ALTER TABLE CRM_CLIENTES_HISTORICO ADD CONSTRAINT R_2503 FOREIGN KEY (ID_SITUACAO) REFERENCES CRM_SITUACOES (ID_SITUACAO);
ALTER TABLE CRM_CLIENTES_HISTORICO ADD CONSTRAINT R_307 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CRM_CLIENTES_HISTORICO ADD CONSTRAINT R_845 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE CRM_CONFIGURACAO ADD CONSTRAINT R_2323 FOREIGN KEY (ID_FUNCAO_ATENDENTE) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE CRM_CONTATOS ADD CONSTRAINT R_2496 FOREIGN KEY (ID_TIPOCONTATO) REFERENCES CRM_TIPOSCONTATOS (ID_TIPOCONTATO);
ALTER TABLE CRM_ESTADOS ADD CONSTRAINT R_1013 FOREIGN KEY (ID_REGIAO) REFERENCES CRM_REGIOES (ID_REGIAO);
ALTER TABLE CRM_ESTADOS ADD CONSTRAINT R_1015 FOREIGN KEY (ID_PAIS) REFERENCES CRM_PAISES (ID_PAIS);
ALTER TABLE CRM_FORNECEDORES_HISTORICO ADD CONSTRAINT R_2513 FOREIGN KEY (ID_SITUACAO) REFERENCES CRM_SITUACOES (ID_SITUACAO);
ALTER TABLE CRM_FORNECEDORES_HISTORICO ADD CONSTRAINT R_2514 FOREIGN KEY (ID_ACAO) REFERENCES CRM_ACOES (ID_ACAO);
ALTER TABLE CRM_FORNECEDORES_HISTORICO ADD CONSTRAINT R_308 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE CRM_FORNECEDORES_HISTORICO ADD CONSTRAINT R_844 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE CRM_PAISES ADD CONSTRAINT R_2494 FOREIGN KEY (ID_REGIAO) REFERENCES CRM_REGIOES (ID_REGIAO);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT R_2315 FOREIGN KEY (ID_SEGMENTO) REFERENCES CRM_SEGMENTOS (ID_SEGMENTO);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT R_2319 FOREIGN KEY (ID_ORIGEM) REFERENCES CRM_ORIGENS (ID_ORIGEM);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT R_2322 FOREIGN KEY (ID_ATIVIDADE) REFERENCES CRM_ATIVIDADES (ID_ATIVIDADE);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT R_2382 FOREIGN KEY (ID_ATENDENTE) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT R_2483 FOREIGN KEY (ID_PORTE) REFERENCES CRM_PORTE (ID_PORTE);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT R_2486 FOREIGN KEY (ID_PERFIL) REFERENCES CRM_PERFISPOTENCIAIS (ID_PERFIL);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT R_2524 FOREIGN KEY (ID_TIPOCONTATO) REFERENCES CRM_TIPOSCONTATOS (ID_TIPOCONTATO);
ALTER TABLE CRM_POTENCIAIS ADD CONSTRAINT R_2660 FOREIGN KEY (ID_AREA) REFERENCES CRM_AREAS (ID_AREA);
ALTER TABLE CRM_POTENCIAIS_CONTATOS ADD CONSTRAINT R_2381 FOREIGN KEY (ID_POTENCIAL) REFERENCES CRM_POTENCIAIS (ID_POTENCIAL);
ALTER TABLE CRM_POTENCIAIS_HISTORICO ADD CONSTRAINT R_2320 FOREIGN KEY (ID_POTENCIAL) REFERENCES CRM_POTENCIAIS (ID_POTENCIAL);
ALTER TABLE CRM_POTENCIAIS_HISTORICO ADD CONSTRAINT R_2497 FOREIGN KEY (ID_ACAO) REFERENCES CRM_ACOES (ID_ACAO);
ALTER TABLE CRM_POTENCIAIS_HISTORICO ADD CONSTRAINT R_2499 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE CRM_POTENCIAIS_HISTORICO ADD CONSTRAINT R_2504 FOREIGN KEY (ID_SITUACAO) REFERENCES CRM_SITUACOES (ID_SITUACAO);
ALTER TABLE CTR_ADIANTAMENTOS_CHEQUES ADD CONSTRAINT R_2914 FOREIGN KEY (ID_ADIANTAMENTO) REFERENCES CTR_ADIANTAMENTOS (ID_ADIANTAMENTO);
ALTER TABLE CTR_BANCARIO ADD CONSTRAINT R_2414 FOREIGN KEY (ID_CONTABANCARIA) REFERENCES CTR_CONTASBANCARIAS (ID_CONTABANCARIA);
ALTER TABLE CTR_BANCARIO ADD CONSTRAINT R_2900 FOREIGN KEY (ID_PERIODO) REFERENCES CTR_BANCARIO_PERIODOS (ID_PERIODO);
ALTER TABLE CTR_BANCARIO_PERIODOS ADD CONSTRAINT R_2903 FOREIGN KEY (ID_CONTABANCARIA) REFERENCES CTR_CONTASBANCARIAS (ID_CONTABANCARIA);
ALTER TABLE CTR_CAIXA ADD CONSTRAINT R_2413 FOREIGN KEY (ID_CONTACAIXA) REFERENCES CTR_CONTASCAIXA (ID_CONTACAIXA);
ALTER TABLE CTR_CAIXA ADD CONSTRAINT R_2901 FOREIGN KEY (ID_PERIODO) REFERENCES CTR_CAIXA_PERIODOS (ID_PERIODO);
ALTER TABLE CTR_CAIXA_PERIODOS ADD CONSTRAINT R_2902 FOREIGN KEY (ID_CONTACAIXA) REFERENCES CTR_CONTASCAIXA (ID_CONTACAIXA);
ALTER TABLE CTR_CHEQUES ADD CONSTRAINT R_158 FOREIGN KEY (ID_CONTABANCARIA) REFERENCES CTR_CONTASBANCARIAS (ID_CONTABANCARIA);
ALTER TABLE CTR_CHEQUES ADD CONSTRAINT R_910 FOREIGN KEY (ID_TIPOPAGAMENTO) REFERENCES CTR_TIPOSPAGAMENTO (ID_TIPOPAGAMENTO);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2316 FOREIGN KEY (ID_SEGMENTO) REFERENCES CRM_SEGMENTOS (ID_SEGMENTO);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2321 FOREIGN KEY (ID_ATIVIDADE) REFERENCES CRM_ATIVIDADES (ID_ATIVIDADE);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2324 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2449 FOREIGN KEY (ID_PLANOCONTA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2450 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2527 FOREIGN KEY (ID_TIPOCONTATO) REFERENCES CRM_TIPOSCONTATOS (ID_TIPOCONTATO);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2531 FOREIGN KEY (ID_POTENCIAL) REFERENCES CRM_POTENCIAIS (ID_POTENCIAL);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2661 FOREIGN KEY (ID_AREA) REFERENCES CRM_AREAS (ID_AREA);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2842 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2859 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2888 FOREIGN KEY (ID_CONDOMINIO) REFERENCES CAB_CONDOMINIOS (ID_CONDOMINIO);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2894 FOREIGN KEY (ID_CONTA_DEBITO) REFERENCES CTR_CONTASBANCARIAS (ID_CONTABANCARIA);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2896 FOREIGN KEY (ID_ROTA) REFERENCES STR_ROTAS (ID_ROTA);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_2908 FOREIGN KEY (ID_INDICACAO) REFERENCES STR_INDICACOES (ID_INDICACAO);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_723 FOREIGN KEY (ID_PERFIL) REFERENCES CRM_PERFISCLIENTES (ID_PERFIL);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_760 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE CTR_CLIENTES ADD CONSTRAINT R_761 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_CLIENTES_BANCOS ADD CONSTRAINT R_2300 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_CHEQUES ADD CONSTRAINT R_2869 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_COMERCIAIS ADD CONSTRAINT R_2301 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_CONTATOS ADD CONSTRAINT R_625 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_CONVENIOS ADD CONSTRAINT R_2392 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE CTR_CLIENTES_CONVENIOS ADD CONSTRAINT R_2393 FOREIGN KEY (ID_TIPORECEBIMENTO) REFERENCES CTR_TIPOSRECEBIMENTO (ID_TIPORECEBIMENTO);
ALTER TABLE CTR_CLIENTES_CONVENIOS ADD CONSTRAINT R_2394 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_CLIENTES_CONVENIOS ADD CONSTRAINT R_2395 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_CONVENIOS ADD CONSTRAINT R_2396 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE CTR_CLIENTES_CONVENIOS ADD CONSTRAINT R_2397 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_CLIENTES_DIVISOES ADD CONSTRAINT R_2863 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_RELACOES ADD CONSTRAINT R_2787 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_RELACOES ADD CONSTRAINT R_2790 FOREIGN KEY (ID_RELACAO) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CLIENTES_SPC ADD CONSTRAINT R_2892 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CONTASBANCARIAS ADD CONSTRAINT R_2007 FOREIGN KEY (ID_PLANOCONTA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_CONTASBANCARIAS ADD CONSTRAINT R_2518 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE CTR_CONTASBANCARIAS ADD CONSTRAINT R_2519 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_CONTASBANCARIAS ADD CONSTRAINT R_955 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_CONTASCAIXA ADD CONSTRAINT R_2640 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_CONTASCAIXA ADD CONSTRAINT R_855 FOREIGN KEY (ID_PLANOCONTA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_CONTASCAIXA ADD CONSTRAINT R_856 FOREIGN KEY (ID_USUARIO_CAIXA) REFERENCES SIS_USUARIOS (ID_USUARIO);
ALTER TABLE CTR_CONTRATOS_CLIENTES ADD CONSTRAINT R_1024 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_CONTRATOS_CLIENTES ADD CONSTRAINT R_923 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE CTR_CONTRATOS_CLIENTES ADD CONSTRAINT R_988 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_CONTRATOS_CLIENTES ADD CONSTRAINT R_989 FOREIGN KEY (ID_TIPORECEBIMENTO) REFERENCES CTR_TIPOSRECEBIMENTO (ID_TIPORECEBIMENTO);
ALTER TABLE CTR_CONTRATOS_CLIENTES ADD CONSTRAINT R_990 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_CONTRATOS_CLIENTES ADD CONSTRAINT R_991 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE CTR_CONTRATOS_CLIENTES ADD CONSTRAINT R_992 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_CONTRATOS_FORNECEDORES ADD CONSTRAINT R_924 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE CTR_FORMASRECEBIMENTO ADD CONSTRAINT R_2475 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE CTR_FORMASRECEBIMENTO ADD CONSTRAINT R_2490 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_FORMASRECEBIMENTO ADD CONSTRAINT R_2491 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_FORMASRECEBIMENTO ADD CONSTRAINT R_2492 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_FORMASRECEBIMENTO ADD CONSTRAINT R_2626 FOREIGN KEY (ID_CONTA_CORRENTE) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_FORMASRECEBIMENTO_PRAZOS ADD CONSTRAINT R_2672 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_FORMASRECEBIMENTO_PRAZOS ADD CONSTRAINT R_2673 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE CTR_FORMASRECEBIMENTO_TAXAS ADD CONSTRAINT R_2891 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_2004 FOREIGN KEY (ID_PLANOCONTA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_2325 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_2326 FOREIGN KEY (ID_SEGMENTO) REFERENCES CRM_SEGMENTOS (ID_SEGMENTO);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_2369 FOREIGN KEY (ID_ATIVIDADE) REFERENCES CRM_ATIVIDADES (ID_ATIVIDADE);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_2451 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_2452 FOREIGN KEY (ID_PLANOCONTA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_2526 FOREIGN KEY (ID_TIPOCONTATO) REFERENCES CRM_TIPOSCONTATOS (ID_TIPOCONTATO);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_2843 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_724 FOREIGN KEY (ID_PERFIL) REFERENCES CRM_PERFISFORNECEDORES (ID_PERFIL);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_770 FOREIGN KEY (ID_PRAZOPAGAMENTO) REFERENCES CTR_PRAZOSPAGAMENTO (ID_PRAZOPAGAMENTO);
ALTER TABLE CTR_FORNECEDORES ADD CONSTRAINT R_772 FOREIGN KEY (ID_FORMAPAGAMENTO) REFERENCES CTR_FORMASPAGAMENTO (ID_FORMAPAGAMENTO);
ALTER TABLE CTR_FORNECEDORES_BANCOS ADD CONSTRAINT R_727 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE CTR_FORNECEDORES_COMERCIAIS ADD CONSTRAINT R_728 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE CTR_FORNECEDORES_CONTATOS ADD CONSTRAINT R_621 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE CTR_INDICES_PERCENTUAIS ADD CONSTRAINT R_2663 FOREIGN KEY (ID_INDICE) REFERENCES CTR_INDICES (ID_INDICE);
ALTER TABLE CTR_REMESSAS ADD CONSTRAINT R_2573 FOREIGN KEY (ID_CONTABANCARIA) REFERENCES CTR_CONTASBANCARIAS (ID_CONTABANCARIA);
ALTER TABLE CTR_MOEDAS_COTACOES ADD CONSTRAINT R_2576 FOREIGN KEY (ID_MOEDA) REFERENCES CTR_MOEDAS (ID_MOEDA);
ALTER TABLE CTR_ORCAMENTOS_PLANOCONTA ADD CONSTRAINT R_2484 FOREIGN KEY (ID_ANO) REFERENCES CTR_ORCAMENTOS_ANOS (ID_ANO);
ALTER TABLE CTR_ORCAMENTOS_PLANOCONTA ADD CONSTRAINT R_2485 FOREIGN KEY (ID_PLANOCONTA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_10 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_2835 FOREIGN KEY (ID_PRAZOPAGAMENTO) REFERENCES CTR_PRAZOSPAGAMENTO (ID_PRAZOPAGAMENTO);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_7 FOREIGN KEY (ID_CHEQUE) REFERENCES CTR_CHEQUES (ID_CHEQUE);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_739 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_773 FOREIGN KEY (ID_FORMA_DEBITO) REFERENCES CTR_FORMASPAGAMENTO (ID_FORMAPAGAMENTO);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_774 FOREIGN KEY (ID_FORMA_CREDITO) REFERENCES CTR_FORMASPAGAMENTO (ID_FORMAPAGAMENTO);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_875 FOREIGN KEY (ID_TIPOPAGAMENTO) REFERENCES CTR_TIPOSPAGAMENTO (ID_TIPOPAGAMENTO);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_96 FOREIGN KEY (ID_CONTA_DEBITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_PAGAMENTOS ADD CONSTRAINT R_97 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_PAGAMENTOS_CUSTOS ADD CONSTRAINT R_2432 FOREIGN KEY (ID_PAGAMENTO) REFERENCES CTR_PAGAMENTOS (ID_PAGAMENTO);
ALTER TABLE CTR_PAGAMENTOS_CUSTOS ADD CONSTRAINT R_2433 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_PAGAMENTOS_CUSTOS ADD CONSTRAINT R_2434 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_PATRIMONIO ADD CONSTRAINT R_2375 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_PATRIMONIO ADD CONSTRAINT R_2378 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE CTR_PATRIMONIO_HISTORICO ADD CONSTRAINT R_2376 FOREIGN KEY (ID_PATRIMONIO) REFERENCES CTR_PATRIMONIO (ID_PATRIMONIO);
ALTER TABLE CTR_PATRIMONIO_HISTORICO ADD CONSTRAINT R_2377 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_PATRIMONIO_MANUTENCAO ADD CONSTRAINT R_2398 FOREIGN KEY (ID_PATRIMONIO) REFERENCES CTR_PATRIMONIO (ID_PATRIMONIO);
ALTER TABLE CTR_PREVISOES_DESPESAS ADD CONSTRAINT R_925 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_PREVISOES_DESPESAS ADD CONSTRAINT R_926 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_PREVISOES_RECEITAS ADD CONSTRAINT R_927 FOREIGN KEY (ID_CONTA_DEBITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_PREVISOES_RECEITAS ADD CONSTRAINT R_928 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_2005 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_2006 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_2391 FOREIGN KEY (ID_CONVENIO) REFERENCES CTR_CLIENTES_CONVENIOS (ID_CONVENIO);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_2786 FOREIGN KEY (ID_ALINEA_1) REFERENCES CTR_ALINEAS (ID_ALINEA);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_2800 FOREIGN KEY (ID_ALINEA_2) REFERENCES CTR_ALINEAS (ID_ALINEA);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_2836 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_309 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_740 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_762 FOREIGN KEY (ID_FORMA_DEBITO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_764 FOREIGN KEY (ID_FORMA_CREDITO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_876 FOREIGN KEY (ID_TIPORECEBIMENTO) REFERENCES CTR_TIPOSRECEBIMENTO (ID_TIPORECEBIMENTO);
ALTER TABLE CTR_RECEBIMENTOS ADD CONSTRAINT R_99 FOREIGN KEY (ID_CONTA_DEBITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_RECEBIMENTOS_CUSTOS ADD CONSTRAINT R_2429 FOREIGN KEY (ID_RECEBIMENTO) REFERENCES CTR_RECEBIMENTOS (ID_RECEBIMENTO);
ALTER TABLE CTR_RECEBIMENTOS_CUSTOS ADD CONSTRAINT R_2430 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_RECEBIMENTOS_CUSTOS ADD CONSTRAINT R_2431 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE CTR_TALOES ADD CONSTRAINT R_2797 FOREIGN KEY (ID_CONTABANCARIA) REFERENCES CTR_CONTASBANCARIAS (ID_CONTABANCARIA);
ALTER TABLE CTR_TRANSFERENCIAS ADD CONSTRAINT R_829 FOREIGN KEY (ID_CHEQUE) REFERENCES CTR_CHEQUES (ID_CHEQUE);
ALTER TABLE CTR_TRANSFERENCIAS ADD CONSTRAINT R_830 FOREIGN KEY (ID_CONTA_DEBITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_TRANSFERENCIAS ADD CONSTRAINT R_831 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE CTR_TRANSFERENCIAS ADD CONSTRAINT R_873 FOREIGN KEY (ID_FORMAPAGAMENTO) REFERENCES CTR_FORMASPAGAMENTO (ID_FORMAPAGAMENTO);
ALTER TABLE CTR_TRANSFERENCIAS ADD CONSTRAINT R_874 FOREIGN KEY (ID_TIPOPAGAMENTO) REFERENCES CTR_TIPOSPAGAMENTO (ID_TIPOPAGAMENTO);
ALTER TABLE FAC_CONFIGURACAO ADD CONSTRAINT R_837 FOREIGN KEY (ID_FUNCAO_OPERADOR) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE FAC_ENTRADAS ADD CONSTRAINT R_2884 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE FAC_ENTRADAS_PRODUTOS ADD CONSTRAINT R_2870 FOREIGN KEY (ID_ENTRADA) REFERENCES FAC_ENTRADAS (ID_ENTRADA);
ALTER TABLE FAC_ENTRADAS_PRODUTOS ADD CONSTRAINT R_2877 FOREIGN KEY (ID_ORDEM) REFERENCES FAC_ORDENS (ID_ORDEM);
ALTER TABLE FAC_ENTRADAS_PRODUTOS ADD CONSTRAINT R_2885 FOREIGN KEY (ID_RETORNO) REFERENCES FAC_RETORNOS (ID_RETORNO);
ALTER TABLE FAC_OPERADORES ADD CONSTRAINT R_2721 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE FAC_ORDENS ADD CONSTRAINT R_2327 FOREIGN KEY (ID_ESTOQUE_ENTRADA) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE FAC_ORDENS ADD CONSTRAINT R_2354 FOREIGN KEY (ID_TIPOORDEM) REFERENCES FAC_TIPOSORDENS (ID_TIPOORDEM);
ALTER TABLE FAC_ORDENS ADD CONSTRAINT R_262 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE FAC_ORDENS ADD CONSTRAINT R_2879 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE FAC_ORDENS ADD CONSTRAINT R_854 FOREIGN KEY (ID_ESTOQUE_SAIDA) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE FAC_ORDENS_BAIXAS ADD CONSTRAINT R_2919 FOREIGN KEY (ID_PARADA) REFERENCES FAC_PARADAS (ID_PARADA);
ALTER TABLE FAC_ORDENS_BAIXAS ADD CONSTRAINT R_2920 FOREIGN KEY (ID_OPERACAO) REFERENCES FAC_OPERACOES (ID_OPERACAO);
ALTER TABLE FAC_ORDENS_BAIXAS ADD CONSTRAINT R_2922 FOREIGN KEY (ID_MAQUINA) REFERENCES FAC_MAQUINAS (ID_MAQUINA);
ALTER TABLE FAC_ORDENS_BAIXAS ADD CONSTRAINT R_2925 FOREIGN KEY (ID_PROCESSO) REFERENCES FAC_ORDENS_PROCESSOS (ID_PROCESSO);
ALTER TABLE FAC_ORDENS_BAIXAS ADD CONSTRAINT R_2926 FOREIGN KEY (ID_OPERADOR) REFERENCES FAC_OPERADORES (ID_OPERADOR);
ALTER TABLE FAC_ORDENS_COMPOSICAO ADD CONSTRAINT R_618 FOREIGN KEY (ID_ORDEM) REFERENCES FAC_ORDENS (ID_ORDEM);
ALTER TABLE FAC_ORDENS_COMPOSICAO ADD CONSTRAINT R_842 FOREIGN KEY (ID_COMPONENTE) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE FAC_ORDENS_PARCIAIS ADD CONSTRAINT R_2890 FOREIGN KEY (ID_ORDEM) REFERENCES FAC_ORDENS (ID_ORDEM);
ALTER TABLE FAC_ORDENS_PARTES ADD CONSTRAINT R_2917 FOREIGN KEY (ID_ORDEM) REFERENCES FAC_ORDENS (ID_ORDEM);
ALTER TABLE FAC_ORDENS_PROCESSOS ADD CONSTRAINT R_2719 FOREIGN KEY (ID_FERRAMENTA) REFERENCES FAC_FERRAMENTAS (ID_FERRAMENTA);
ALTER TABLE FAC_ORDENS_PROCESSOS ADD CONSTRAINT R_2924 FOREIGN KEY (ID_PARTE) REFERENCES FAC_ORDENS_PARTES (ID_PARTE);
ALTER TABLE FAC_ORDENS_PROCESSOS ADD CONSTRAINT R_827 FOREIGN KEY (ID_MAQUINA) REFERENCES FAC_MAQUINAS (ID_MAQUINA);
ALTER TABLE FAC_ORDENS_PROCESSOS ADD CONSTRAINT R_828 FOREIGN KEY (ID_OPERACAO) REFERENCES FAC_OPERACOES (ID_OPERACAO);
ALTER TABLE FAC_PRODUTOS_COMPOSICAO ADD CONSTRAINT R_834 FOREIGN KEY (ID_COMPONENTE) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE FAC_PRODUTOS_COMPOSICAO ADD CONSTRAINT R_843 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE FAC_PRODUTOS_PROCESSOS ADD CONSTRAINT R_2718 FOREIGN KEY (ID_FERRAMENTA) REFERENCES FAC_FERRAMENTAS (ID_FERRAMENTA);
ALTER TABLE FAC_PRODUTOS_PROCESSOS ADD CONSTRAINT R_824 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE FAC_PRODUTOS_PROCESSOS ADD CONSTRAINT R_825 FOREIGN KEY (ID_OPERACAO) REFERENCES FAC_OPERACOES (ID_OPERACAO);
ALTER TABLE FAC_PRODUTOS_PROCESSOS ADD CONSTRAINT R_826 FOREIGN KEY (ID_MAQUINA) REFERENCES FAC_MAQUINAS (ID_MAQUINA);
ALTER TABLE FAC_RETORNOS ADD CONSTRAINT R_2882 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE FAC_RETORNOS ADD CONSTRAINT R_2883 FOREIGN KEY (ID_VENDA) REFERENCES STR_VENDAS (ID_VENDA);
ALTER TABLE GRP_ATENDENTES ADD CONSTRAINT R_2560 FOREIGN KEY (ID_ATENDENTE) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE GRP_ATENDENTES ADD CONSTRAINT R_2725 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE GRP_OPERADORES ADD CONSTRAINT R_2559 FOREIGN KEY (ID_OPERADOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE GRP_ORCAMENTOS ADD CONSTRAINT R_2595 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE GRP_ORCAMENTOS_ACABAMENTO ADD CONSTRAINT R_2587 FOREIGN KEY (ID_ACABAMENTO) REFERENCES GRP_ACABAMENTOS (ID_ACABAMENTO);
ALTER TABLE GRP_ORCAMENTOS_ACABAMENTO ADD CONSTRAINT R_2687 FOREIGN KEY (ID_ORCAMENTO) REFERENCES GRP_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE GRP_ORCAMENTOS_IMPRESSORAS ADD CONSTRAINT R_2588 FOREIGN KEY (ID_IMPRESSORA) REFERENCES GRP_IMPRESSORAS (ID_IMPRESSORA);
ALTER TABLE GRP_ORCAMENTOS_IMPRESSORAS ADD CONSTRAINT R_2686 FOREIGN KEY (ID_ORCAMENTO) REFERENCES GRP_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE GRP_ORCAMENTOS_PAPEIS ADD CONSTRAINT R_2684 FOREIGN KEY (ID_ORCAMENTO) REFERENCES GRP_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE GRP_ORCAMENTOS_QUANTIDADES ADD CONSTRAINT R_2682 FOREIGN KEY (ID_ORCAMENTO) REFERENCES GRP_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE GRP_ORCAMENTOS_QUANTIDADES ADD CONSTRAINT R_2688 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES GRP_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE GRP_ORCAMENTOS_SERVICOS ADD CONSTRAINT R_2689 FOREIGN KEY (ID_ORCAMENTO) REFERENCES GRP_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE GRP_ORCAMENTOS_SERVICOS ADD CONSTRAINT R_2724 FOREIGN KEY (ID_SERVICO) REFERENCES GRP_SERVICOS (ID_SERVICO);
ALTER TABLE GRP_ORCAMENTOS_TINTAS ADD CONSTRAINT R_2685 FOREIGN KEY (ID_ORCAMENTO) REFERENCES GRP_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE GRP_ORDENS ADD CONSTRAINT R_2557 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE GRP_ORDENS ADD CONSTRAINT R_2561 FOREIGN KEY (ID_ATENDENTE) REFERENCES GRP_ATENDENTES (ID_ATENDENTE);
ALTER TABLE GRP_ORDENS_ACABAMENTO ADD CONSTRAINT R_2550 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES GRP_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE GRP_ORDENS_ACABAMENTO ADD CONSTRAINT R_2558 FOREIGN KEY (ID_OPERADOR) REFERENCES GRP_OPERADORES (ID_OPERADOR);
ALTER TABLE GRP_ORDENS_ACABAMENTO ADD CONSTRAINT R_2586 FOREIGN KEY (ID_ACABAMENTO) REFERENCES GRP_ACABAMENTOS (ID_ACABAMENTO);
ALTER TABLE GRP_ORDENS_IMPRESSORAS ADD CONSTRAINT R_2547 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES GRP_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE GRP_ORDENS_IMPRESSORAS ADD CONSTRAINT R_2585 FOREIGN KEY (ID_IMPRESSORA) REFERENCES GRP_IMPRESSORAS (ID_IMPRESSORA);
ALTER TABLE GRP_ORDENS_PAPEIS ADD CONSTRAINT R_2546 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES GRP_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE GRP_ORDENS_PAPEIS ADD CONSTRAINT R_2551 FOREIGN KEY (ID_PAPEL) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE GRP_ORDENS_PAPEIS ADD CONSTRAINT R_2553 FOREIGN KEY (ID_FORMATO) REFERENCES STR_PRODUTOS_FORMATOS (ID_FORMATO);
ALTER TABLE GRP_ORDENS_SERVICOS ADD CONSTRAINT R_2691 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES GRP_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE GRP_ORDENS_SERVICOS ADD CONSTRAINT R_2692 FOREIGN KEY (ID_SERVICO) REFERENCES SRV_SERVICOS (ID_SERVICO);
ALTER TABLE GRP_ORDENS_SERVICOS ADD CONSTRAINT R_2723 FOREIGN KEY (ID_SERVICO) REFERENCES GRP_SERVICOS (ID_SERVICO);
ALTER TABLE GRP_ORDENS_TINTAS ADD CONSTRAINT R_2548 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES GRP_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE GRP_ORDENS_TINTAS ADD CONSTRAINT R_2554 FOREIGN KEY (ID_TINTA) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE HDS_CONFIGURACAO ADD CONSTRAINT R_2778 FOREIGN KEY (ID_CLASSE_TRATAMENTO) REFERENCES STR_CLASSES (ID_CLASSE);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT R_2358 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT R_2359 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT R_2363 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT R_2364 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT R_2365 FOREIGN KEY (ID_TIPORECEBIMENTO) REFERENCES CTR_TIPOSRECEBIMENTO (ID_TIPORECEBIMENTO);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT R_2366 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT R_2367 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE HDS_CONTRATOS ADD CONSTRAINT R_2766 FOREIGN KEY (ID_NATUREZA) REFERENCES SRV_NATUREZA (ID_NATUREZA);
ALTER TABLE HDS_CONTRATOS_EQUIPAMENTOS ADD CONSTRAINT R_2361 FOREIGN KEY (ID_CONTRATO) REFERENCES HDS_CONTRATOS (ID_CONTRATO);
ALTER TABLE HDS_CONTRATOS_EQUIPAMENTOS ADD CONSTRAINT R_2458 FOREIGN KEY (ID_PATRIMONIO) REFERENCES CTR_PATRIMONIO (ID_PATRIMONIO);
ALTER TABLE HDS_CONTRATOS_FUNCIONARIOS ADD CONSTRAINT R_2368 FOREIGN KEY (ID_CONTRATO) REFERENCES HDS_CONTRATOS (ID_CONTRATO);
ALTER TABLE HDS_CONTRATOS_FUNCIONARIOS ADD CONSTRAINT R_2459 FOREIGN KEY (ID_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HDS_CONTRATOS_INSUMOS ADD CONSTRAINT R_2666 FOREIGN KEY (ID_CONTRATO) REFERENCES HDS_CONTRATOS (ID_CONTRATO);
ALTER TABLE HDS_CONTRATOS_PRODUTOS ADD CONSTRAINT R_2353 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE HDS_CONTRATOS_PRODUTOS ADD CONSTRAINT R_2362 FOREIGN KEY (ID_CONTRATO) REFERENCES HDS_CONTRATOS (ID_CONTRATO);
ALTER TABLE HDS_CONTRATOS_SERVICOS ADD CONSTRAINT R_2667 FOREIGN KEY (ID_CONTRATO) REFERENCES HDS_CONTRATOS (ID_CONTRATO);
ALTER TABLE HDS_ORCAMENTOS ADD CONSTRAINT R_2621 FOREIGN KEY (ID_ENCARGO) REFERENCES HMN_ENCARGOS (ID_ENCARGO);
ALTER TABLE HDS_ORCAMENTOS ADD CONSTRAINT R_2623 FOREIGN KEY (ID_POTENCIAL) REFERENCES CRM_POTENCIAIS (ID_POTENCIAL);
ALTER TABLE HDS_ORCAMENTOS_FUNCIONARIOS ADD CONSTRAINT R_2607 FOREIGN KEY (ID_ORCAMENTO) REFERENCES HDS_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE HDS_ORCAMENTOS_FUNCIONARIOS ADD CONSTRAINT R_2612 FOREIGN KEY (ID_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HDS_ORCAMENTOS_IMPOSTOS ADD CONSTRAINT R_2769 FOREIGN KEY (ID_ORCAMENTO) REFERENCES HDS_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE HDS_ORCAMENTOS_IMPOSTOS ADD CONSTRAINT R_2771 FOREIGN KEY (ID_IMPOSTO) REFERENCES CTR_IMPOSTOS (ID_IMPOSTO);
ALTER TABLE HDS_ORCAMENTOS_MAQUINAS ADD CONSTRAINT R_2608 FOREIGN KEY (ID_ORCAMENTO) REFERENCES HDS_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE HDS_ORCAMENTOS_MAQUINAS ADD CONSTRAINT R_2615 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE HDS_ORCAMENTOS_MATERIAIS ADD CONSTRAINT R_2611 FOREIGN KEY (ID_ORCAMENTO) REFERENCES HDS_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE HDS_ORCAMENTOS_MATERIAIS ADD CONSTRAINT R_2614 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE HDS_ORCAMENTOS_OUTROS ADD CONSTRAINT R_2617 FOREIGN KEY (ID_ORCAMENTO) REFERENCES HDS_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE HDS_ORCAMENTOS_TRANSPORTES ADD CONSTRAINT R_2770 FOREIGN KEY (ID_ITEM) REFERENCES HDS_ORCAMENTOS_FUNCIONARIOS (ID_ITEM);
ALTER TABLE HDS_ORCAMENTOS_TRANSPORTES ADD CONSTRAINT R_2772 FOREIGN KEY (ID_TRANSPORTE) REFERENCES HMN_TRANSPORTES (ID_TRANSPORTE);
ALTER TABLE HDS_ORCAMENTOS_TRATAMENTO ADD CONSTRAINT R_2610 FOREIGN KEY (ID_ORCAMENTO) REFERENCES HDS_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE HDS_ORCAMENTOS_TRATAMENTO ADD CONSTRAINT R_2622 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE HDS_ORCAMENTOS_UNIFORMES ADD CONSTRAINT R_2609 FOREIGN KEY (ID_ORCAMENTO) REFERENCES HDS_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE HDS_ORCAMENTOS_UNIFORMES ADD CONSTRAINT R_2613 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE HMN_APONTAMENTOS ADD CONSTRAINT R_304 FOREIGN KEY (ID_JUSTIFICATIVA) REFERENCES HMN_JUSTIFICATIVAS (ID_JUSTIFICATIVA);
ALTER TABLE HMN_APONTAMENTOS ADD CONSTRAINT R_659 FOREIGN KEY (ID_PERIODO) REFERENCES HMN_PERIODOS (ID_PERIODO);
ALTER TABLE HMN_APONTAMENTOS ADD CONSTRAINT R_73 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT R_1008 FOREIGN KEY (ID_E3_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT R_1009 FOREIGN KEY (ID_E1_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT R_1010 FOREIGN KEY (ID_E2_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT R_704 FOREIGN KEY (ID_FUNCAO_1) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT R_977 FOREIGN KEY (ID_FORMACAO) REFERENCES HMN_FORMACAO (ID_FORMACAO);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT R_978 FOREIGN KEY (ID_ESCOLARIDADE) REFERENCES HMN_ESCOLARIDADE (ID_ESCOLARIDADE);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT R_981 FOREIGN KEY (ID_FUNCAO_2) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HMN_CANDIDATOS ADD CONSTRAINT R_982 FOREIGN KEY (ID_ESTADOCIVIL) REFERENCES HMN_ESTADOCIVIL (ID_ESTADOCIVIL);
ALTER TABLE HMN_CANDIDATOS_TESTES ADD CONSTRAINT R_706 FOREIGN KEY (ID_CANDIDATO) REFERENCES HMN_CANDIDATOS (ID_CANDIDATO);
ALTER TABLE HMN_CANDIDATOS_TESTES ADD CONSTRAINT R_707 FOREIGN KEY (ID_TESTE) REFERENCES HMN_TESTES (ID_TESTE);
ALTER TABLE HMN_ENCARGOS_DEMISSIONAIS ADD CONSTRAINT R_2620 FOREIGN KEY (ID_ENCARGO) REFERENCES HMN_ENCARGOS (ID_ENCARGO);
ALTER TABLE HMN_ENCARGOS_SOCIAIS ADD CONSTRAINT R_2618 FOREIGN KEY (ID_ENCARGO) REFERENCES HMN_ENCARGOS (ID_ENCARGO);
ALTER TABLE HMN_ENCARGOS_TRABALHISTAS ADD CONSTRAINT R_2619 FOREIGN KEY (ID_ENCARGO) REFERENCES HMN_ENCARGOS (ID_ENCARGO);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_2525 FOREIGN KEY (ID_TIPOCONTATO) REFERENCES CRM_TIPOSCONTATOS (ID_TIPOCONTATO);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_2768 FOREIGN KEY (ID_ENCARGO) REFERENCES HMN_ENCARGOS (ID_ENCARGO);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_302 FOREIGN KEY (ID_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_31 FOREIGN KEY (ID_SETOR) REFERENCES HMN_SETORES (ID_SETOR);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_743 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_88 FOREIGN KEY (ID_HORARIO) REFERENCES HMN_HORARIOS (ID_HORARIO);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_979 FOREIGN KEY (ID_FORMACAO) REFERENCES HMN_FORMACAO (ID_FORMACAO);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_980 FOREIGN KEY (ID_ESCOLARIDADE) REFERENCES HMN_ESCOLARIDADE (ID_ESCOLARIDADE);
ALTER TABLE HMN_FUNCIONARIOS ADD CONSTRAINT R_983 FOREIGN KEY (ID_ESTADOCIVIL) REFERENCES HMN_ESTADOCIVIL (ID_ESTADOCIVIL);
ALTER TABLE HMN_FUNCIONARIOS_AFASTAMENTOS ADD CONSTRAINT R_868 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_AFASTAMENTOS ADD CONSTRAINT R_869 FOREIGN KEY (ID_JUSTIFICATIVA) REFERENCES HMN_JUSTIFICATIVAS (ID_JUSTIFICATIVA);
ALTER TABLE HMN_FUNCIONARIOS_ATESTADOS ADD CONSTRAINT R_734 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_CENTROSCUSTO ADD CONSTRAINT R_2480 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE HMN_FUNCIONARIOS_CENTROSCUSTO ADD CONSTRAINT R_2481 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_DEPENDENTES ADD CONSTRAINT R_732 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_HABILIDADES ADD CONSTRAINT FK_HMN_FUNCIONARIOS_HABIL_01 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_HABILIDADES ADD CONSTRAINT FK_HMN_FUNCIONARIOS_HABIL_02 FOREIGN KEY (ID_HABILIDADE) REFERENCES HMN_HABILIDADES (ID_HABILIDADE);
ALTER TABLE HMN_FUNCIONARIOS_HISTORICO ADD CONSTRAINT R_2372 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE HMN_FUNCIONARIOS_HISTORICO ADD CONSTRAINT R_2373 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_HISTORICO ADD CONSTRAINT R_2374 FOREIGN KEY (ID_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HMN_FUNCIONARIOS_HORARIOS ADD CONSTRAINT R_85 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_TOTAIS ADD CONSTRAINT R_283 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_FUNCIONARIOS_UNIFORMES ADD CONSTRAINT R_733 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_HORARIOS_DIAS ADD CONSTRAINT R_84 FOREIGN KEY (ID_HORARIO) REFERENCES HMN_HORARIOS (ID_HORARIO);
ALTER TABLE HMN_OCORRENCIAS ADD CONSTRAINT R_159 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE HMN_OCORRENCIAS ADD CONSTRAINT R_160 FOREIGN KEY (ID_EVENTO) REFERENCES HMN_EVENTOS (ID_EVENTO);
ALTER TABLE HMN_VAGAS ADD CONSTRAINT R_976 FOREIGN KEY (ID_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE HMN_VAGAS ADD CONSTRAINT R_984 FOREIGN KEY (ID_FORMACAO) REFERENCES HMN_FORMACAO (ID_FORMACAO);
ALTER TABLE HMN_VAGAS ADD CONSTRAINT R_985 FOREIGN KEY (ID_ESCOLARIDADE) REFERENCES HMN_ESCOLARIDADE (ID_ESCOLARIDADE);
ALTER TABLE HMN_VAGAS_CANDIDATOS ADD CONSTRAINT R_1019 FOREIGN KEY (ID_VAGA) REFERENCES HMN_VAGAS (ID_VAGA);
ALTER TABLE HMN_VAGAS_CANDIDATOS ADD CONSTRAINT R_1020 FOREIGN KEY (ID_CANDIDATO) REFERENCES HMN_CANDIDATOS (ID_CANDIDATO);
ALTER TABLE LIB_ARTIGOS_ASSUNTOS ADD CONSTRAINT R_946 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_ARTIGOS (ID_PUBLICACAO);
ALTER TABLE LIB_ARTIGOS_ASSUNTOS ADD CONSTRAINT R_947 FOREIGN KEY (ID_ASSUNTO) REFERENCES LIB_ASSUNTOS (ID_ASSUNTO);
ALTER TABLE LIB_ARTIGOS_AUTORES ADD CONSTRAINT R_966 FOREIGN KEY (ID_AUTOR) REFERENCES LIB_AUTORES (ID_AUTOR);
ALTER TABLE LIB_ARTIGOS_AUTORES ADD CONSTRAINT R_967 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_ARTIGOS (ID_PUBLICACAO);
ALTER TABLE LIB_ARTIGOS_IMAGENS ADD CONSTRAINT R_974 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_ARTIGOS (ID_PUBLICACAO);
ALTER TABLE LIB_DOCUMENTOS_ASSUNTOS ADD CONSTRAINT R_957 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_DOCUMENTOS (ID_PUBLICACAO);
ALTER TABLE LIB_DOCUMENTOS_ASSUNTOS ADD CONSTRAINT R_958 FOREIGN KEY (ID_ASSUNTO) REFERENCES LIB_ASSUNTOS (ID_ASSUNTO);
ALTER TABLE LIB_DOCUMENTOS_AUTORES ADD CONSTRAINT R_964 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_DOCUMENTOS (ID_PUBLICACAO);
ALTER TABLE LIB_DOCUMENTOS_AUTORES ADD CONSTRAINT R_965 FOREIGN KEY (ID_AUTOR) REFERENCES LIB_AUTORES (ID_AUTOR);
ALTER TABLE LIB_DOCUMENTOS_IMAGENS ADD CONSTRAINT R_972 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_DOCUMENTOS (ID_PUBLICACAO);
ALTER TABLE LIB_EMPRESTIMOS ADD CONSTRAINT R_821 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE LIB_EMPRESTIMOS ADD CONSTRAINT R_822 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE LIB_LIVROS ADD CONSTRAINT R_54 FOREIGN KEY (ID_EDITORA) REFERENCES LIB_EDITORAS (ID_EDITORA);
ALTER TABLE LIB_LIVROS ADD CONSTRAINT R_61 FOREIGN KEY (ID_COLECAO) REFERENCES LIB_COLECOES (ID_COLECAO);
ALTER TABLE LIB_LIVROS ADD CONSTRAINT R_79 FOREIGN KEY (ID_LOCAL) REFERENCES LIB_LOCAIS (ID_LOCAL);
ALTER TABLE LIB_LIVROS_ASSUNTOS ADD CONSTRAINT R_68 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_LIVROS (ID_PUBLICACAO);
ALTER TABLE LIB_LIVROS_ASSUNTOS ADD CONSTRAINT R_69 FOREIGN KEY (ID_ASSUNTO) REFERENCES LIB_ASSUNTOS (ID_ASSUNTO);
ALTER TABLE LIB_LIVROS_AUTORES ADD CONSTRAINT R_66 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_LIVROS (ID_PUBLICACAO);
ALTER TABLE LIB_LIVROS_AUTORES ADD CONSTRAINT R_67 FOREIGN KEY (ID_AUTOR) REFERENCES LIB_AUTORES (ID_AUTOR);
ALTER TABLE LIB_LIVROS_IMAGENS ADD CONSTRAINT R_975 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_LIVROS (ID_PUBLICACAO);
ALTER TABLE LIB_MIDIAS ADD CONSTRAINT R_938 FOREIGN KEY (ID_EDITORA) REFERENCES LIB_EDITORAS (ID_EDITORA);
ALTER TABLE LIB_MIDIAS ADD CONSTRAINT R_939 FOREIGN KEY (ID_LOCAL) REFERENCES LIB_LOCAIS (ID_LOCAL);
ALTER TABLE LIB_MIDIAS ADD CONSTRAINT R_940 FOREIGN KEY (ID_COLECAO) REFERENCES LIB_COLECOES (ID_COLECAO);
ALTER TABLE LIB_MIDIAS_ASSUNTOS ADD CONSTRAINT R_959 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_MIDIAS (ID_PUBLICACAO);
ALTER TABLE LIB_MIDIAS_ASSUNTOS ADD CONSTRAINT R_960 FOREIGN KEY (ID_ASSUNTO) REFERENCES LIB_ASSUNTOS (ID_ASSUNTO);
ALTER TABLE LIB_MIDIAS_AUTORES ADD CONSTRAINT R_944 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_MIDIAS (ID_PUBLICACAO);
ALTER TABLE LIB_MIDIAS_AUTORES ADD CONSTRAINT R_945 FOREIGN KEY (ID_AUTOR) REFERENCES LIB_AUTORES (ID_AUTOR);
ALTER TABLE LIB_MIDIAS_CONTEUDO ADD CONSTRAINT R_819 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_MIDIAS (ID_PUBLICACAO);
ALTER TABLE LIB_MIDIAS_IMAGENS ADD CONSTRAINT R_971 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_MIDIAS (ID_PUBLICACAO);
ALTER TABLE LIB_PERIODICOS_ASSUNTOS ADD CONSTRAINT R_963 FOREIGN KEY (ID_ASSUNTO) REFERENCES LIB_ASSUNTOS (ID_ASSUNTO);
ALTER TABLE LIB_PERIODICOS_ASSUNTOS ADD CONSTRAINT R_968 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_PERIODICOS_EDICOES (ID_PUBLICACAO);
ALTER TABLE LIB_PERIODICOS_AUTORES ADD CONSTRAINT R_969 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_PERIODICOS_EDICOES (ID_PUBLICACAO);
ALTER TABLE LIB_PERIODICOS_AUTORES ADD CONSTRAINT R_970 FOREIGN KEY (ID_AUTOR) REFERENCES LIB_AUTORES (ID_AUTOR);
ALTER TABLE LIB_PERIODICOS_EDICOES ADD CONSTRAINT R_55 FOREIGN KEY (ID_PERIODICO) REFERENCES LIB_PERIODICOS_TITULOS (ID_PERIODICO);
ALTER TABLE LIB_PERIODICOS_IMAGENS ADD CONSTRAINT R_973 FOREIGN KEY (ID_PUBLICACAO) REFERENCES LIB_PERIODICOS_EDICOES (ID_PUBLICACAO);
ALTER TABLE LIV_CONFIGURACAO ADD CONSTRAINT R_2412 FOREIGN KEY (ID_FUNCAO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE LWR_ADVOGADOS ADD CONSTRAINT R_2575 FOREIGN KEY (ID_ADVOGADO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE LWR_ANDAMENTO ADD CONSTRAINT R_166 FOREIGN KEY (ID_PROCESSO) REFERENCES LWR_PROCESSOS (ID_PROCESSO);
ALTER TABLE LWR_CONFIGURACAO ADD CONSTRAINT R_170 FOREIGN KEY (ID_FUNCAO_ADVOGADO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE LWR_CONFIGURACAO ADD CONSTRAINT R_882 FOREIGN KEY (ID_FUNCAO_ESTAGIARIO) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE LWR_ESTAGIARIOS ADD CONSTRAINT R_2574 FOREIGN KEY (ID_ESTAGIARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE LWR_PROCESSOS ADD CONSTRAINT R_165 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE LWR_PROCESSOS ADD CONSTRAINT R_167 FOREIGN KEY (ID_ADVOGADO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE LWR_PROCESSOS ADD CONSTRAINT R_168 FOREIGN KEY (ID_JUIZO) REFERENCES LWR_JUIZOS (ID_JUIZO);
ALTER TABLE LWR_PROCESSOS ADD CONSTRAINT R_169 FOREIGN KEY (ID_ACAO) REFERENCES LWR_ACOES (ID_ACAO);
ALTER TABLE LWR_PROCESSOS ADD CONSTRAINT R_172 FOREIGN KEY (ID_FASE) REFERENCES LWR_FASES (ID_FASE);
ALTER TABLE PDV_VENDA_PRODUTOS ADD CONSTRAINT R_2653 FOREIGN KEY (ID_VENDA) REFERENCES PDV_VENDA (ID_VENDA);
ALTER TABLE SCH_ALUNOS_MATERIAL ADD CONSTRAINT R_2565 FOREIGN KEY (ID_CONVENIO) REFERENCES SCH_CONVENIOS (ID_CONVENIO);
ALTER TABLE SCH_ALUNOS_MATERIAL ADD CONSTRAINT R_2580 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SCH_ALUNOS_TAXAS ADD CONSTRAINT R_2564 FOREIGN KEY (ID_CONVENIO) REFERENCES SCH_CONVENIOS (ID_CONVENIO);
ALTER TABLE SCH_ALUNOS_TAXAS ADD CONSTRAINT R_2578 FOREIGN KEY (ID_RECEBIMENTO) REFERENCES CTR_RECEBIMENTOS (ID_RECEBIMENTO);
ALTER TABLE SCH_ALUNOS_TAXAS ADD CONSTRAINT R_2579 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SCH_AVALIACOES ADD CONSTRAINT R_2722 FOREIGN KEY (ID_NIVEL) REFERENCES SCH_NIVEIS (ID_NIVEL);
ALTER TABLE SCH_AVALIACOES_DISCIPLINAS ADD CONSTRAINT R_2707 FOREIGN KEY (ID_AVALIACAO) REFERENCES SCH_AVALIACOES (ID_AVALIACAO);
ALTER TABLE SCH_AVALIACOES_QUESTOES ADD CONSTRAINT R_2506 FOREIGN KEY (ID_AVALIACAO) REFERENCES SCH_AVALIACOES (ID_AVALIACAO);
ALTER TABLE SCH_AVALIACOES_QUESTOES ADD CONSTRAINT R_2507 FOREIGN KEY (ID_QUESTAO) REFERENCES SCH_QUESTOES (ID_QUESTAO);
ALTER TABLE SCH_CONFIGURACAO ADD CONSTRAINT R_204 FOREIGN KEY (ID_FUNCAO_PROFESSOR) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE SCH_CONFIGURACAO ADD CONSTRAINT R_2453 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE SCH_CONVENIOS ADD CONSTRAINT R_2520 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SCH_CONVENIOS ADD CONSTRAINT R_2567 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE SCH_CONVENIOS ADD CONSTRAINT R_2568 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE SCH_CONVENIOS ADD CONSTRAINT R_2569 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE SCH_CONVENIOS ADD CONSTRAINT R_2570 FOREIGN KEY (ID_TIPORECEBIMENTO) REFERENCES CTR_TIPOSRECEBIMENTO (ID_TIPORECEBIMENTO);
ALTER TABLE SCH_CONVENIOS ADD CONSTRAINT R_2571 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE SCH_CURSOS_DISCIPLINAS ADD CONSTRAINT R_2511 FOREIGN KEY (ID_DISCIPLINA) REFERENCES SCH_DISCIPLINAS (ID_DISCIPLINA);
ALTER TABLE SCH_CURSOS_DISCIPLINAS ADD CONSTRAINT R_2605 FOREIGN KEY (ID_NIVEL) REFERENCES SCH_NIVEIS (ID_NIVEL);
ALTER TABLE SCH_DISCIPLINAS_TOPICOS ADD CONSTRAINT R_2472 FOREIGN KEY (ID_DISCIPLINA) REFERENCES SCH_DISCIPLINAS (ID_DISCIPLINA);
ALTER TABLE SCH_FREQUENCIAS ADD CONSTRAINT R_919 FOREIGN KEY (ID_ALUNO) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SCH_HISTORICO ADD CONSTRAINT R_1033 FOREIGN KEY (ID_ALUNO) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SCH_HISTORICO_DISCIPLINAS ADD CONSTRAINT R_1034 FOREIGN KEY (ID_HISTORICO) REFERENCES SCH_HISTORICO (ID_HISTORICO);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_1000 FOREIGN KEY (ID_NIVEL) REFERENCES SCH_NIVEIS (ID_NIVEL);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_2383 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_2385 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_2387 FOREIGN KEY (ID_TIPORECEBIMENTO) REFERENCES CTR_TIPOSRECEBIMENTO (ID_TIPORECEBIMENTO);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_2388 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_2389 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_2390 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_2521 FOREIGN KEY (ID_CONVENIO) REFERENCES SCH_CONVENIOS (ID_CONVENIO);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_915 FOREIGN KEY (ID_ALUNO) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_916 FOREIGN KEY (ID_CURSO) REFERENCES SCH_CURSOS (ID_CURSO);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_917 FOREIGN KEY (ID_TURMA) REFERENCES SCH_TURMAS (ID_TURMA);
ALTER TABLE SCH_MATRICULAS ADD CONSTRAINT R_918 FOREIGN KEY (ID_PERIODO) REFERENCES SCH_PERIODOS (ID_PERIODO);
ALTER TABLE SCH_NIVEIS ADD CONSTRAINT R_34 FOREIGN KEY (ID_CURSO) REFERENCES SCH_CURSOS (ID_CURSO);
ALTER TABLE SCH_PAUTA ADD CONSTRAINT R_1001 FOREIGN KEY (ID_MATRICULA) REFERENCES SCH_MATRICULAS (ID_MATRICULA);
ALTER TABLE SCH_PAUTA ADD CONSTRAINT R_38 FOREIGN KEY (ID_DISCIPLINA) REFERENCES SCH_DISCIPLINAS (ID_DISCIPLINA);
ALTER TABLE SCH_PERGUNTAS_RESPOSTAS ADD CONSTRAINT R_2502 FOREIGN KEY (ID_QUESTAO) REFERENCES SCH_QUESTOES (ID_QUESTAO);
ALTER TABLE SCH_PROFESSORES ADD CONSTRAINT R_2566 FOREIGN KEY (ID_PROFESSOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SCH_QUESTOES ADD CONSTRAINT R_2501 FOREIGN KEY (ID_DISCIPLINA) REFERENCES SCH_DISCIPLINAS (ID_DISCIPLINA);
ALTER TABLE SCH_QUESTOES ADD CONSTRAINT R_2604 FOREIGN KEY (ID_DISCIPLINA, ID_NIVEL) REFERENCES SCH_CURSOS_DISCIPLINAS (ID_DISCIPLINA, ID_NIVEL);
ALTER TABLE SCH_QUESTOES ADD CONSTRAINT R_2732 FOREIGN KEY (ID_CURSO) REFERENCES SCH_CURSOS (ID_CURSO);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_2380 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_2508 FOREIGN KEY (ID_PROFESSOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_2516 FOREIGN KEY (ID_LOCAL) REFERENCES SCH_LOCAIS (ID_LOCAL);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_2517 FOREIGN KEY (ID_DIA) REFERENCES SCH_DIAS (ID_DIA);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_2522 FOREIGN KEY (ID_CONVENIO) REFERENCES SCH_CONVENIOS (ID_CONVENIO);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_41 FOREIGN KEY (ID_CURSO) REFERENCES SCH_CURSOS (ID_CURSO);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_42 FOREIGN KEY (ID_NIVEL) REFERENCES SCH_NIVEIS (ID_NIVEL);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_651 FOREIGN KEY (ID_PERIODO) REFERENCES SCH_PERIODOS (ID_PERIODO);
ALTER TABLE SCH_TURMAS ADD CONSTRAINT R_930 FOREIGN KEY (ID_SALA) REFERENCES SCH_SALAS (ID_SALA);
ALTER TABLE SCH_TURMAS_CALENDARIOS ADD CONSTRAINT R_2512 FOREIGN KEY (ID_TURMA) REFERENCES SCH_TURMAS (ID_TURMA);
ALTER TABLE SCH_TURMAS_DISCIPLINAS ADD CONSTRAINT R_920 FOREIGN KEY (ID_TURMA) REFERENCES SCH_TURMAS (ID_TURMA);
ALTER TABLE SCH_TURMAS_DISCIPLINAS ADD CONSTRAINT R_921 FOREIGN KEY (ID_DISCIPLINA) REFERENCES SCH_DISCIPLINAS (ID_DISCIPLINA);
ALTER TABLE SCH_TURMAS_DISCIPLINAS ADD CONSTRAINT R_922 FOREIGN KEY (ID_PROFESSOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SCH_TURMAS_HORARIOS ADD CONSTRAINT R_646 FOREIGN KEY (ID_TURMA) REFERENCES SCH_TURMAS (ID_TURMA);
ALTER TABLE SCH_TURMAS_HORARIOS ADD CONSTRAINT R_647 FOREIGN KEY (ID_PROFESSOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SCH_TURMAS_HORARIOS ADD CONSTRAINT R_648 FOREIGN KEY (ID_DISCIPLINA) REFERENCES SCH_DISCIPLINAS (ID_DISCIPLINA);
ALTER TABLE SHP_CONSULTAS ADD CONSTRAINT R_2823 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE SHP_CONSULTAS_PRODUTOS ADD CONSTRAINT R_2822 FOREIGN KEY (ID_CONSULTA) REFERENCES SHP_CONSULTAS (ID_CONSULTA);
ALTER TABLE SHP_CONSULTAS_PRODUTOS ADD CONSTRAINT R_2824 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE SIS_GRUPOS_ACESSOS ADD CONSTRAINT R_1021 FOREIGN KEY (ID_GRUPO) REFERENCES SIS_GRUPOS (ID_GRUPO);
ALTER TABLE SIS_GRUPOS_ACESSOS ADD CONSTRAINT R_1022 FOREIGN KEY (ID_ACESSO) REFERENCES SIS_ACESSOS (ID_ACESSO);
ALTER TABLE SIS_USUARIOS ADD CONSTRAINT R_1023 FOREIGN KEY (ID_GRUPO) REFERENCES SIS_GRUPOS (ID_GRUPO);
ALTER TABLE SIS_USUARIOS ADD CONSTRAINT R_690 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SIS_USUARIOS_ACESSOS ADD CONSTRAINT R_2572 FOREIGN KEY (ID_USUARIO) REFERENCES SIS_USUARIOS (ID_USUARIO);
ALTER TABLE SIS_USUARIOS_EMAIL ADD CONSTRAINT R_2841 FOREIGN KEY (ID_USUARIO) REFERENCES SIS_USUARIOS (ID_USUARIO);
ALTER TABLE SRV_CONFIGURACAO ADD CONSTRAINT R_907 FOREIGN KEY (ID_FUNCAO_OPERADOR) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE SRV_CONTRATOS ADD CONSTRAINT R_2898 FOREIGN KEY (ID_VENDEDOR) REFERENCES SRV_VENDEDORES (ID_VENDEDOR);
ALTER TABLE SRV_CONTRATOS ADD CONSTRAINT R_2899 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SRV_CONTRATOS_SERVICOS ADD CONSTRAINT R_2897 FOREIGN KEY (ID_CONTRATO) REFERENCES SRV_CONTRATOS (ID_CONTRATO);
ALTER TABLE SRV_EQUIPAMENTOS ADD CONSTRAINT R_2528 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_1002 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_1004 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_1005 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_1006 FOREIGN KEY (ID_VENDEDOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_1007 FOREIGN KEY (ID_COMISSAO) REFERENCES STR_COMISSOES (ID_COMISSAO);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_2532 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_2545 FOREIGN KEY (ID_SERIE) REFERENCES SRV_SERIES (ID_SERIE);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_2765 FOREIGN KEY (ID_NATUREZA) REFERENCES SRV_NATUREZA (ID_NATUREZA);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_866 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_867 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_995 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE SRV_NOTAS ADD CONSTRAINT R_996 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES SRV_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE SRV_NOTAS_PRODUTOS ADD CONSTRAINT R_2656 FOREIGN KEY (ID_NOTA) REFERENCES SRV_NOTAS (ID_NOTA);
ALTER TABLE SRV_NOTAS_PRODUTOS ADD CONSTRAINT R_2657 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE SRV_NOTAS_SERVICOS ADD CONSTRAINT R_864 FOREIGN KEY (ID_NOTA) REFERENCES SRV_NOTAS (ID_NOTA);
ALTER TABLE SRV_NOTAS_SERVICOS ADD CONSTRAINT R_865 FOREIGN KEY (ID_SERVICO) REFERENCES SRV_SERVICOS (ID_SERVICO);
ALTER TABLE SRV_ORCAMENTOS ADD CONSTRAINT R_1028 FOREIGN KEY (ID_VENDEDOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SRV_ORCAMENTOS ADD CONSTRAINT R_1029 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE SRV_ORCAMENTOS ADD CONSTRAINT R_1032 FOREIGN KEY (ID_VENDEDOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SRV_ORCAMENTOS ADD CONSTRAINT R_891 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE SRV_ORCAMENTOS ADD CONSTRAINT R_892 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SRV_ORCAMENTOS ADD CONSTRAINT R_998 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE SRV_ORCAMENTOS ADD CONSTRAINT R_999 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE SRV_ORCAMENTOS_PRODUTOS ADD CONSTRAINT R_993 FOREIGN KEY (ID_ORCAMENTO) REFERENCES SRV_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE SRV_ORCAMENTOS_PRODUTOS ADD CONSTRAINT R_994 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE SRV_ORCAMENTOS_SERVICOS ADD CONSTRAINT R_897 FOREIGN KEY (ID_ORCAMENTO) REFERENCES SRV_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE SRV_ORCAMENTOS_SERVICOS ADD CONSTRAINT R_899 FOREIGN KEY (ID_SERVICO) REFERENCES SRV_SERVICOS (ID_SERVICO);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_1003 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_1030 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_1031 FOREIGN KEY (ID_VENDEDOR) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_2529 FOREIGN KEY (ID_EQUIPAMENTO) REFERENCES SRV_EQUIPAMENTOS (ID_EQUIPAMENTO);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_2530 FOREIGN KEY (ID_TIPOORDEM) REFERENCES SRV_TIPOSORDENS (ID_TIPOORDEM);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_256 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_2632 FOREIGN KEY (ID_CFOP) REFERENCES STR_CFOP (ID_CFOP);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_2767 FOREIGN KEY (ID_VEICULO) REFERENCES SRV_VEICULOS (ID_VEICULO);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_913 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_914 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE SRV_ORDENS ADD CONSTRAINT R_997 FOREIGN KEY (ID_ORCAMENTO) REFERENCES SRV_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE SRV_ORDENS_HISTORICO ADD CONSTRAINT R_859 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES SRV_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE SRV_ORDENS_PRODUTOS ADD CONSTRAINT R_259 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES SRV_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE SRV_ORDENS_PRODUTOS ADD CONSTRAINT R_275 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE SRV_ORDENS_SERVICOS ADD CONSTRAINT R_2808 FOREIGN KEY (ID_TECNICO) REFERENCES SRV_TECNICOS (ID_TECNICO);
ALTER TABLE SRV_ORDENS_SERVICOS ADD CONSTRAINT R_857 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES SRV_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE SRV_ORDENS_SERVICOS ADD CONSTRAINT R_898 FOREIGN KEY (ID_SERVICO) REFERENCES SRV_SERVICOS (ID_SERVICO);
ALTER TABLE SRV_TECNICOS ADD CONSTRAINT R_2542 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE SRV_VEICULOS ADD CONSTRAINT R_2641 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE STR_ALIQUOTAS_CFOP ADD CONSTRAINT R_2867 FOREIGN KEY (ID_ALIQUOTA) REFERENCES STR_ALIQUOTAS (ID_ALIQUOTA);
ALTER TABLE STR_CLIENTES_CLASSES ADD CONSTRAINT R_2851 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE STR_CLIENTES_PRODUTOS ADD CONSTRAINT R_2849 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE STR_CLIENTES_PRODUTOS ADD CONSTRAINT R_2850 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_133 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_190 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_2337 FOREIGN KEY (ID_CFOP) REFERENCES STR_CFOP (ID_CFOP);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_2423 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_777 FOREIGN KEY (ID_ORDEMCOMPRA) REFERENCES STR_ORDENSCOMPRA (ID_ORDEMCOMPRA);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_778 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_780 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_787 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_791 FOREIGN KEY (ID_PRAZOPAGAMENTO) REFERENCES CTR_PRAZOSPAGAMENTO (ID_PRAZOPAGAMENTO);
ALTER TABLE STR_COMPRAS ADD CONSTRAINT R_796 FOREIGN KEY (ID_FORMAPAGAMENTO) REFERENCES CTR_FORMASPAGAMENTO (ID_FORMAPAGAMENTO);
ALTER TABLE STR_COMPRAS_ORDENSCOMPRA ADD CONSTRAINT R_2427 FOREIGN KEY (ID_ORDEMCOMPRA) REFERENCES STR_ORDENSCOMPRA (ID_ORDEMCOMPRA);
ALTER TABLE STR_COMPRAS_ORDENSCOMPRA ADD CONSTRAINT R_2428 FOREIGN KEY (ID_COMPRA) REFERENCES STR_COMPRAS (ID_COMPRA);
ALTER TABLE STR_COMPRAS_PRODUTOS ADD CONSTRAINT R_2311 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_COMPRAS_PRODUTOS ADD CONSTRAINT R_2601 FOREIGN KEY (ID_ORDEMCOMPRA) REFERENCES STR_ORDENSCOMPRA (ID_ORDEMCOMPRA);
ALTER TABLE STR_COMPRAS_PRODUTOS ADD CONSTRAINT R_315 FOREIGN KEY (ID_COMPRA) REFERENCES STR_COMPRAS (ID_COMPRA);
ALTER TABLE STR_CONFIGURACAO ADD CONSTRAINT R_148 FOREIGN KEY (ID_FUNCAO_VENDEDOR) REFERENCES HMN_FUNCOES (ID_FUNCAO);
ALTER TABLE STR_CONFIGURACAO ADD CONSTRAINT R_155 FOREIGN KEY (ID_ESTOQUE_VENDA) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_CONFIGURACAO ADD CONSTRAINT R_156 FOREIGN KEY (ID_ESTOQUE_COMPRA) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_CONFIGURACAO ADD CONSTRAINT R_2402 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_CONFIGURACAO ADD CONSTRAINT R_2806 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_CONFIGURACAO ADD CONSTRAINT R_2807 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE STR_CONVENIOS ADD CONSTRAINT R_2488 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE STR_CONVENIOS ADD CONSTRAINT R_2489 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE STR_COTACOES ADD CONSTRAINT R_266 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE STR_COTACOES ADD CONSTRAINT R_271 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE STR_COTACOES ADD CONSTRAINT R_667 FOREIGN KEY (ID_REQUISICAO) REFERENCES STR_REQUISICOES (ID_REQUISICAO);
ALTER TABLE STR_COTACOES ADD CONSTRAINT R_793 FOREIGN KEY (ID_PRAZOPAGAMENTO) REFERENCES CTR_PRAZOSPAGAMENTO (ID_PRAZOPAGAMENTO);
ALTER TABLE STR_COTACOES ADD CONSTRAINT R_794 FOREIGN KEY (ID_FORMAPAGAMENTO) REFERENCES CTR_FORMASPAGAMENTO (ID_FORMAPAGAMENTO);
ALTER TABLE STR_COTACOES ADD CONSTRAINT R_951 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_COTACOES ADD CONSTRAINT R_954 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_COTACOES_PRODUTOS ADD CONSTRAINT R_265 FOREIGN KEY (ID_COTACAO) REFERENCES STR_COTACOES (ID_COTACAO);
ALTER TABLE STR_COTACOES_PRODUTOS ADD CONSTRAINT R_285 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_DEVOLUCOES ADD CONSTRAINT R_2408 FOREIGN KEY (ID_VENDA) REFERENCES STR_VENDAS (ID_VENDA);
ALTER TABLE STR_DEVOLUCOES ADD CONSTRAINT R_883 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_DEVOLUCOES ADD CONSTRAINT R_884 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE STR_DEVOLUCOES ADD CONSTRAINT R_885 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_DEVOLUCOES ADD CONSTRAINT R_903 FOREIGN KEY (ID_COMISSAO) REFERENCES STR_COMISSOES (ID_COMISSAO);
ALTER TABLE STR_DEVOLUCOES_PRODUTOS ADD CONSTRAINT R_878 FOREIGN KEY (ID_DEVOLUCAO) REFERENCES STR_DEVOLUCOES (ID_DEVOLUCAO);
ALTER TABLE STR_DEVOLUCOES_PRODUTOS ADD CONSTRAINT R_879 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_ENTRADAS ADD CONSTRAINT R_2334 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_ENTRADAS ADD CONSTRAINT R_2335 FOREIGN KEY (ID_HISTORICO) REFERENCES STR_HISTORICO (ID_HISTORICO);
ALTER TABLE STR_ENTRADAS ADD CONSTRAINT R_2336 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_ENTRADAS ADD CONSTRAINT R_814 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_ENTRADAS_PRODUTOS ADD CONSTRAINT R_811 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_ENTRADAS_PRODUTOS ADD CONSTRAINT R_812 FOREIGN KEY (ID_ENTRADA) REFERENCES STR_ENTRADAS (ID_ENTRADA);
ALTER TABLE STR_ESTOQUES ADD CONSTRAINT R_805 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_GRUPOS ADD CONSTRAINT R_932 FOREIGN KEY (ID_CLASSE) REFERENCES STR_CLASSES (ID_CLASSE);
ALTER TABLE STR_INVENTARIO ADD CONSTRAINT R_2422 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_INVENTARIO ADD CONSTRAINT R_788 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_INVENTARIO_PRODUTOS ADD CONSTRAINT R_789 FOREIGN KEY (ID_INVENTARIO) REFERENCES STR_INVENTARIO (ID_INVENTARIO);
ALTER TABLE STR_INVENTARIO_PRODUTOS ADD CONSTRAINT R_790 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_LOJAS ADD CONSTRAINT R_2418 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT R_196 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT R_2424 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT R_2730 FOREIGN KEY (ID_VENDEDOR) REFERENCES STR_VENDEDORES (ID_VENDEDOR);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT R_2864 FOREIGN KEY (ID_DIVISAO) REFERENCES CTR_CLIENTES_DIVISOES (ID_DIVISAO);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT R_320 FOREIGN KEY (ID_COMISSAO) REFERENCES STR_COMISSOES (ID_COMISSAO);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT R_428 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT R_798 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE STR_ORCAMENTOS ADD CONSTRAINT R_801 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE STR_ORCAMENTOS_COMPONENTES ADD CONSTRAINT R_2906 FOREIGN KEY (ID_ITEM) REFERENCES STR_ORCAMENTOS_PRODUTOS (ID_ITEM);
ALTER TABLE STR_ORCAMENTOS_COMPONENTES ADD CONSTRAINT R_2907 FOREIGN KEY (ID_COMPONENTE) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_ORCAMENTOS_PRODUTOS ADD CONSTRAINT R_2812 FOREIGN KEY (ID_APLICACAO) REFERENCES STR_PRODUTOS_APLICACOES (ID_APLICACAO);
ALTER TABLE STR_ORCAMENTOS_PRODUTOS ADD CONSTRAINT R_2830 FOREIGN KEY (ID_ACABAMENTO) REFERENCES STR_ACABAMENTOS (ID_ACABAMENTO);
ALTER TABLE STR_ORCAMENTOS_PRODUTOS ADD CONSTRAINT R_422 FOREIGN KEY (ID_ORCAMENTO) REFERENCES STR_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE STR_ORCAMENTOS_PRODUTOS ADD CONSTRAINT R_423 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_2379 FOREIGN KEY (ID_REQUISICAO) REFERENCES STR_REQUISICOES (ID_REQUISICAO);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_768 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_769 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_781 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_782 FOREIGN KEY (ID_COTACAO) REFERENCES STR_COTACOES (ID_COTACAO);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_792 FOREIGN KEY (ID_PRAZOPAGAMENTO) REFERENCES CTR_PRAZOSPAGAMENTO (ID_PRAZOPAGAMENTO);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_795 FOREIGN KEY (ID_FORMAPAGAMENTO) REFERENCES CTR_FORMASPAGAMENTO (ID_FORMAPAGAMENTO);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_850 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_851 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_ORDENSCOMPRA ADD CONSTRAINT R_952 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_ORDENSCOMPRA_PRODUTOS ADD CONSTRAINT R_2600 FOREIGN KEY (ID_COMPRA) REFERENCES STR_COMPRAS (ID_COMPRA);
ALTER TABLE STR_ORDENSCOMPRA_PRODUTOS ADD CONSTRAINT R_766 FOREIGN KEY (ID_ORDEMCOMPRA) REFERENCES STR_ORDENSCOMPRA (ID_ORDEMCOMPRA);
ALTER TABLE STR_ORDENSCOMPRA_PRODUTOS ADD CONSTRAINT R_767 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_129 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_197 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_2425 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_2631 FOREIGN KEY (ID_CFOP) REFERENCES STR_CFOP (ID_CFOP);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_2729 FOREIGN KEY (ID_VENDEDOR) REFERENCES STR_VENDEDORES (ID_VENDEDOR);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_2784 FOREIGN KEY (ID_FABRICANTE) REFERENCES STR_FABRICANTES (ID_FABRICANTE);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_2865 FOREIGN KEY (ID_DIVISAO) REFERENCES CTR_CLIENTES_DIVISOES (ID_DIVISAO);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_313 FOREIGN KEY (ID_ORCAMENTO) REFERENCES STR_ORCAMENTOS (ID_ORCAMENTO);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_319 FOREIGN KEY (ID_COMISSAO) REFERENCES STR_COMISSOES (ID_COMISSAO);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_799 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_800 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_807 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_846 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_PEDIDOS ADD CONSTRAINT R_847 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE STR_PEDIDOS_COMPONENTES ADD CONSTRAINT R_2537 FOREIGN KEY (ID_ITEM) REFERENCES STR_PEDIDOS_PRODUTOS (ID_ITEM);
ALTER TABLE STR_PEDIDOS_COMPONENTES ADD CONSTRAINT R_2538 FOREIGN KEY (ID_COMPONENTE) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PEDIDOS_HISTORICO ADD CONSTRAINT R_2913 FOREIGN KEY (ID_PEDIDO) REFERENCES STR_PEDIDOS (ID_PEDIDO);
ALTER TABLE STR_PEDIDOS_PRODUTOS ADD CONSTRAINT R_135 FOREIGN KEY (ID_PEDIDO) REFERENCES STR_PEDIDOS (ID_PEDIDO);
ALTER TABLE STR_PEDIDOS_PRODUTOS ADD CONSTRAINT R_136 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PEDIDOS_PRODUTOS ADD CONSTRAINT R_2603 FOREIGN KEY (ID_VENDA) REFERENCES STR_VENDAS (ID_VENDA);
ALTER TABLE STR_PEDIDOS_PRODUTOS ADD CONSTRAINT R_2811 FOREIGN KEY (ID_APLICACAO) REFERENCES STR_PRODUTOS_APLICACOES (ID_APLICACAO);
ALTER TABLE STR_PEDIDOS_PRODUTOS ADD CONSTRAINT R_2831 FOREIGN KEY (ID_ACABAMENTO) REFERENCES STR_ACABAMENTOS (ID_ACABAMENTO);
ALTER TABLE STR_PONTOSVENDA ADD CONSTRAINT R_2669 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_PONTOSVENDA ADD CONSTRAINT R_2776 FOREIGN KEY (ID_SERIE_CUPOM) REFERENCES STR_SERIES (ID_SERIE);
ALTER TABLE STR_PONTOSVENDA ADD CONSTRAINT R_2777 FOREIGN KEY (ID_SERIE_BALCAO) REFERENCES STR_SERIES (ID_SERIE);
ALTER TABLE STR_PONTOSVENDA_CAIXAS ADD CONSTRAINT R_2910 FOREIGN KEY (ID_PONTOVENDA) REFERENCES STR_PONTOSVENDA (ID_PONTOVENDA);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_2313 FOREIGN KEY (ID_GRUPO) REFERENCES STR_GRUPOS (ID_GRUPO);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_2401 FOREIGN KEY (ID_ALIQUOTA) REFERENCES STR_ALIQUOTAS (ID_ALIQUOTA);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_2448 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_2782 FOREIGN KEY (ID_COR) REFERENCES STR_CORES (ID_COR);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_2848 FOREIGN KEY (ID_GRADE) REFERENCES STR_GRADES (ID_GRADE);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_2912 FOREIGN KEY (ID_TIPO) REFERENCES STR_TIPOS (ID_TIPO);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_610 FOREIGN KEY (ID_FABRICANTE) REFERENCES STR_FABRICANTES (ID_FABRICANTE);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_815 FOREIGN KEY (ID_CONSIGNATARIO) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE STR_PRODUTOS ADD CONSTRAINT R_933 FOREIGN KEY (ID_CLASSE) REFERENCES STR_CLASSES (ID_CLASSE);
ALTER TABLE STR_PRODUTOS_APLICACOES ADD CONSTRAINT R_2809 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_COMPONENTES ADD CONSTRAINT R_2328 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_COMPONENTES ADD CONSTRAINT R_2329 FOREIGN KEY (ID_COMPONENTE) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_COMPRAS ADD CONSTRAINT R_2844 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_EAN ADD CONSTRAINT R_2825 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_ESTOQUES ADD CONSTRAINT R_19 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_ESTOQUES ADD CONSTRAINT R_421 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_PRODUTOS_FORMATOS ADD CONSTRAINT R_2552 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_FORNECEDORES ADD CONSTRAINT R_783 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_FORNECEDORES ADD CONSTRAINT R_785 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE STR_PRODUTOS_FOTOS ADD CONSTRAINT R_937 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_LOTES ADD CONSTRAINT R_1011 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_PRECOS ADD CONSTRAINT R_2536 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_REAJUSTES ADD CONSTRAINT R_2845 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_RELACIONADOS ADD CONSTRAINT R_2654 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_RELACIONADOS ADD CONSTRAINT R_2655 FOREIGN KEY (ID_PRODUTO_RELACIONADO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_SERIES ADD CONSTRAINT R_2533 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_SERIES ADD CONSTRAINT R_2534 FOREIGN KEY (ID_VENDA) REFERENCES STR_VENDAS (ID_VENDA);
ALTER TABLE STR_PRODUTOS_SERIES ADD CONSTRAINT R_2535 FOREIGN KEY (ID_COMPRA) REFERENCES STR_COMPRAS (ID_COMPRA);
ALTER TABLE STR_PRODUTOS_SERIES ADD CONSTRAINT R_2915 FOREIGN KEY (ID_LOTE) REFERENCES STR_PRODUTOS_LOTES (ID_LOTE);
ALTER TABLE STR_PRODUTOS_SIMILARES ADD CONSTRAINT R_2826 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_PRODUTOS_SIMILARES ADD CONSTRAINT R_2827 FOREIGN KEY (ID_PRODUTO_SIMILAR) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_REQUISICOES ADD CONSTRAINT R_2637 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_REQUISICOES ADD CONSTRAINT R_950 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_REQUISICOES_PRODUTOS ADD CONSTRAINT R_665 FOREIGN KEY (ID_REQUISICAO) REFERENCES STR_REQUISICOES (ID_REQUISICAO);
ALTER TABLE STR_REQUISICOES_PRODUTOS ADD CONSTRAINT R_666 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_RETORNO ADD CONSTRAINT R_2633 FOREIGN KEY (ID_COMPRA) REFERENCES STR_COMPRAS (ID_COMPRA);
ALTER TABLE STR_RETORNO ADD CONSTRAINT R_2636 FOREIGN KEY (ID_FORNECEDOR) REFERENCES CTR_FORNECEDORES (ID_FORNECEDOR);
ALTER TABLE STR_RETORNO_PRODUTOS ADD CONSTRAINT R_2634 FOREIGN KEY (ID_RETORNO) REFERENCES STR_RETORNO (ID_RETORNO);
ALTER TABLE STR_RETORNO_PRODUTOS ADD CONSTRAINT R_2635 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_SAIDAS ADD CONSTRAINT R_2331 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_SAIDAS ADD CONSTRAINT R_2332 FOREIGN KEY (ID_HISTORICO) REFERENCES STR_HISTORICO (ID_HISTORICO);
ALTER TABLE STR_SAIDAS ADD CONSTRAINT R_2333 FOREIGN KEY (ID_CONTA_DESPESA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_SAIDAS ADD CONSTRAINT R_813 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_SAIDAS_PRODUTOS ADD CONSTRAINT R_809 FOREIGN KEY (ID_SAIDA) REFERENCES STR_SAIDAS (ID_SAIDA);
ALTER TABLE STR_SAIDAS_PRODUTOS ADD CONSTRAINT R_810 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_TABELAS ADD CONSTRAINT R_2857 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE STR_TABELAS_PRODUTOS ADD CONSTRAINT R_2858 FOREIGN KEY (ID_TABELA) REFERENCES STR_TABELAS (ID_TABELA);
ALTER TABLE STR_TABELAS_PRODUTOS ADD CONSTRAINT R_2861 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_TRANSFERENCIAS ADD CONSTRAINT R_178 FOREIGN KEY (ID_ESTOQUE_ENTRADA) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_TRANSFERENCIAS ADD CONSTRAINT R_179 FOREIGN KEY (ID_ESTOQUE_SAIDA) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_TRANSFERENCIAS ADD CONSTRAINT R_2419 FOREIGN KEY (ID_CENTROCUSTO_ENTRADA) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_TRANSFERENCIAS ADD CONSTRAINT R_2420 FOREIGN KEY (ID_CENTROCUSTO_SAIDA) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_TRANSFERENCIAS ADD CONSTRAINT R_2421 FOREIGN KEY (ID_HISTORICO) REFERENCES STR_HISTORICO (ID_HISTORICO);
ALTER TABLE STR_TRANSFERENCIAS_PRODUTOS ADD CONSTRAINT R_180 FOREIGN KEY (ID_TRANSFERENCIA) REFERENCES STR_TRANSFERENCIAS (ID_TRANSFERENCIA);
ALTER TABLE STR_TRANSFERENCIAS_PRODUTOS ADD CONSTRAINT R_181 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_TRANSPORTADORAS_CONTATOS ADD CONSTRAINT R_853 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_1017 FOREIGN KEY (ID_CFOP) REFERENCES STR_CFOP (ID_CFOP);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_127 FOREIGN KEY (ID_CLIENTE) REFERENCES CTR_CLIENTES (ID_CLIENTE);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_182 FOREIGN KEY (ID_TRANSPORTADORA) REFERENCES STR_TRANSPORTADORAS (ID_TRANSPORTADORA);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2426 FOREIGN KEY (ID_CENTROCUSTO) REFERENCES CTR_CENTROSCUSTO (ID_CENTROCUSTO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2482 FOREIGN KEY (ID_SERIE) REFERENCES STR_SERIES (ID_SERIE);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2487 FOREIGN KEY (ID_CONVENIO) REFERENCES STR_CONVENIOS (ID_CONVENIO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2704 FOREIGN KEY (ID_VENDEDOR) REFERENCES STR_VENDEDORES (ID_VENDEDOR);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2760 FOREIGN KEY (ID_PONTOVENDA) REFERENCES STR_PONTOSVENDA (ID_PONTOVENDA);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2785 FOREIGN KEY (ID_FABRICANTE) REFERENCES STR_FABRICANTES (ID_FABRICANTE);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2866 FOREIGN KEY (ID_DIVISAO) REFERENCES CTR_CLIENTES_DIVISOES (ID_DIVISAO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2895 FOREIGN KEY (ID_ROTA) REFERENCES STR_ROTAS (ID_ROTA);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_2909 FOREIGN KEY (ID_INDICACAO) REFERENCES STR_INDICACOES (ID_INDICACAO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_311 FOREIGN KEY (ID_PEDIDO) REFERENCES STR_PEDIDOS (ID_PEDIDO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_318 FOREIGN KEY (ID_COMISSAO) REFERENCES STR_COMISSOES (ID_COMISSAO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_786 FOREIGN KEY (ID_ESTOQUE) REFERENCES STR_ESTOQUES (ID_ESTOQUE);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_803 FOREIGN KEY (ID_FORMARECEBIMENTO) REFERENCES CTR_FORMASRECEBIMENTO (ID_FORMARECEBIMENTO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_804 FOREIGN KEY (ID_PRAZORECEBIMENTO) REFERENCES CTR_PRAZOSRECEBIMENTO (ID_PRAZORECEBIMENTO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_806 FOREIGN KEY (ID_CONTA_RECEITA) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_808 FOREIGN KEY (ID_TIPODOCUMENTO) REFERENCES CTR_TIPOSDOCUMENTOS (ID_TIPODOCUMENTO);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_904 FOREIGN KEY (ID_CONTA_CREDITO) REFERENCES CTR_PLANOCONTAS (ID_PLANOCONTA);
ALTER TABLE STR_VENDAS ADD CONSTRAINT R_911 FOREIGN KEY (ID_ORDEMSERVICO) REFERENCES SRV_ORDENS (ID_ORDEMSERVICO);
ALTER TABLE STR_VENDAS_COMPONENTES ADD CONSTRAINT R_2539 FOREIGN KEY (ID_ITEM) REFERENCES STR_VENDAS_PRODUTOS (ID_ITEM);
ALTER TABLE STR_VENDAS_COMPONENTES ADD CONSTRAINT R_2540 FOREIGN KEY (ID_COMPONENTE) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_VENDAS_PRODUTOS ADD CONSTRAINT R_2602 FOREIGN KEY (ID_PEDIDO) REFERENCES STR_PEDIDOS (ID_PEDIDO);
ALTER TABLE STR_VENDAS_PRODUTOS ADD CONSTRAINT R_2705 FOREIGN KEY (ID_VENDEDOR) REFERENCES STR_VENDEDORES (ID_VENDEDOR);
ALTER TABLE STR_VENDAS_PRODUTOS ADD CONSTRAINT R_2810 FOREIGN KEY (ID_APLICACAO) REFERENCES STR_PRODUTOS_APLICACOES (ID_APLICACAO);
ALTER TABLE STR_VENDAS_PRODUTOS ADD CONSTRAINT R_2832 FOREIGN KEY (ID_ACABAMENTO) REFERENCES STR_ACABAMENTOS (ID_ACABAMENTO);
ALTER TABLE STR_VENDAS_PRODUTOS ADD CONSTRAINT R_312 FOREIGN KEY (ID_PRODUTO) REFERENCES STR_PRODUTOS (ID_PRODUTO);
ALTER TABLE STR_VENDAS_PRODUTOS ADD CONSTRAINT R_521 FOREIGN KEY (ID_VENDA) REFERENCES STR_VENDAS (ID_VENDA);
ALTER TABLE STR_VENDEDORES ADD CONSTRAINT R_2671 FOREIGN KEY (ID_FUNCIONARIO) REFERENCES HMN_FUNCIONARIOS (ID_FUNCIONARIO);
ALTER TABLE STR_VENDEDORES_FABRICANTES ADD CONSTRAINT R_2833 FOREIGN KEY (ID_VENDEDOR) REFERENCES STR_VENDEDORES (ID_VENDEDOR);
ALTER TABLE STR_VENDEDORES_FABRICANTES ADD CONSTRAINT R_2834 FOREIGN KEY (ID_FABRICANTE) REFERENCES STR_FABRICANTES (ID_FABRICANTE);
ALTER TABLE STR_VENDEDORES_PDV ADD CONSTRAINT R_2773 FOREIGN KEY (ID_VENDEDOR) REFERENCES STR_VENDEDORES (ID_VENDEDOR);
ALTER TABLE STR_VENDEDORES_PDV ADD CONSTRAINT R_2774 FOREIGN KEY (ID_PONTOVENDA) REFERENCES STR_PONTOSVENDA (ID_PONTOVENDA);


/******************************************************************************/
/***                           Check constraints                            ***/
/******************************************************************************/



/******************************************************************************/
/***                                Indices                                 ***/
/******************************************************************************/



/******************************************************************************/
/***                                Triggers                                ***/
/******************************************************************************/

SET TERM ^ ;

SET TERM ; ^

/******************************************************************************/
/***                               Procedures                               ***/
/******************************************************************************/

SET TERM ^ ;

SET TERM ; ^



/******************************************************************************/
/***                          Object descriptions                           ***/
/******************************************************************************/



/* ATUALIZA A VERSAO DO BANCO DE DADOS */

INSERT INTO SIS_VERSAO(CD_VERSAO) VALUES ('2.80');
